/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.ClassModel;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.JavaAdapter;
import de.uniks.networkparser.ext.javafx.JavaBridgeFX;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SimpleEventCondition;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.xml.HTMLEntity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;

public class DiagramEditor
extends JavaAdapter
implements ObjectCondition {
    private static final String FILE404 = "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\r\n<html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL was not found on this server.</p></body></html>";
    public static final String TYPE_EXPORT = "EXPORT";
    public static final String TYPE_EXPORTALL = "EXPORTALL";
    private static final String METHOD_GENERATE = "generating";
    private String type = "EXPORT";
    private SimpleController controller;
    private Object logic;
    private SimpleEventCondition listener;
    private JavaBridgeFX bridge;
    private String file;
    private final int WIDTH = 900;
    private final int HEIGHT = 600;
    private boolean autoClose = true;

    public static boolean convertToPNG(HTMLEntity entity, String file, int ... dimension) {
        return DiagramEditor.converting(entity, file, true, true, dimension);
    }

    public static boolean convertToPNG(String url, String file, int ... dimension) {
        return DiagramEditor.converting(url, file, true, true, dimension);
    }

    public static boolean convertToPNG(File localFile, String file, int ... dimension) {
        return DiagramEditor.converting(localFile, file, true, true, dimension);
    }

    public static boolean converting(final Object entity, final String file, final boolean wait, final boolean autoClose, int ... dimension) {
        int height;
        int width;
        if (dimension != null && dimension.length > 1) {
            width = dimension[0];
            height = dimension[1];
        } else {
            width = -1;
            height = -1;
        }
        Class<?> launcherClass = ReflectionLoader.getClass("com.sun.javafx.application.LauncherImpl");
        if (launcherClass == null) {
            return false;
        }
        ReflectionLoader.call("startToolkit", launcherClass, new Object[0]);
        ReflectionLoader.call("setImplicitExit", ReflectionLoader.PLATFORM, Boolean.TYPE, false);
        JavaAdapter.executeAndWait(new Runnable(){

            @Override
            public void run() {
                Object stage = ReflectionLoader.newInstance(ReflectionLoader.STAGE, new Object[0]);
                DiagramEditor editor = new DiagramEditor();
                if (file != null) {
                    editor.file = file;
                    editor.loadHTMLEntity = true;
                    editor.autoClose = autoClose;
                }
                editor.creating(stage, entity, width, height);
                editor.withIcon(IdMap.class.getResource("np.png").toString());
                editor.show(wait);
            }
        });
        return true;
    }

    public static void main(String[] args) {
        if (!DiagramEditor.converting(null, null, false, true, new int[0])) {
            NodeProxyTCP server = NodeProxyTCP.createServer(8080);
            server.withListener(new DiagramEditor());
            if (server.start()) {
                Object desktop;
                System.out.println("LISTEN ON: " + server.getKey());
                if (ReflectionLoader.DESKTOP != null && (desktop = ReflectionLoader.call("getDesktop", ReflectionLoader.DESKTOP, new Object[0])) != null) {
                    try {
                        ReflectionLoader.call("browse", desktop, URI.class, new URI("http://" + server.getKey()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean executeWebServer(Message msg) {
        String request = msg.getMessage().toString();
        if (request.startsWith("GET")) {
            CharacterBuffer path = new CharacterBuffer();
            for (int i = 4; i < request.length() && request.charAt(i) != ' '; ++i) {
                path.with(request.charAt(i));
            }
            if (path.equals("/")) {
                HTMLEntity html = new HTMLEntity();
                html.createScript("classEditor = new ClassEditor(\"board\");", html.getBody());
                html.withHeader("drawer.js");
                html.withHeader("graph.js");
                html.withHeader("diagramstyle.css");
                String response = html.toString(2);
                this.writeHTTPResponse(msg, response, false);
            } else if (path.equalsIgnoreCase("/drawer.js")) {
                this.writeHTTPResponse(msg, FileBuffer.readResource("graph/drawer.js").toString(), false);
            } else if (path.equalsIgnoreCase("/graph.js")) {
                this.writeHTTPResponse(msg, FileBuffer.readResource("graph/graph.js").toString(), false);
            } else if (path.equalsIgnoreCase("/diagramstyle.css")) {
                this.writeHTTPResponse(msg, FileBuffer.readResource("graph/diagramstyle.css").toString(), false);
            } else {
                this.writeHTTPResponse(msg, FILE404, true);
            }
        }
        return true;
    }

    private void writeHTTPResponse(Message message, String response, boolean error) {
        if (error) {
            message.write("HTTP/1.1 404 Not Found\n");
        } else {
            message.write("HTTP/1.1 200 OK\n");
        }
        message.write("Date: " + new DateTimeEntity().toGMTString() + "\n");
        message.write("Server: Java\n");
        message.write("Last-Modified: " + new DateTimeEntity().toGMTString() + "\n");
        message.write("Content-Length: " + response.length() + "\n");
        message.write("Connection: Closed\n");
        message.write("Content-Type: text/html\n\n");
        message.write(response);
        Socket session = (Socket)message.getSession();
        try {
            session.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Message) {
            return this.executeWebServer((Message)value);
        }
        SimpleEvent evt = (SimpleEvent)value;
        if ("javafx.concurrent.Worker$State".equalsIgnoreCase(evt.getNewValue().getClass().getName())) {
            if (evt.getNewValue().toString().equals("SUCCEEDED")) {
                Object win = ReflectionLoader.call("executeScript", this.webEngine, "window");
                ReflectionLoader.call("setMember", win, String.class, "java", Object.class, this);
                this.changed(evt);
            }
            return true;
        }
        String name = (String)ReflectionLoader.callChain(value, "getEventType", "getName");
        if ("Drag_Over".equalsIgnoreCase(name)) {
            return this.onDragOver(value);
        }
        if ("Drag_Dropped".equalsIgnoreCase(name)) {
            return this.onDragDropped(value);
        }
        if ("Error".equalsIgnoreCase(name)) {
            return this.onError(value);
        }
        if ("Drag_Exited".equalsIgnoreCase(name)) {
            return this.onDragExited(value);
        }
        return false;
    }

    public void exit() {
        ReflectionLoader.call("exit", ReflectionLoader.PLATFORM, new Object[0]);
    }

    public boolean save(Object value) {
        JsonObject model = value instanceof JsonObject ? (JsonObject)value : new JsonObject().withValue((String)value);
        String name = model.getString("package");
        if (name == null || name.length() < 1) {
            name = "model";
            if (model.size() < 1) {
                return false;
            }
        }
        DateTimeEntity entity = new DateTimeEntity();
        name = name + "_" + entity.toString("yyyyMMdd_HHmmss") + ".json";
        return FileBuffer.writeFile(name, model.toString());
    }

    public void log(String value) {
        this.owner.logScript(value, 0, this, null);
    }

    public String generate(String value) {
        try {
            Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    DiagramEditor.this.saveException(e);
                }
            });
            this.generating(new JsonObject().withValue(value));
        }
        catch (Exception e) {
            this.saveException(e);
        }
        return "";
    }

    public boolean generating(JsonObject model) {
        Object result;
        if (this.listener != null) {
            SimpleEvent event = new SimpleEvent(model, METHOD_GENERATE, null, null);
            event.with(model);
            if (this.update(event)) {
                return true;
            }
        }
        if (this.logic != null && (result = ReflectionLoader.call(METHOD_GENERATE, this.logic, JsonObject.class, model)) instanceof Boolean) {
            return (Boolean)result;
        }
        if (!model.has("nodes")) {
            System.err.println("no Nodes");
            System.out.println("no Nodes");
            return false;
        }
        JsonObject nodes = model.getJsonObject("nodes");
        ClassModel classModel = new ClassModel(model.getString("package"));
        for (int i = 0; i < nodes.size(); ++i) {
            Object item = nodes.getValueByIndex(i);
            if (!(item instanceof JsonObject)) continue;
            JsonObject node = (JsonObject)item;
            Clazz clazz = classModel.createClazz(node.getString("id"));
            if (!node.has("attributes")) continue;
            JsonArray attributes = node.getJsonArray("attributes");
            for (Object entity : attributes) {
                String attribute;
                int pos;
                if (!(entity instanceof String) || (pos = (attribute = (String)entity).indexOf(":")) <= 0) continue;
                clazz.createAttribute(attribute.substring(0, pos), DataType.create(attribute.substring(pos + 1)));
            }
        }
        classModel.generate("gen");
        return true;
    }

    protected boolean onDragOver(Object event) {
        List<File> files = this.getFiles(event);
        if (files != null) {
            Object mode;
            boolean error = true;
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (name.indexOf("json", name.length() - 4) < 0) continue;
                error = false;
            }
            Object webEngine = this.owner.getWebView();
            if (!error) {
                mode = ReflectionLoader.getField("COPY", ReflectionLoader.TRANSFERMODE);
                ReflectionLoader.call("acceptTransferModes", event, ReflectionLoader.TRANSFERMODE, mode);
                ReflectionLoader.call("executeScript", webEngine, String.class, "classEditor.setBoardStyle(\"Ok\");");
            } else {
                mode = ReflectionLoader.getField("NONE", ReflectionLoader.TRANSFERMODE);
                ReflectionLoader.call("acceptTransferModes", event, ReflectionLoader.TRANSFERMODE, mode);
                ReflectionLoader.call("executeScript", webEngine, String.class, "classEditor.setBoardStyle(\"Error\");");
            }
        }
        ReflectionLoader.call("consume", event, new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onDragDropped(Object event) {
        block15: {
            List<File> files = this.getFiles(event);
            if (files == null) break block15;
            Object webEngine = this.owner.getWebView();
            Iterator<File> iterator = files.iterator();
            if (iterator.hasNext()) {
                File file = iterator.next();
                StringBuilder sb = new StringBuilder();
                byte[] buf = new byte[1024];
                FileInputStream is = null;
                try {
                    int read;
                    is = new FileInputStream(file);
                    do {
                        if ((read = is.read(buf, 0, buf.length)) <= 0) continue;
                        sb.append(new String(buf, 0, read, "UTF-8"));
                    } while (read >= 0);
                }
                catch (IOException iOException) {
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ReflectionLoader.call("executeScript", webEngine, String.class, "classEditor.dropFile('" + sb.toString() + "', \"" + file.getAbsolutePath() + "\");");
            }
        }
        return true;
    }

    protected boolean onDragExited(Object event) {
        this.owner.executeScript("classEditor.setBoardStyle(\"dragleave\");");
        return true;
    }

    protected void saveException(Object value) {
    }

    protected boolean onError(Object event) {
        System.err.println(ReflectionLoader.call("getMessage", event, new Object[0]));
        return true;
    }

    protected List<File> getFiles(Object event) {
        Object db = ReflectionLoader.call("getDragboard", event, new Object[0]);
        if (((Boolean)ReflectionLoader.call("hasFiles", db, new Object[0])).booleanValue()) {
            List files = (List)ReflectionLoader.call("getFiles", db, new Object[0]);
            return files;
        }
        return null;
    }

    @Override
    public boolean load(Object item) {
        boolean result = super.load(item);
        if (result) {
            return result;
        }
        HTMLEntity html = new HTMLEntity();
        html.createScript("classEditor = new ClassEditor(\"board\");", html.getBody());
        if (this.type.equals(TYPE_EXPORT) || this.type.equals(TYPE_EXPORTALL)) {
            if (this.type.equals(TYPE_EXPORT)) {
                html.withHeader("drawer.js");
                html.withHeader("graph.js");
                html.withHeader("diagramstyle.css");
                FileBuffer.writeFile("drawer.js", FileBuffer.readResource("graph/drawer.js"));
                FileBuffer.writeFile("graph.js", FileBuffer.readResource("graph/graph.js"));
                FileBuffer.writeFile("diagramstyle.css", FileBuffer.readResource("graph/diagramstyle.css"));
            } else {
                html.withScript(this.readFile("graph/drawer.js"), html.getHeader());
                html.withScript(this.readFile("graph/graph.js"), html.getHeader());
                html.withScript(this.readFile("graph/diagramstyle.css"), html.getHeader());
            }
            FileBuffer.writeFile("Editor.html", html.toString());
            try {
                String string = new File("Editor.html").toURI().toURL().toString();
                ReflectionLoader.call("load", this.webEngine, string);
                return true;
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        html.withScript(this.readFile("graph/drawer.js"), html.getHeader());
        html.withScript(this.readFile("graph/graph.js"), html.getHeader());
        html.withScript(this.readFile("graph/diagramstyle.css"), html.getHeader());
        ReflectionLoader.call("loadContent", this.webEngine, html.toString());
        return true;
    }

    public static DiagramEditor create(Object stage, String ... url) {
        DiagramEditor editor = new DiagramEditor();
        editor.creating(stage, url, -1, -1);
        return editor;
    }

    private DiagramEditor creating(Object stage, Object url, int width, int height) {
        SimpleKeyValueList<String, String> parameterMap;
        if (stage == null) {
            return this;
        }
        if (this.controller == null) {
            SimpleController controller;
            this.controller = controller = new SimpleController(stage);
        }
        if ((parameterMap = this.controller.getParameterMap()) != null && parameterMap.contains(TYPE_EXPORTALL)) {
            this.type = TYPE_EXPORTALL;
        }
        this.registerListener(this);
        this.load(url);
        JavaBridgeFX javaFX = new JavaBridgeFX(null, this, JavaBridgeFX.CONTENT_TYPE_NONE);
        if (width < 0) {
            width = 900;
        }
        if (height < 0) {
            height = 600;
        }
        this.controller.withTitle("ClassdiagrammEditor");
        this.controller.withSize(width, height);
        this.controller.withErrorPath("errors");
        this.bridge = javaFX;
        return this;
    }

    public void show(boolean waitFor) {
        this.controller.show(this.bridge.getWebView(), waitFor, true);
    }

    public DiagramEditor withListener(Object item) {
        this.logic = item;
        if (item instanceof SimpleEventCondition) {
            this.listener = (SimpleEventCondition)this.logic;
        }
        return this;
    }

    public DiagramEditor withIcon(String icon) {
        this.controller.withIcon(icon);
        return this;
    }

    public SimpleController getController() {
        return this.controller;
    }

    @Override
    public boolean changed(SimpleEvent evt) {
        if (!this.loadHTMLEntity) {
            super.changed(evt);
            return true;
        }
        if ("SUCCEEDED".equals("" + evt.getNewValue())) {
            JavaAdapter.execute(new Runnable(){

                @Override
                public void run() {
                    DiagramEditor.this.screendump(null);
                }
            });
            return true;
        }
        return true;
    }

    public void screendump(String nameExtension) {
        Class<?> snapshotParametersClass = ReflectionLoader.getClass("javafx.scene.SnapshotParameters");
        Class<?> writableImageClass = ReflectionLoader.getClass("javafx.scene.image.WritableImage");
        Object image = ReflectionLoader.call("snapshot", this.webView, snapshotParametersClass, null, writableImageClass, null);
        Class<?> swingUtil = ReflectionLoader.getClass("javafx.embed.swing.SwingFXUtils");
        Class<?> bufferedImageClass = ReflectionLoader.getClass("java.awt.image.BufferedImage");
        Object bufferedImage = ReflectionLoader.call("fromFXImage", swingUtil, ReflectionLoader.IMAGE, image, bufferedImageClass, null);
        String fileName = this.file;
        if (nameExtension != null) {
            int pos = fileName.indexOf(".");
            fileName = pos < 1 ? fileName + nameExtension : fileName.substring(0, pos) + "-" + nameExtension + fileName.substring(pos);
        }
        ReflectionLoader.call("write", ReflectionLoader.IMAGEIO, ReflectionLoader.RENDEREDIMAGE, bufferedImage, String.class, "png", File.class, new File(fileName));
        if (this.autoClose) {
            this.controller.close();
        }
    }

    public void close() {
        if (this.controller != null) {
            this.controller.close();
        }
    }
}

