/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes.qr;

import de.uniks.networkparser.bytes.qr.BitArray;
import de.uniks.networkparser.bytes.qr.DecoderResult;
import de.uniks.networkparser.bytes.qr.ErrorCorrectionLevel;
import de.uniks.networkparser.bytes.qr.Mode;
import de.uniks.networkparser.bytes.qr.Version;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;

final class DecodedBitStreamParser {
    public static final String SHIFT_JIS = "SJIS";
    public static final String GB2312 = "GB2312";
    private static final char[] ALPHANUMERIC_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '$', '%', '*', '+', '-', '.', '/', ':'};
    private static final int GB2312_SUBSET = 1;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(byte[] bytes, Version version, ErrorCorrectionLevel ecLevel) throws Exception {
        BitArray bits = new BitArray(bytes);
        StringBuilder result = new StringBuilder(50);
        ArrayList<byte[]> byteSegments = new ArrayList<byte[]>(1);
        int symbolSequence = -1;
        int parityData = -1;
        try {
            Mode mode;
            boolean fc1InEffect = false;
            do {
                if ((mode = bits.available() < 4 ? Mode.TERMINATOR : Mode.forBits(bits.readBits(4))) == Mode.TERMINATOR) continue;
                if (mode == Mode.FNC1_FIRST_POSITION || mode == Mode.FNC1_SECOND_POSITION) {
                    fc1InEffect = true;
                    continue;
                }
                if (mode == Mode.STRUCTURED_APPEND) {
                    if (bits.available() < 16) {
                        throw new RuntimeException("FormatException");
                    }
                    symbolSequence = bits.readBits(8);
                    parityData = bits.readBits(8);
                    continue;
                }
                if (mode == Mode.ECI) continue;
                if (mode == Mode.HANZI) {
                    int subset = bits.readBits(4);
                    int countHanzi = bits.readBits(mode.getCharacterCountBits(version));
                    if (subset != 1) continue;
                    DecodedBitStreamParser.decodeHanziSegment(bits, result, countHanzi);
                    continue;
                }
                int count = bits.readBits(mode.getCharacterCountBits(version));
                if (mode == Mode.NUMERIC) {
                    DecodedBitStreamParser.decodeNumericSegment(bits, result, count);
                    continue;
                }
                if (mode == Mode.ALPHANUMERIC) {
                    DecodedBitStreamParser.decodeAlphanumericSegment(bits, result, count, fc1InEffect);
                    continue;
                }
                if (mode == Mode.BYTE) {
                    DecodedBitStreamParser.decodeByteSegment(bits, result, count, byteSegments);
                    continue;
                }
                if (mode == Mode.KANJI) {
                    DecodedBitStreamParser.decodeKanjiSegment(bits, result, count);
                    continue;
                }
                throw new RuntimeException("FormatException");
            } while (mode != Mode.TERMINATOR);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException("FormatException");
        }
        return new DecoderResult(bytes, result.toString(), byteSegments.isEmpty() ? null : byteSegments, ecLevel == null ? null : ecLevel.toString(), symbolSequence, parityData);
    }

    private static void decodeHanziSegment(BitArray bits, StringBuilder result, int count) throws Exception {
        if (count * 13 > bits.available()) {
            throw new RuntimeException("FormatException");
        }
        byte[] buffer = new byte[2 * count];
        int offset = 0;
        while (count > 0) {
            int twoBytes = bits.readBits(13);
            int assembledTwoBytes = twoBytes / 96 << 8 | twoBytes % 96;
            assembledTwoBytes = assembledTwoBytes < 959 ? (assembledTwoBytes += 41377) : (assembledTwoBytes += 42657);
            buffer[offset] = (byte)(assembledTwoBytes >> 8 & 0xFF);
            buffer[offset + 1] = (byte)(assembledTwoBytes & 0xFF);
            offset += 2;
            --count;
        }
        try {
            result.append(new String(buffer, GB2312));
        }
        catch (UnsupportedEncodingException ignored) {
            throw new RuntimeException("FormatException");
        }
    }

    private static void decodeKanjiSegment(BitArray bits, StringBuilder result, int count) throws Exception {
        if (count * 13 > bits.available()) {
            throw new RuntimeException("FormatException");
        }
        byte[] buffer = new byte[2 * count];
        int offset = 0;
        while (count > 0) {
            int twoBytes = bits.readBits(13);
            int assembledTwoBytes = twoBytes / 192 << 8 | twoBytes % 192;
            assembledTwoBytes = assembledTwoBytes < 7936 ? (assembledTwoBytes += 33088) : (assembledTwoBytes += 49472);
            buffer[offset] = (byte)(assembledTwoBytes >> 8);
            buffer[offset + 1] = (byte)assembledTwoBytes;
            offset += 2;
            --count;
        }
        try {
            result.append(new String(buffer, SHIFT_JIS));
        }
        catch (UnsupportedEncodingException ignored) {
            throw new RuntimeException("FormatException");
        }
    }

    private static void decodeByteSegment(BitArray bits, StringBuilder result, int count, Collection<byte[]> byteSegments) throws Exception {
        if (8 * count > bits.available()) {
            throw new RuntimeException("FormatException");
        }
        byte[] readBytes = new byte[count];
        for (int i = 0; i < count; ++i) {
            readBytes[i] = (byte)bits.readBits(8);
        }
        result.append(new String(readBytes, Charset.forName("utf-8")));
        byteSegments.add(readBytes);
    }

    private static char toAlphaNumericChar(int value) throws Exception {
        if (value >= ALPHANUMERIC_CHARS.length) {
            throw new RuntimeException("FormatException");
        }
        return ALPHANUMERIC_CHARS[value];
    }

    private static void decodeAlphanumericSegment(BitArray bits, StringBuilder result, int count, boolean fc1InEffect) throws Exception {
        int start = result.length();
        while (count > 1) {
            if (bits.available() < 11) {
                throw new RuntimeException("FormatException");
            }
            int nextTwoCharsBits = bits.readBits(11);
            result.append(DecodedBitStreamParser.toAlphaNumericChar(nextTwoCharsBits / 45));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(nextTwoCharsBits % 45));
            count -= 2;
        }
        if (count == 1) {
            if (bits.available() < 6) {
                throw new RuntimeException("FormatException");
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(bits.readBits(6)));
        }
        if (fc1InEffect) {
            for (int i = start; i < result.length(); ++i) {
                if (result.charAt(i) != '%') continue;
                if (i < result.length() - 1 && result.charAt(i + 1) == '%') {
                    result.deleteCharAt(i + 1);
                    continue;
                }
                result.setCharAt(i, '\u001d');
            }
        }
    }

    private static void decodeNumericSegment(BitArray bits, StringBuilder result, int count) throws Exception {
        while (count >= 3) {
            if (bits.available() < 10) {
                throw new RuntimeException("FormatException");
            }
            int threeDigitsBits = bits.readBits(10);
            if (threeDigitsBits >= 1000) {
                throw new RuntimeException("FormatException");
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(threeDigitsBits / 100));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(threeDigitsBits / 10 % 10));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(threeDigitsBits % 10));
            count -= 3;
        }
        if (count == 2) {
            if (bits.available() < 7) {
                throw new RuntimeException("FormatException");
            }
            int twoDigitsBits = bits.readBits(7);
            if (twoDigitsBits >= 100) {
                throw new RuntimeException("FormatException");
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(twoDigitsBits / 10));
            result.append(DecodedBitStreamParser.toAlphaNumericChar(twoDigitsBits % 10));
        } else if (count == 1) {
            if (bits.available() < 4) {
                throw new RuntimeException("FormatException");
            }
            int digitBits = bits.readBits(4);
            if (digitBits >= 10) {
                throw new RuntimeException("FormatException");
            }
            result.append(DecodedBitStreamParser.toAlphaNumericChar(digitBits));
        }
    }
}

