/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;

public class Filter {
    public static final String MERGE = "merge";
    public static final String COLLISION = "collision";
    protected ObjectCondition idFilter;
    protected ObjectCondition convertable;
    protected ObjectCondition property;
    protected static final byte FORMAT_NULL = 1;
    protected static final byte FORMAT_FULL = 2;
    protected static final byte FORMAT_TYPESAVE = 3;
    protected static final byte FORMAT_SHORTCLASS = 4;
    private byte format;
    private String strategy = "new";
    private boolean simpleFormat;

    public Filter withIdFilter(ObjectCondition idFilter) {
        this.idFilter = idFilter;
        return this;
    }

    public boolean isId(Object entity, String className, IdMap map) {
        if (this.idFilter != null) {
            return this.idFilter.update(new SimpleEvent("new", null, map, className, null, entity));
        }
        SendableEntityCreator creator = map.getCreator(className, true, null);
        if (creator != null) {
            return !(creator instanceof SendableEntityCreatorNoIndex);
        }
        return true;
    }

    public boolean isSimpleFormat(Object entity, SendableEntityCreator creator, String className, IdMap map) {
        if (this.isSimpleFormat()) {
            return true;
        }
        return creator instanceof SendableEntityCreatorNoIndex || !this.isId(entity, className, map);
    }

    public boolean isFullSerialization() {
        return this.format % 4 >= 2;
    }

    public boolean isTypSave() {
        return this.format % 4 >= 3;
    }

    public boolean isNullCheck() {
        return this.format % 4 >= 1;
    }

    public boolean isShortClass() {
        return this.format >= 4;
    }

    public Filter withFormat(byte format) {
        this.format = format;
        return this;
    }

    public Filter withPropertyRegard(ObjectCondition property) {
        this.property = property;
        return this;
    }

    public Filter withConvertable(ObjectCondition convertable) {
        this.convertable = convertable;
        return this;
    }

    public int convert(Object entity, String property, Object value, IdMap map, int deep) {
        if (this.convertable == null && this.property == null) {
            return 1;
        }
        SimpleEvent event = new SimpleEvent(this.strategy, map, property, deep, null, entity, value, null);
        if (this.property != null && !this.property.update(event)) {
            return -1;
        }
        if (this.convertable != null && !this.convertable.update(event)) {
            return 0;
        }
        return 1;
    }

    public boolean isConvertable(SimpleEvent event) {
        return this.convertable == null || this.convertable.update(event);
    }

    public ObjectCondition getPropertyRegard() {
        return this.property;
    }

    public static Filter regard(ObjectCondition convertable) {
        return new Filter().withPropertyRegard(convertable);
    }

    public static Filter convertable(ObjectCondition convertable) {
        return new Filter().withConvertable(convertable);
    }

    public String[] getProperties(SendableEntityCreator creator) {
        return creator.getProperties();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public Filter withStrategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    public boolean isSimpleFormat() {
        return this.simpleFormat;
    }

    public Filter withSimpleFormat(boolean value) {
        this.simpleFormat = value;
        return this;
    }

    public void suspendNotification() {
        this.strategy = "upd";
    }

    public static Filter createFull() {
        return new Filter().withFormat((byte)2);
    }

    public static Filter createSimple() {
        return new Filter().withSimpleFormat(true);
    }

    public static Filter createNull() {
        return new Filter().withFormat((byte)1);
    }

    public static Filter createTypSave() {
        return new Filter().withFormat((byte)3);
    }

    public void convertProperty(Object entity, String fullProp) {
    }
}

