/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.yaml;

import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.yaml.YamlItem;

public class YAMLTokener
extends Tokener {
    public static final String STOPCHARS = "=# ";

    @Override
    public void parseToEntity(EntityList entity) {
        this.parseLine(0, entity);
    }

    protected int parseLine(int deep, EntityList owner) {
        char c = this.getCurrentChar();
        int newDeep = 0;
        boolean read = false;
        BaseItem item = null;
        do {
            if (read) {
                c = this.getChar();
            }
            read = true;
            if (c == ' ') {
                ++newDeep;
                continue;
            }
            if (newDeep < deep) {
                return newDeep;
            }
            if (c == '\r') {
                c = this.getChar();
            }
            if (c == '\n') {
                this.parseLine(newDeep, owner);
                c = '\u0000';
                continue;
            }
            CharacterBuffer buffer = null;
            switch (c) {
                case '\u0000': {
                    break;
                }
                case '=': {
                    break;
                }
                case '-': {
                    c = this.getChar();
                    if (c == ' ') {
                        item = deep <= newDeep ? owner.getNewList(false) : owner.getNewList(true);
                    }
                }
                default: {
                    if (buffer == null) {
                        buffer = new CharacterBuffer();
                    }
                    buffer.with(c);
                }
            }
        } while (c != '\u0000');
        if (this.buffer != null) {
            if (item == null) {
                item = owner.getNewList(false);
            }
            if (item instanceof YamlItem) {
                ((YamlItem)item).withKey(this.buffer.toString());
            }
            owner.add(item);
        }
        return newDeep;
    }
}

