/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.xml;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.EntityStringConverter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.EntityList;
import de.uniks.networkparser.list.MapEntry;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.XMLTokener;

public class XMLEntity
extends SimpleKeyValueList<String, Object>
implements Entity,
EntityList {
    public static final String PROPERTY_TAG = "tag";
    public static final String PROPERTY_VALUE = "value";
    private SimpleList<EntityList> children;
    public static final char START = '<';
    public static final char END = '>';
    private String tag;
    private String valueItem;

    public XMLEntity() {
        this.withAllowDuplicate(false);
    }

    public XMLEntity withValue(String value) {
        XMLTokener tokener = new XMLTokener();
        tokener.withBuffer(value);
        this.withValue(tokener);
        return this;
    }

    public XMLEntity withValue(Tokener tokener) {
        if (tokener != null) {
            char c = tokener.nextClean(true);
            if (c != '<') {
                CharacterBuffer item = tokener.getString(tokener.length() - tokener.position());
                if (item != null) {
                    this.valueItem = ((Object)item).toString();
                }
                return this;
            }
            tokener.parseToEntity(this);
        }
        return this;
    }

    @Override
    public EntityList getChild(int index) {
        if (this.children == null || index < 0 || index > this.children.size()) {
            return null;
        }
        return (EntityList)this.children.get(index);
    }

    @Override
    public int sizeChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null || values.length < 1) {
            return false;
        }
        if (values[0] instanceof String) {
            if (values.length == 1) {
                this.withValue((String)values[0]);
            }
        } else if (values.length % 2 == 1) {
            for (Object item : values) {
                if (!(item instanceof EntityList)) continue;
                this.withChild((EntityList)item);
            }
            return true;
        }
        super.add(values);
        return true;
    }

    public XMLEntity withChild(EntityList value) {
        if (this.children == null) {
            this.children = new SimpleList();
        }
        this.children.add(value);
        return this;
    }

    public XMLEntity createChild(String tag) {
        XMLEntity xmlEntity = new XMLEntity();
        this.withChild(xmlEntity);
        xmlEntity.setType(tag);
        return xmlEntity;
    }

    public String getTag() {
        if (this.tag == null || this.tag.length() < 1) {
            return null;
        }
        return this.tag;
    }

    public String getValue() {
        if (this.valueItem == null && this.sizeChildren() > 0) {
            boolean show = false;
            for (int i = 0; i < this.children.size(); ++i) {
                EntityList item = (EntityList)this.children.get(i);
                if (!(item instanceof XMLEntity) || ((XMLEntity)item).getTag() != null) continue;
                show = true;
                break;
            }
            if (show) {
                CharacterBuffer buffer = new CharacterBuffer();
                String value = null;
                for (int i = 0; i < this.children.size(); ++i) {
                    EntityList item = (EntityList)this.children.get(i);
                    if (value != null && value.endsWith(">")) {
                        buffer.with(' ');
                    }
                    value = item.toString();
                    buffer.with(value);
                }
                return buffer.toString();
            }
        }
        return this.valueItem;
    }

    @Override
    public String toString() {
        return this.parseItem(new EntityStringConverter());
    }

    @Override
    public String toString(int indentFactor) {
        return this.parseItem(new EntityStringConverter(indentFactor));
    }

    @Override
    protected String parseItem(EntityStringConverter converter) {
        CharacterBuffer sb = new CharacterBuffer().with(converter.getPrefixFirst());
        if (this.getTag() != null) {
            sb.with('<');
            sb.with(this.getTag());
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Object value = this.getValueByIndex(i);
            if (value == null) continue;
            sb.with(" ", (CharSequence)this.get(i), "=", EntityUtil.quote(value.toString()));
        }
        this.toStringChildren(sb, converter);
        return sb.toString();
    }

    protected void toStringChildren(CharacterBuffer sb, EntityStringConverter converter) {
        if (this.children != null && this.children.size() > 0) {
            if (this.getTag() != null) {
                sb.with('>');
            }
            converter.add();
            for (EntityList child : this.children) {
                sb.with(child.toString(converter));
            }
            converter.minus();
            sb.with(converter.getPrefix());
            if (this.getTag() != null) {
                sb.with("</", this.getTag());
                sb.with('>');
            }
        } else if (this.valueItem != null) {
            if (this.getTag() != null) {
                sb.with('>');
            }
            sb.with(this.valueItem);
            if (this.getTag() != null) {
                sb.with("</", this.getTag());
                sb.with('>');
            }
        } else if (this.getTag() != null) {
            sb.with("/>");
        }
    }

    public XMLEntity withCloseTag() {
        if (this.valueItem == null) {
            this.valueItem = "";
        }
        return this;
    }

    public MapEntry getNewEntity() {
        return new MapEntry();
    }

    @Override
    public XMLEntity getNewList(boolean keyValue) {
        return new XMLEntity();
    }

    public static XMLEntity TAG(String tag) {
        return new XMLEntity().setType(tag);
    }

    public XMLEntity withKeyValue(Object key, Object value) {
        super.withKeyValue(key, value);
        return this;
    }

    @Override
    public XMLEntity without(String key) {
        this.remove(key);
        return this;
    }

    @Override
    public boolean has(String key) {
        return this.containsKey(key);
    }

    @Override
    public XMLEntity withValue(Buffer values) {
        Tokener tokener = new XMLTokener().withBuffer(values);
        return this.withValue(tokener);
    }

    @Override
    public XMLEntity setType(String value) {
        this.tag = value;
        return this;
    }

    @Override
    public Entity getElementBy(String key, String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase(this.getString(key))) {
            return this;
        }
        if (PROPERTY_TAG.equals(key) && value.equalsIgnoreCase(this.getTag())) {
            return this;
        }
        if (PROPERTY_VALUE.equals(key) && value.equalsIgnoreCase(this.getValue())) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Entity item;
            EntityList entity = (EntityList)this.children.get(i);
            if (entity instanceof XMLEntity && (item = ((XMLEntity)entity).getElementBy(key, value)) != null) {
                return item;
            }
            if (!(entity instanceof Entity) || !value.equalsIgnoreCase((item = (Entity)((Object)entity)).getString(key))) continue;
            return item;
        }
        return null;
    }

    public EntityList getElementsBy(String key, String value) {
        BaseItem result;
        if (value == null) {
            return null;
        }
        XMLEntity children = this.getNewList(false);
        if (value.equalsIgnoreCase(this.getString(key))) {
            children.add(this);
        } else if (PROPERTY_TAG.equals(key)) {
            if (value.equalsIgnoreCase(this.getTag())) {
                children.add(this);
            }
        } else if (PROPERTY_VALUE.equals(key)) {
            if (value.equalsIgnoreCase(this.getValue())) {
                children.add(this);
            }
        } else if ("class".equals(key)) {
            String first;
            int z;
            for (z = 0; z < value.length() && value.charAt(z) == ' '; ++z) {
            }
            int pos = value.indexOf(" ", z);
            if (pos < 0) {
                first = value.substring(z);
                pos = value.length();
            } else {
                first = value.substring(z, pos);
            }
            if (first.charAt(0) == '#') {
                if (first.substring(1).equals(this.getValue("id"))) {
                    value = " " + value.substring(pos);
                }
            } else if (first.charAt(0) == '.') {
                if (first.substring(1).equals(this.getValue("class"))) {
                    value = " " + value.substring(pos);
                }
            } else if (first.equals(this.getTag())) {
                value = " " + value.substring(pos);
            }
            if (value.length() == 1) {
                return this;
            }
        }
        if (this.children == null) {
            return children;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Entity item;
            EntityList entity = (EntityList)this.children.get(i);
            if (entity instanceof XMLEntity) {
                EntityList items = ((XMLEntity)entity).getElementsBy(key, value);
                if (entity == items || items.size() > 0) {
                    children.add(items);
                } else if (items.sizeChildren() > 0) {
                    for (int c = 0; c < items.sizeChildren(); ++c) {
                        children.add(items.getChild(c));
                    }
                }
            }
            if (!(entity instanceof Entity) || !value.equalsIgnoreCase((item = (Entity)((Object)entity)).getString(key))) continue;
            children.add(item);
        }
        if (children.sizeChildren() == 1 && (result = children.getChild(0)) instanceof EntityList) {
            return (EntityList)result;
        }
        return children;
    }

    public XMLEntity withValueItem(String value) {
        this.valueItem = value;
        return this;
    }
}

