/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.graph.SourceCode;
import java.util.ArrayList;

public class SymTabEntry {
    public static final String TYPE_IMPORT = "import";
    public static final String TYPE_CLASS = "class";
    public static final String TYPE_EXTENDS = "extends";
    public static final String TYPE_IMPLEMENTS = "implements";
    public static final String TYPE_ANNOTATION = "annotation";
    public static final String TYPE_ATTRIBUTE = "attribute";
    public static final String TYPE_ENUMVALUE = "enumvalue";
    public static final String TYPE_METHOD = "method";
    public static final String TYPE_PACKAGE = "package";
    public static final String TYPE_COMMENT = "comment";
    public static final String TYPE_JAVADOC = "javadoc";
    public static final String TYPE_CONSTRUCTOR = "constructor";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_VALUE = "value";
    private String value;
    private String type;
    private SymTabEntry next;
    private SymTabEntry prev;
    private int startPos;
    private int endPos;
    private int annotationsStartPos;
    private int preCommentStartPos;
    private int preCommentEndPos;
    private String modifiers;
    private String throwsTags;
    private String annotations;
    private ArrayList<ArrayList<String>> initCallSequence;
    private int annotationsEndPos;
    private int bodyStartPos;
    private String dataType;
    private String params;
    private SourceCode parent;

    public SymTabEntry withParent(SourceCode parent) {
        this.parent = parent;
        return this;
    }

    public SymTabEntry(SourceCode parent) {
        this.parent = parent;
    }

    public String getValue() {
        return this.value;
    }

    public boolean setValue(String value) {
        if (this.value == null && value != null || this.value != null && !this.value.equals(value)) {
            this.value = value;
            return true;
        }
        return false;
    }

    public void add(CharSequence string) {
        this.value = this.value == null ? "" + string : this.value + string;
    }

    public SymTabEntry withValue(String value) {
        this.setValue(value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public boolean setType(String value) {
        if (this.type == null && value != null || this.type != null && !this.type.equals(value)) {
            this.type = value;
            return true;
        }
        return false;
    }

    public SymTabEntry withType(String value) {
        this.setType(value);
        return this;
    }

    public boolean setNext(SymTabEntry value) {
        boolean changed = false;
        if (this.next != value) {
            SymTabEntry oldValue = this.next;
            if (this.next != null) {
                this.next = null;
                oldValue.setPrev(null);
            }
            this.next = value;
            if (value != null) {
                value.setPrev(this);
            }
            changed = true;
        }
        return changed;
    }

    public boolean setPrev(SymTabEntry value) {
        boolean changed = false;
        if (this.prev != value) {
            SymTabEntry oldValue = this.prev;
            if (this.prev != null) {
                this.prev = null;
                oldValue.setNext(null);
            }
            this.prev = value;
            if (value != null) {
                value.setNext(this);
            }
            changed = true;
        }
        return changed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.value);
        if (this.next != null) {
            this.next.toString(sb);
        }
    }

    public SymTabEntry withPosition(int start, int end) {
        this.startPos = start;
        this.endPos = end;
        return this;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public SymTabEntry withAnnotations(int start, int end) {
        this.annotationsStartPos = start;
        this.annotationsEndPos = end;
        return this;
    }

    public SymTabEntry withAnnotationsStart(int start) {
        this.annotationsStartPos = start;
        return this;
    }

    public int getAnnotationsEndPos() {
        return this.annotationsEndPos;
    }

    public int getAnnotationsStartPos() {
        return this.annotationsStartPos;
    }

    public SymTabEntry withPreComment(int start, int end) {
        this.preCommentStartPos = start;
        this.preCommentEndPos = end;
        return this;
    }

    public int getPreCommentStartPos() {
        return this.preCommentStartPos;
    }

    public int getPreCommentEndPos() {
        return this.preCommentEndPos;
    }

    public SymTabEntry withModifiers(String modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public String getModifiers() {
        return this.modifiers;
    }

    public SymTabEntry withThrowsTags(String throwsTags) {
        this.throwsTags = throwsTags;
        return this;
    }

    public String getThrowsTags() {
        return this.throwsTags;
    }

    public SymTabEntry withAnnotations(String annotations) {
        this.annotations = annotations;
        return this;
    }

    public String getAnnotations() {
        return this.annotations;
    }

    public SymTabEntry withInitSequence(ArrayList<ArrayList<String>> initCallSequence) {
        this.initCallSequence = initCallSequence;
        return this;
    }

    public ArrayList<ArrayList<String>> getInitCallSequence() {
        return this.initCallSequence;
    }

    public SymTabEntry withBodyStartPos(int value) {
        this.bodyStartPos = value;
        return this;
    }

    public int getBodyStartPos() {
        return this.bodyStartPos;
    }

    public SymTabEntry withDataType(String value) {
        this.dataType = value;
        return this;
    }

    public String getDataType() {
        return this.dataType;
    }

    public SymTabEntry withParams(String params) {
        this.params = params;
        return this;
    }

    public String getParams() {
        return this.params;
    }

    public void writeBody(String value) {
        this.parent.replaceAll(this.bodyStartPos + 1, value);
    }
}

