/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;

public class VariableCondition
implements ParserCondition {
    private CharSequence value;
    private boolean expression;

    @Override
    public boolean update(Object value) {
        if (value instanceof ObjectCondition) {
            return ((ObjectCondition)value).update(this);
        }
        if (value instanceof LocalisationInterface) {
            LocalisationInterface variables = (LocalisationInterface)value;
            Object object = this.getValue(variables);
            return object != null && !object.equals("");
        }
        if (this.value == null) {
            return value == null;
        }
        return this.value.equals(value);
    }

    public VariableCondition withValue(CharSequence value) {
        this.value = value;
        return this;
    }

    @Override
    public Object getValue(LocalisationInterface value) {
        if (value instanceof SendableEntityCreator) {
            Object object;
            SendableEntityCreator variables = (SendableEntityCreator)((Object)value);
            String key = this.value.toString();
            int pos = key.indexOf(35);
            String v = null;
            String format = null;
            boolean shortName = true;
            if (pos >= 0) {
                v = key.substring(0, pos);
                format = key.substring(pos + 1);
            } else {
                v = key;
            }
            pos = v.indexOf("(");
            if (pos > 0) {
                String temp = v.substring(pos + 1, v.length() - 1);
                v = key.substring(0, pos);
                shortName = Boolean.valueOf(temp);
            }
            if ((object = variables.getValue(variables, v)) == null && !this.expression) {
                return key;
            }
            if (object instanceof DataType) {
                object = ((DataType)object).getName(shortName);
            }
            if (object instanceof String) {
                return this.replaceText(v, format, (String)object);
            }
            if (object instanceof Boolean) {
                return "" + object;
            }
            return object;
        }
        if (value != null && this.value != null) {
            return value.getText(this.value, null, null);
        }
        if (this.value == null) {
            return null;
        }
        return null;
    }

    public String replaceText(String name, String format, String value) {
        boolean upper = false;
        boolean firstUpper = false;
        boolean small = false;
        int startIndex = name.lastIndexOf(46);
        for (int i = ++startIndex; i < name.length(); ++i) {
            if (name.charAt(i) >= 'A' && name.charAt(i) <= 'Z') {
                upper = true;
                firstUpper = startIndex == i;
                continue;
            }
            if (name.charAt(i) < 'a' || name.charAt(i) > 'z') continue;
            small = true;
        }
        if ("tolower".equalsIgnoreCase(format)) {
            return value.toLowerCase();
        }
        if (!small && upper || "toupper".equalsIgnoreCase(format)) {
            return value.toUpperCase();
        }
        if (firstUpper || "firstUpper".equalsIgnoreCase(format)) {
            return EntityUtil.upFirstChar(value);
        }
        if (format == null) {
            return value;
        }
        if (format.startsWith("sub(")) {
            int temp;
            String substring = format.substring(4, format.length() - 1);
            String[] item = substring.split(",");
            int start = 0;
            int end = value.length() - 1;
            if (item.length > 0) {
                start = Integer.valueOf(item[0].trim());
            }
            if (item.length > 1 && (temp = Integer.valueOf(item[1].trim()).intValue()) < end) {
                end = temp;
            }
            return value.substring(start, end);
        }
        if (format.startsWith("contains(")) {
            boolean boolValue;
            String substring = format.substring(9, format.length() - 1);
            boolean bl = boolValue = value.indexOf(substring) >= 0;
            if (boolValue) {
                return "true";
            }
            return "";
        }
        return value;
    }

    public VariableCondition withExpression(boolean value) {
        this.expression = value;
        return this;
    }

    public static VariableCondition create(CharSequence sequence, boolean expression) {
        return new VariableCondition().withValue(sequence).withExpression(expression);
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
        this.value = buffer.nextToken(true, ' ', '}');
    }

    @Override
    public boolean isExpression() {
        return this.expression;
    }

    @Override
    public String getKey() {
        return null;
    }

    public String toString() {
        return "{{" + this.value + "}}";
    }

    @Override
    public VariableCondition getSendableInstance(boolean prototyp) {
        return new VariableCondition();
    }
}

