/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;
import de.uniks.networkparser.list.ConditionSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.logic.ChainCondition;
import de.uniks.networkparser.logic.VariableCondition;
import java.beans.PropertyChangeEvent;

public class Equals
implements ParserCondition,
SendableEntityCreator {
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_POSITION = "position";
    private String key;
    private ObjectCondition left;
    private ObjectCondition right;
    private Object value;
    private Object delta;
    private int position = -1;

    private Object getValue(ObjectCondition condition, Object evt) {
        LocalisationInterface li = (LocalisationInterface)evt;
        if (condition instanceof ParserCondition) {
            return ((ParserCondition)condition).getValue(li);
        }
        if (condition instanceof ChainCondition) {
            ChainCondition chainCondition = (ChainCondition)condition;
            ConditionSet templates = chainCondition.getList();
            CharacterBuffer buffer = new CharacterBuffer();
            for (ObjectCondition item : templates) {
                if (item instanceof VariableCondition) {
                    VariableCondition vc = (VariableCondition)item;
                    Object result = vc.getValue(li);
                    if (result == null) continue;
                    buffer.with(result.toString());
                    continue;
                }
                buffer.with(item.toString());
            }
            return buffer.toString();
        }
        return null;
    }

    @Override
    public boolean update(Object evt) {
        SimpleKeyValueList keyValueList;
        Object value;
        if (evt == null) {
            return this.value == null;
        }
        if (evt instanceof LocalisationInterface && this.left != null && this.right != null) {
            Object leftValue = this.getValue(this.left, evt);
            Object rightValue = this.getValue(this.right, evt);
            if (leftValue == null) {
                return rightValue == null;
            }
            if (this.position != 0 && (leftValue instanceof Number || EntityUtil.isNumeric("" + leftValue)) && (rightValue instanceof Number || EntityUtil.isNumeric("" + rightValue))) {
                Double leftNumber = Double.valueOf("" + leftValue);
                Double rightNumber = Double.valueOf("" + rightValue);
                if (this.position > 0) {
                    return rightNumber > leftNumber;
                }
                return rightNumber < leftNumber;
            }
            if (leftValue instanceof String && rightValue instanceof String) {
                return ((String)leftValue).equalsIgnoreCase((String)rightValue);
            }
            if (leftValue instanceof Number && rightValue instanceof String) {
                leftValue = "" + leftValue;
            }
            return leftValue.equals(rightValue);
        }
        if (this.value == null) {
            return evt == null;
        }
        if (evt instanceof SimpleKeyValueList && (value = (keyValueList = (SimpleKeyValueList)evt).get(this.key)) != null) {
            return value.equals(this.value);
        }
        if (!(evt instanceof PropertyChangeEvent)) {
            if (this.value instanceof Number && evt instanceof Number) {
                Number evtValue;
                Number expValue;
                if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long) {
                    if (this.delta == null) {
                        return this.value == evt;
                    }
                    expValue = Long.valueOf("" + this.value);
                    evtValue = Long.valueOf("" + evt);
                    Long deltaValue = Long.valueOf("" + this.delta);
                    return (Long)expValue - deltaValue <= (Long)evtValue && (Long)expValue + deltaValue >= (Long)evtValue;
                }
                expValue = (Double)this.value;
                evtValue = (Double)evt;
                if (this.delta != null) {
                    Double deltaValue = (Double)this.delta;
                    return (Double)expValue - deltaValue <= (Double)evtValue && (Double)expValue + deltaValue >= (Double)evtValue;
                }
                return ((Double)expValue).equals(evtValue);
            }
            return this.value.equals(evt);
        }
        PropertyChangeEvent event = (PropertyChangeEvent)evt;
        if (event.getSource() instanceof BufferedBuffer && this.value instanceof Byte) {
            Byte btrValue = (Byte)this.value;
            BufferedBuffer buffer = (BufferedBuffer)event.getSource();
            int pos = this.position < 0 ? buffer.position() : this.position;
            return buffer.byteAt(pos) == btrValue.byteValue();
        }
        if (event.getPropertyName() == null) {
            return false;
        }
        return event.getPropertyName().equals(this.value);
    }

    public Equals withPosition(int value) {
        this.position = value;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public Equals withValue(Object value) {
        this.value = value;
        return this;
    }

    public Equals withValue(Object value, Object delta) {
        this.withValue(value);
        this.withDelta(delta);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        if (this.left != null && this.right != null) {
            return "" + this.left.toString() + "==" + this.right.toString();
        }
        return "==" + this.value + " ";
    }

    @Override
    public String[] getProperties() {
        return new String[]{PROPERTY_KEY, PROPERTY_VALUE, PROPERTY_POSITION};
    }

    @Override
    public ParserCondition getSendableInstance(boolean prototyp) {
        return new Equals();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public Equals withKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (PROPERTY_KEY.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getKey();
        }
        if (PROPERTY_VALUE.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getValue();
        }
        if (PROPERTY_POSITION.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getPosition();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (!(entity instanceof Equals)) {
            return false;
        }
        Equals element = (Equals)entity;
        if (PROPERTY_KEY.equalsIgnoreCase(attribute)) {
            element.withKey(String.valueOf(value));
            return true;
        }
        if (PROPERTY_VALUE.equalsIgnoreCase(attribute)) {
            element.withValue(value);
            return true;
        }
        if (PROPERTY_POSITION.equalsIgnoreCase(attribute)) {
            element.withPosition(Integer.parseInt("" + value));
            return true;
        }
        return false;
    }

    public Object getDelta() {
        return this.delta;
    }

    public Equals withDelta(Object delta) {
        this.delta = delta;
        return this;
    }

    public static Equals create(String key, Object value) {
        Equals condition = new Equals();
        condition.withKey(key);
        condition.withValue(value);
        return condition;
    }

    public static Equals createNullCondition() {
        return new Equals().withValue(null);
    }

    public Equals withLeft(ObjectCondition expression) {
        this.left = expression;
        return this;
    }

    public Equals withRight(ObjectCondition expression) {
        this.right = expression;
        return this;
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    @Override
    public Object getValue(LocalisationInterface value) {
        if (value instanceof SendableEntityCreator) {
            SendableEntityCreator variables = (SendableEntityCreator)((Object)value);
            Object object = variables.getValue(variables, this.key);
            return object;
        }
        if (value != null && this.key != null) {
            return value.getText(this.key, null, null);
        }
        if (this.key == null) {
            return null;
        }
        if (this.value.equals(value)) {
            return value;
        }
        return null;
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
    }
}

