/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.list;

import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.Map;

public class SimpleEntity<K, V>
implements BaseItem,
Map.Entry<K, V>,
SendableEntityCreator,
SendableEntityCreatorNoIndex {
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_VALUE = "value";
    private final String[] properties = new String[]{"key", "value"};
    private K key;
    private V value;

    public <ST extends SimpleEntity<K, V>> ST with(K key, V value) {
        this.key = key;
        this.value = value;
        return (ST)this;
    }

    public SimpleEntity<K, V> withKeyItem(Object key) {
        this.withKey(key);
        return this;
    }

    public SimpleEntity<K, V> withValueItem(Object value) {
        this.withValue(value);
        return this;
    }

    public SimpleEntity<K, V> with(Map<Object, Object> collection) {
        if (collection != null) {
            for (Map.Entry<Object, Object> e : collection.entrySet()) {
                Object value = e.getValue();
                if (value == null) continue;
                this.setKeyIntern(e.getKey());
                this.setValueIntern(e.getValue());
            }
        }
        return this;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    public String getKeyString() {
        if (this.key instanceof String) {
            return "" + this.key;
        }
        throw new RuntimeException("Key is not a String <" + this.key + ">");
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public V setValue(V value) {
        this.value = value;
        return value;
    }

    private void setValueIntern(Object value) {
        this.value = value;
    }

    private void setKeyIntern(Object key) {
        this.key = key;
    }

    public K setKey(K value) {
        this.key = value;
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        return SimpleEntity.eq(this.key, e.getKey()) && SimpleEntity.eq(this.value, e.getValue());
    }

    @Override
    public int hashCode() {
        return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
    }

    @Override
    public String toString() {
        return this.key + "=" + this.value;
    }

    public SimpleEntity<K, V> withKey(K key) {
        this.key = key;
        return this;
    }

    public SimpleEntity<K, V> withValue(V value) {
        this.value = value;
        return this;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        Map.Entry obj = (Map.Entry)entity;
        if (PROPERTY_KEY.equalsIgnoreCase(attribute)) {
            return obj.getKey();
        }
        if (PROPERTY_VALUE.equalsIgnoreCase(attribute)) {
            return obj.getValue();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (entity instanceof SimpleEntity) {
            SimpleEntity entry = (SimpleEntity)entity;
            if (PROPERTY_KEY.equalsIgnoreCase(attribute)) {
                entry.withKeyItem(value);
                return true;
            }
            if (PROPERTY_VALUE.equalsIgnoreCase(attribute)) {
                if (value instanceof Map.Entry) {
                    Object map = entry.getValue();
                    if (map == null) {
                        map = new SimpleKeyValueList();
                    }
                    SimpleKeyValueList mapValue = (SimpleKeyValueList)map;
                    mapValue.withKeyValue(((Map.Entry)value).getKey(), ((Map.Entry)value).getValue());
                    entry.withValueItem(map);
                } else {
                    entry.withValueItem(value);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new SimpleEntity<K, V>();
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return false;
        }
        if (values.length == 2) {
            this.withKeyItem(values[0]);
            this.withValueItem(values[1]);
        }
        return true;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new SimpleEntity<K, V>();
    }

    public Object getValue(Object key) {
        if (PROPERTY_KEY.equals(key)) {
            return this.key;
        }
        if (PROPERTY_VALUE.equals(key)) {
            return this.value;
        }
        return null;
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            return null;
        }
        return converter.encode(this);
    }

    @Override
    public int size() {
        if (this.key != null) {
            return 1;
        }
        return 0;
    }
}

