/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.ClazzType;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphImage;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.Import;
import de.uniks.networkparser.graph.Literal;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.StringFilter;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.graph.util.AttributeSet;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.graph.util.MethodSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleSet;
import java.util.Collection;

public class Clazz
extends GraphEntity {
    public static final StringFilter<Clazz> NAME = new StringFilter("name");
    public static final String PROPERTY_PACKAGENAME = "packageName";
    public static final String PROPERTY_FULLNAME = "fullName";
    public static final String PROPERTY_VISIBILITY = "visibility";
    public static final String PROPERTY_MODIFIERS = "modifiers";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_SUPERCLAZZ = "superclazz";
    public static final String PROPERTY_IMPLEMENTS = "implements";
    public static final String PROPERTY_ATTRIBUTE = "attribute";
    private ClazzType type = ClazzType.CLAZZ;

    Clazz() {
    }

    public Clazz(String name) {
        this.with(name);
    }

    public Clazz(Class<?> name) {
        if (name != null) {
            this.with(name.getName().replace("$", "."));
        }
    }

    @Override
    public Clazz with(String name) {
        super.with(name);
        return this;
    }

    protected Clazz with(ClazzType clazzType) {
        this.type = clazzType;
        return this;
    }

    public Clazz enableInterface() {
        this.with(ClazzType.INTERFACE);
        return this;
    }

    public Clazz enableEnumeration(Object ... literals) {
        this.with(ClazzType.ENUMERATION);
        if (literals == null) {
            return this;
        }
        for (Object item : literals) {
            if (item == null) continue;
            if (item instanceof Literal) {
                this.with((Literal)item);
                continue;
            }
            this.with(new Literal(item.toString()));
        }
        return this;
    }

    public ClazzType getType() {
        return this.type;
    }

    @Override
    protected String getFullId() {
        if (this.getId() != null) {
            return this.getId();
        }
        return super.getFullId();
    }

    @Override
    public Clazz withExternal(boolean value) {
        super.withExternal(value);
        return this;
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier = super.getModifier();
        if (modifier == null) {
            modifier = new Modifier(Modifier.PUBLIC);
            super.withChildren(modifier);
        }
        return modifier;
    }

    public Clazz with(Modifier ... values) {
        super.withModifier(values);
        return this;
    }

    protected Clazz with(Attribute ... values) {
        super.withChildren(values);
        return this;
    }

    protected Clazz with(Method ... values) {
        super.withChildren(values);
        return this;
    }

    @Override
    public Clazz with(Annotation value) {
        super.with(value);
        return this;
    }

    protected Clazz with(GraphImage ... values) {
        super.withChildren(values);
        return this;
    }

    protected Clazz with(Literal ... values) {
        super.withChildren(values);
        return this;
    }

    public SimpleSet<Literal> getValues() {
        SimpleSet<Literal> collection = new SimpleSet<Literal>();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Literal) {
            collection.add((Literal)this.children);
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof Literal)) continue;
                collection.add((Literal)item);
            }
        }
        return collection;
    }

    public Clazz withBidirectional(Clazz tgtClass, String tgtRoleName, Cardinality tgtCardinality, String srcRoleName, Cardinality srcCardinality) {
        Association assocTarget = new Association(tgtClass).with(tgtCardinality).with(tgtRoleName);
        Association assocSource = new Association(this).with(srcCardinality).with(srcRoleName);
        assocSource.with(assocTarget);
        tgtClass.with(assocTarget);
        this.with(assocSource);
        return this;
    }

    public Association createBidirectional(Clazz tgtClass, String tgtRoleName, Cardinality tgtCardinality, String srcRoleName, Cardinality srcCardinality) {
        Association assocTarget = new Association(tgtClass).with(tgtCardinality).with(tgtRoleName);
        Association assocSource = new Association(this).with(srcCardinality).with(srcRoleName);
        assocSource.with(assocTarget);
        tgtClass.with(assocTarget);
        this.with(assocSource);
        return assocSource;
    }

    public Clazz withUniDirectional(Clazz tgtClass, String tgtRoleName, Cardinality tgtCardinality) {
        Association assocTarget = new Association(tgtClass).with(tgtCardinality).with(AssociationTypes.UNDIRECTIONAL).with(tgtRoleName);
        Association assocSource = new Association(this).with(AssociationTypes.EDGE).with(assocTarget);
        tgtClass.with(assocTarget);
        this.with(assocSource);
        return this;
    }

    public ClazzSet getInterfaces(boolean transitive) {
        this.repairAssociations();
        AssociationTypes type = AssociationTypes.IMPLEMENTS;
        if (this.getType() == ClazzType.INTERFACE) {
            type = AssociationTypes.GENERALISATION;
        }
        ClazzSet collection = this.getEdgeClazzes(type, null);
        if (!transitive) {
            return collection;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            collection.withList((Collection)((Clazz)collection.get(i)).getInterfaces(transitive));
        }
        return collection;
    }

    public ClazzSet getSuperClazzes(boolean transitive) {
        this.repairAssociations();
        ClazzSet collection = this.getEdgeClazzes(AssociationTypes.GENERALISATION, null);
        if (!transitive) {
            return collection;
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            collection.withList((Collection)((Clazz)collection.get(i)).getSuperClazzes(transitive));
        }
        return collection;
    }

    protected void repairAssociation(Association assoc) {
        if (!AssociationTypes.IMPLEMENTS.equals((Object)assoc.getType()) && !AssociationTypes.GENERALISATION.equals((Object)assoc.getType())) {
            assoc = assoc.getOther();
        }
        if (!AssociationTypes.IMPLEMENTS.equals((Object)assoc.getType()) && !AssociationTypes.GENERALISATION.equals((Object)assoc.getType())) {
            return;
        }
        if (assoc.getClazz().getType().equals((Object)ClazzType.INTERFACE)) {
            if (!AssociationTypes.GENERALISATION.equals((Object)assoc.getType())) {
                assoc.with(AssociationTypes.GENERALISATION);
            }
        } else if (assoc.getOtherClazz().getType().equals((Object)ClazzType.INTERFACE)) {
            if (!AssociationTypes.IMPLEMENTS.equals((Object)assoc.getType())) {
                assoc.with(AssociationTypes.IMPLEMENTS);
            }
        } else if (!AssociationTypes.GENERALISATION.equals((Object)assoc.getType())) {
            assoc.with(AssociationTypes.GENERALISATION);
        }
    }

    private void repairAssociations() {
        if (this.children == null) {
            return;
        }
        if (this.children instanceof Association) {
            this.repairAssociation((Association)this.children);
        } else if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            AssociationSet generalizations = new AssociationSet();
            for (GraphMember item : list) {
                if (!(item instanceof Association)) continue;
                Association assoc = (Association)item;
                this.repairAssociation(assoc);
                if (!AssociationTypes.GENERALISATION.equals((Object)assoc.getType())) continue;
                generalizations.add(assoc);
            }
            if (generalizations.size() > 1) {
                for (int i = 0; i < generalizations.size() - 1; ++i) {
                    this.without((GraphMember)generalizations.get(i));
                }
            }
        }
    }

    public Clazz withSuperClazz(Clazz ... values) {
        this.createAssociation(AssociationTypes.GENERALISATION, AssociationTypes.EDGE, values);
        return this;
    }

    public ClazzSet getKidClazzes(boolean transitive) {
        ClazzSet kidClazzes = this.getEdgeClazzes(AssociationTypes.EDGE, AssociationTypes.GENERALISATION);
        if (!transitive) {
            return kidClazzes;
        }
        int size = kidClazzes.size();
        for (int i = 0; i < size; ++i) {
            kidClazzes.withList((Collection)((Clazz)kidClazzes.get(i)).getKidClazzes(transitive));
        }
        return kidClazzes;
    }

    public ClazzSet getImplements() {
        ClazzSet kidClazzes = this.getEdgeClazzes(AssociationTypes.IMPLEMENTS, AssociationTypes.EDGE);
        return kidClazzes;
    }

    protected ClazzSet getEdgeClazzes(AssociationTypes typ, AssociationTypes otherTyp) {
        ClazzSet kidClazzes = new ClazzSet();
        if (this.children == null || typ == null) {
            return kidClazzes;
        }
        for (Association assoc : super.getEdges(AssociationTypes.EDGE, new Condition[0])) {
            if (typ != assoc.getType() || otherTyp != null && assoc.getOtherType() != otherTyp) continue;
            Clazz clazz = assoc.getOtherClazz();
            kidClazzes.with(clazz);
        }
        return kidClazzes;
    }

    protected void createAssociation(AssociationTypes direction, AssociationTypes backDirection, Clazz ... values) {
        if (values == null) {
            return;
        }
        AssociationSet associations = this.getAssociations(new Condition[0]);
        for (Clazz item : values) {
            if (item == null) continue;
            for (Association assoc : associations) {
                if (assoc.getType() != direction || assoc.getOtherType() != backDirection || assoc.contains(item, true, false)) continue;
                assoc.getOther().setParentNode(item);
                break;
            }
            Association childAssoc = new Association(this).with(direction);
            Association superAssoc = new Association(item).with(backDirection);
            childAssoc.with(superAssoc);
            this.with(childAssoc);
            item.with(superAssoc);
        }
    }

    public Clazz withKidClazzes(Clazz ... values) {
        this.createAssociation(AssociationTypes.EDGE, AssociationTypes.GENERALISATION, values);
        return this;
    }

    public GraphModel getClassModel() {
        return (GraphModel)this.parentNode;
    }

    public boolean setClassModel(GraphModel value) {
        return super.setParentNode(value);
    }

    public AttributeSet getAttributes(Condition<?> ... filters) {
        Association assoc;
        AttributeSet collection = new AttributeSet();
        if (this.children == null) {
            return collection;
        }
        ClazzSet superClasses = new ClazzSet();
        if (this.children instanceof Attribute) {
            if (this.check((Attribute)this.children, filters)) {
                collection.add((Attribute)this.children);
            }
            return collection;
        }
        if (this.children instanceof Association && ((assoc = (Association)this.children).getType() == AssociationTypes.GENERALISATION || assoc.getType() == AssociationTypes.IMPLEMENTS)) {
            superClasses.add(assoc.getOtherClazz());
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                Association assoc2;
                if (item instanceof Attribute) {
                    if (!this.check(item, filters)) continue;
                    collection.add((Attribute)item);
                    continue;
                }
                if (!(item instanceof Association) || (assoc2 = (Association)item).getType() != AssociationTypes.GENERALISATION && assoc2.getType() != AssociationTypes.IMPLEMENTS) continue;
                superClasses.add(assoc2.getOtherClazz());
            }
        }
        boolean isInterface = this.getType() == ClazzType.INTERFACE;
        boolean isAbstract = this.getModifier().has(Modifier.ABSTRACT);
        if (isInterface || isAbstract) {
            return collection;
        }
        AttributeSet newAttribute = new AttributeSet();
        AttributeSet foundAttribute = new AttributeSet();
        for (int i = 0; i < superClasses.size(); ++i) {
            Clazz item = (Clazz)superClasses.get(i);
            item.parseSuperElements(superClasses, collection, newAttribute, foundAttribute, filters);
        }
        collection.addAll(foundAttribute);
        return collection;
    }

    public MethodSet getMethods(Condition<?> ... filters) {
        Association assoc;
        MethodSet collection = new MethodSet();
        if (this.children == null) {
            return collection;
        }
        ClazzSet superClasses = new ClazzSet();
        if (this.children instanceof Method) {
            if (this.check((Method)this.children, filters)) {
                collection.add((Method)this.children);
            }
            return collection;
        }
        if (this.children instanceof Association && ((assoc = (Association)this.children).getType() == AssociationTypes.GENERALISATION || assoc.getType() == AssociationTypes.IMPLEMENTS)) {
            superClasses.add(assoc.getOtherClazz());
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                Association assoc2;
                if (item instanceof Method) {
                    if (!this.check(item, filters)) continue;
                    collection.add((Method)item);
                    continue;
                }
                if (!(item instanceof Association) || (assoc2 = (Association)item).getType() != AssociationTypes.GENERALISATION && assoc2.getType() != AssociationTypes.IMPLEMENTS) continue;
                superClasses.add(assoc2.getOtherClazz());
            }
        }
        boolean isInterface = this.getType() == ClazzType.INTERFACE;
        boolean isAbstract = this.getModifier().has(Modifier.ABSTRACT);
        if (isInterface || isAbstract) {
            return collection;
        }
        MethodSet newMethods = new MethodSet();
        MethodSet foundMethods = new MethodSet();
        for (int i = 0; i < superClasses.size(); ++i) {
            Clazz item = (Clazz)superClasses.get(i);
            item.parseSuperElements(superClasses, collection, newMethods, foundMethods, filters);
        }
        collection.addAll(foundMethods);
        return collection;
    }

    @Override
    public AssociationSet getAssociations(Condition<?> ... filters) {
        AssociationSet collection = super.getAssociations(filters);
        boolean isInterface = this.getType() == ClazzType.INTERFACE;
        boolean isAbstract = this.getModifier().has(Modifier.ABSTRACT);
        if (isInterface || isAbstract) {
            return collection;
        }
        ClazzSet superClasses = new ClazzSet();
        for (Association assoc : collection) {
            if (assoc.getType() != AssociationTypes.GENERALISATION && assoc.getType() != AssociationTypes.IMPLEMENTS) continue;
            superClasses.add(assoc.getOtherClazz());
        }
        AssociationSet newAssocs = new AssociationSet();
        AssociationSet foundAssocs = new AssociationSet();
        for (int i = 0; i < superClasses.size(); ++i) {
            Clazz item = (Clazz)superClasses.get(i);
            item.parseSuperElements(superClasses, collection, newAssocs, foundAssocs, filters);
        }
        collection.addAll(foundAssocs);
        return collection;
    }

    protected void parseSuperElements(ClazzSet superClasses, SimpleSet<?> existsElements, SimpleSet<?> newExistElements, SimpleSet<?> newElements, Condition<?> ... filters) {
        if (this.children == null) {
            return;
        }
        boolean isInterface = this.getType() == ClazzType.INTERFACE;
        boolean isAbstract = this.getModifier().has(Modifier.ABSTRACT);
        Class<?> checkClassType = existsElements.getTypClass();
        if (!isInterface && !isAbstract) {
            SimpleSet collection = null;
            if (checkClassType == Method.class) {
                collection = this.getMethods(filters);
            } else if (checkClassType == Attribute.class) {
                collection = this.getAttributes(filters);
            } else if (checkClassType == Association.class) {
                collection = this.getAssociations(filters);
            }
            newElements.removeAll(collection);
            return;
        }
        GraphSimpleSet list = this.getChildren();
        for (GraphMember member : list) {
            if (member instanceof Association) {
                Association assoc = (Association)member;
                if (assoc.getType() == AssociationTypes.GENERALISATION || assoc.getType() == AssociationTypes.IMPLEMENTS) {
                    superClasses.add(assoc.getOtherClazz());
                    continue;
                }
                if (checkClassType != Association.class || assoc.getOtherType() == AssociationTypes.GENERALISATION || assoc.getType() == AssociationTypes.IMPLEMENTS) continue;
            }
            if (checkClassType == Method.class && !(member instanceof Method) || checkClassType == Attribute.class && !(member instanceof Attribute) || checkClassType == Association.class && !(member instanceof Association) || existsElements.contains(member)) continue;
            Modifier modifier = member.getModifier();
            if (isInterface) {
                if (modifier == null || !modifier.has(Modifier.DEFAULT)) {
                    if (!this.check(member, filters) || newExistElements.contains(member)) continue;
                    newElements.add((Method)new Object[]{member});
                    continue;
                }
                if (newExistElements.contains(member)) continue;
                newExistElements.add(new Object[]{member});
                newElements.remove(member);
                continue;
            }
            if (!isAbstract || modifier == null || !modifier.has(Modifier.ABSTRACT)) continue;
            if (this.check(member, filters) && !newExistElements.contains(member)) {
                newElements.add((Method)new Object[]{member});
                continue;
            }
            if (newExistElements.contains(member)) continue;
            newExistElements.add(new Object[]{member});
            newElements.remove(member);
        }
    }

    public Clazz withoutKidClazz(Clazz ... values) {
        if (this.children == null || values == null) {
            return this;
        }
        block0: for (Clazz item : values) {
            if (item == null) continue;
            for (Association assoc : this.getAssociations(new Condition[0])) {
                if (assoc.getOther().getType() != AssociationTypes.GENERALISATION || !assoc.contains(item, false, true)) continue;
                super.without(assoc);
                continue block0;
            }
        }
        return this;
    }

    public Clazz withoutSuperClazz(Clazz ... values) {
        if (this.children == null || values == null) {
            return this;
        }
        block0: for (Clazz item : values) {
            if (item == null) continue;
            for (Association assoc : this.getAssociations(new Condition[0])) {
                if (assoc.getType() != AssociationTypes.GENERALISATION || !assoc.contains(item, true, false)) continue;
                this.without(assoc);
                continue block0;
            }
        }
        return this;
    }

    protected Clazz with(Import ... value) {
        super.withChildren(value);
        return this;
    }

    public SimpleSet<Import> getImports() {
        SimpleSet<Import> collection = new SimpleSet<Import>();
        if (this.children == null) {
            return collection;
        }
        if (this.children instanceof Import) {
            collection.add((Import)this.children);
            return collection;
        }
        if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                if (!(item instanceof Import)) continue;
                collection.add((Import)item);
            }
        }
        return collection;
    }

    public Method createMethod(String name, DataType returnValue, Parameter ... parameters) {
        Method method = this.createMethod(name, parameters);
        method.with(returnValue);
        return method;
    }

    public Method createMethod(String name, Parameter ... parameters) {
        Method method = new Method().with(name);
        method.with(parameters);
        method.setParentNode(this);
        return method;
    }

    public Attribute createAttribute(String name, DataType type) {
        Attribute attribute = new Attribute(name, type);
        this.with(attribute);
        return attribute;
    }

    public Clazz withAttribute(String name, DataType type) {
        Attribute attribute = new Attribute(name, type);
        this.with(attribute);
        return this;
    }

    public Clazz withMethod(String name, DataType returnType, Parameter ... parameters) {
        Method method = this.createMethod(name, parameters);
        method.with(returnType);
        return this;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object getValue(String attribute) {
        if (PROPERTY_PACKAGENAME.equalsIgnoreCase(attribute)) {
            String fullName = this.getName(false);
            if (fullName == null) {
                return null;
            }
            int pos = fullName.lastIndexOf(".");
            if (pos < 0) {
                return "";
            }
            return fullName.substring(0, pos);
        }
        if (PROPERTY_FULLNAME.equalsIgnoreCase(attribute)) {
            return this.getName(false);
        }
        if (PROPERTY_MODIFIERS.equalsIgnoreCase(attribute)) {
            CharacterBuffer buffer = new CharacterBuffer();
            Modifier modifier = this.getModifier();
            if (modifier != null) {
                modifier = modifier.getModifier();
                while (modifier != null) {
                    buffer.with(modifier.getName());
                    if ((modifier = modifier.getModifier()) == null) continue;
                    buffer.with(' ');
                }
            }
            return buffer.toString();
        }
        if (PROPERTY_TYPE.equalsIgnoreCase(attribute)) {
            return this.getType().getValue();
        }
        if (PROPERTY_SUPERCLAZZ.equalsIgnoreCase(attribute)) {
            ClazzSet clazzes = this.getType() == ClazzType.ENUMERATION || this.getType() == ClazzType.INTERFACE ? this.getImplements() : this.getSuperClazzes(false);
            return clazzes.toString(", ");
        }
        if (PROPERTY_IMPLEMENTS.equalsIgnoreCase(attribute)) {
            if (this.getType() == ClazzType.ENUMERATION || this.getType() == ClazzType.INTERFACE) {
                return null;
            }
            ClazzSet implementsClazz = this.getImplements();
            return implementsClazz.toString(", ");
        }
        int pos = attribute.indexOf(46);
        String attrName = pos > 0 ? attribute.substring(0, pos) : attribute;
        if (PROPERTY_ATTRIBUTE.equalsIgnoreCase(attrName)) {
            AttributeSet attributes = this.getAttributes(new Condition[0]);
            if (pos > 0) {
                return attributes.getValue(attribute.substring(pos + 1));
            }
            return attributes;
        }
        return super.getValue(attribute);
    }

    @Override
    public Clazz without(GraphMember ... values) {
        super.without(values);
        return this;
    }
}

