/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.story;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.ClassModel;
import de.uniks.networkparser.ext.story.StoryObjectFilter;
import de.uniks.networkparser.ext.story.StoryStepCondition;
import de.uniks.networkparser.ext.story.StoryStepDiagram;
import de.uniks.networkparser.ext.story.StoryStepImage;
import de.uniks.networkparser.ext.story.StoryStepSourceCode;
import de.uniks.networkparser.ext.story.StoryStepText;
import de.uniks.networkparser.ext.story.StoryStepTitle;
import de.uniks.networkparser.ext.story.StoryUtil;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.BooleanCondition;
import de.uniks.networkparser.logic.Equals;
import de.uniks.networkparser.logic.Not;
import de.uniks.networkparser.xml.HTMLEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Story {
    private String outputFile;
    private SimpleList<ObjectCondition> steps = new SimpleList();
    private int counter = -1;
    private boolean breakOnAssert = true;
    private IdMap map;

    public Story() {
        this.add(new StoryStepTitle());
    }

    public void add(ObjectCondition step) {
        this.steps.add(step);
    }

    public StoryStepSourceCode addSourceCode(Class<?> className, int ... position) {
        StoryStepSourceCode step = new StoryStepSourceCode();
        if (position != null) {
            int start;
            if (position.length > 0) {
                start = position[0];
                step.withStart(start);
            }
            if (position.length > 1) {
                start = position[1];
                step.withEnd(start);
            }
        }
        step.withCode(className);
        this.addSourceCodeStep(step);
        return step;
    }

    public StoryStepSourceCode addSourceCode(String rootDir, Class<?> className, String methodSignature) {
        StoryStepSourceCode step = new StoryStepSourceCode();
        step.withMethodSignature(methodSignature);
        step.withCode(rootDir, className);
        this.addSourceCodeStep(step);
        return step;
    }

    private void addSourceCodeStep(StoryStepSourceCode step) {
        StoryStepTitle titleStep;
        ObjectCondition firstStep;
        this.add(step);
        if (this.outputFile == null) {
            this.withName(step.getMethodName());
        }
        if ((firstStep = (ObjectCondition)this.steps.first()) instanceof StoryStepTitle && (titleStep = (StoryStepTitle)firstStep).getTitle() == null) {
            titleStep.setTitle(step.getMethodName());
        }
    }

    public StoryStepDiagram addDiagram(ClassModel model) {
        StoryStepDiagram step = new StoryStepDiagram();
        step.withModel(model);
        this.add(step);
        return step;
    }

    public StoryStepDiagram addDiagram(StoryObjectFilter filter) {
        StoryStepDiagram step = new StoryStepDiagram();
        step.withFilter(filter);
        this.add(step);
        return step;
    }

    public Story withName(String name) {
        if (name == null || name.length() < 1) {
            return this;
        }
        this.outputFile = name.toLowerCase().endsWith(".html") ? name : name + ".html";
        return this;
    }

    public void addImage(String imageFile) {
        this.add(new StoryStepImage().withFile(imageFile));
    }

    public boolean dumpHTML() {
        if (this.outputFile == null || this.outputFile.length() < 1) {
            return false;
        }
        boolean success = true;
        HTMLEntity output = new HTMLEntity();
        output.withHeader("../src/main/resources/de/uniks/networkparser/graph/diagramstyle.css");
        output.withEncoding("utf-8");
        output.withHeader("highlight.pack.js");
        output.withHeader("highlightjs-line-numbers.min.js");
        output.withHeader("github.css");
        output.withHeader("default.css");
        output.withScript("hljs.initHighlightingOnLoad();\r\nhljs.initLineNumbersOnLoad();");
        SimpleEvent evt = new SimpleEvent(this, null, null, output);
        for (ObjectCondition step : this.steps) {
            if (step.update(evt)) continue;
            success = false;
            break;
        }
        this.writeFile(output);
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeFile(HTMLEntity output) {
        block21: {
            boolean bl;
            if (this.outputFile == null || this.outputFile.length() < 1) {
                return false;
            }
            File file = new File("doc/" + this.outputFile);
            FileOutputStream fop = null;
            try {
                fop = new FileOutputStream(file);
                if (!file.exists() && !file.createNewFile()) {
                    boolean bl2 = false;
                    return bl2;
                }
                byte[] contentInBytes = output.toString(2).getBytes();
                fop.write(contentInBytes);
                fop.flush();
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                break block21;
            }
            catch (IOException iOException) {
                break block21;
            }
            finally {
                if (fop != null) {
                    try {
                        fop.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }

    public boolean addDescription(String key, String value) {
        StoryStepSourceCode source = null;
        for (int i = this.steps.size() - 1; i >= 0; --i) {
            ObjectCondition step = (ObjectCondition)this.steps.get(i);
            if (!(step instanceof StoryStepSourceCode)) continue;
            source = (StoryStepSourceCode)step;
            break;
        }
        if (source != null) {
            source.addDescription(key, value);
            return true;
        }
        return false;
    }

    public Story withCounter(int counter) {
        this.counter = counter;
        return this;
    }

    public int getCounter() {
        int value;
        if ((value = this.counter++) >= 0) {
            // empty if block
        }
        return value;
    }

    public Story addText(String text) {
        StoryStepText step = new StoryStepText();
        step.withText(text);
        this.add(step);
        return this;
    }

    protected Story withBreakOnAssert(boolean value) {
        this.breakOnAssert = value;
        return this;
    }

    public Story withMap(IdMap map) {
        this.map = map;
        return this;
    }

    public IdMap getMap() {
        if (this.map == null) {
            this.map = new IdMap();
        }
        return this.map;
    }

    public void finish() {
        for (ObjectCondition step : this.steps) {
            if (!(step instanceof StoryStepSourceCode)) continue;
            StoryStepSourceCode sourceCode = (StoryStepSourceCode)step;
            sourceCode.finish();
        }
    }

    private void addCondition(StoryStepCondition step) {
        this.add(step);
        if (!step.checkCondition() && this.breakOnAssert) {
            block4: {
                this.dumpHTML();
                Method assertClass = null;
                try {
                    assertClass = Class.forName("org.junit.Assert").getMethod("assertTrue", String.class, Boolean.TYPE);
                    if (assertClass != null) {
                        assertClass.invoke(null, "FAILED: " + step.getMessage(), false);
                    }
                }
                catch (ReflectiveOperationException e) {
                    if (!(e instanceof InvocationTargetException)) break block4;
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    StoryUtil.throwException(targetException);
                }
            }
            throw new RuntimeException(step.getMessage());
        }
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected, delta));
        this.addCondition(step);
    }

    public void assertEquals(String message, int expected, int actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertEquals(String message, long expected, long actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Equals().withValue(expected));
        this.addCondition(step);
    }

    public void assertTrue(String message, boolean actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new BooleanCondition().withValue(true));
        this.addCondition(step);
    }

    public void assertFalse(String message, boolean actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new BooleanCondition().withValue(false));
        this.addCondition(step);
    }

    public void assertNull(String message, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, Equals.createNullCondition());
        this.addCondition(step);
    }

    public void assertNotNull(String message, Object actual) {
        StoryStepCondition step = new StoryStepCondition();
        step.withCondition(message, actual, new Not().with(Equals.createNullCondition()));
        this.addCondition(step);
    }
}

