/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.NodeProxyType;
import de.uniks.networkparser.ext.petaf.Server_TCP;
import de.uniks.networkparser.ext.petaf.messages.ConnectMessage;
import de.uniks.networkparser.interfaces.ObjectCondition;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;

public class NodeProxyTCP
extends NodeProxy {
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_PORT = "port";
    protected int port;
    protected String url;
    public static final String LOCALHOST = "127.0.0.1";
    protected Server_TCP serverSocket;
    protected boolean allowAnswer = false;
    private ObjectCondition listener;

    public NodeProxyTCP() {
        this.property.addAll(PROPERTY_URL, PROPERTY_PORT);
        this.propertyUpdate.addAll(PROPERTY_URL, PROPERTY_PORT);
        this.propertyInfo.addAll(PROPERTY_URL, PROPERTY_PORT);
    }

    public String getUrl() {
        return this.url;
    }

    public NodeProxyTCP withUrl(String value) {
        String oldValue = value;
        this.url = value;
        this.firePropertyChange(PROPERTY_URL, oldValue, value);
        return this;
    }

    public NodeProxyTCP withURLPort(String url, int port) {
        this.withUrl(url);
        this.withPort(port);
        return this;
    }

    @Override
    public String getKey() {
        return this.url + ":" + this.port;
    }

    public Integer getPort() {
        return this.port;
    }

    public NodeProxyTCP withAllowAnswer(boolean value) {
        this.allowAnswer = value;
        return this;
    }

    public boolean isAllowAnswer() {
        return this.allowAnswer;
    }

    public NodeProxyTCP withPort(int value) {
        int oldValue = value;
        this.port = value;
        this.firePropertyChange(PROPERTY_PORT, oldValue, value);
        return this;
    }

    @Override
    public Object getValue(Object element, String attrName) {
        if (element instanceof NodeProxyTCP) {
            NodeProxyTCP nodeProxy = (NodeProxyTCP)element;
            if (PROPERTY_URL.equals(attrName)) {
                return nodeProxy.getUrl();
            }
            if (PROPERTY_PORT.equals(attrName)) {
                return nodeProxy.getPort();
            }
        }
        return super.getValue(element, attrName);
    }

    @Override
    public boolean setValue(Object element, String attrName, Object value, String type) {
        if (element instanceof NodeProxyTCP) {
            NodeProxyTCP nodeProxy = (NodeProxyTCP)element;
            if (PROPERTY_URL.equals(attrName)) {
                nodeProxy.withUrl((String)value);
                return true;
            }
            if (PROPERTY_PORT.equals(attrName)) {
                nodeProxy.withPort((Integer)value);
                return true;
            }
        }
        return super.setValue(element, attrName, value, type);
    }

    public Message readFromInputStream(Socket socket) throws IOException {
        int bytesRead;
        ByteBuffer buffer = new ByteBuffer();
        byte[] messageArray = new byte[BUFFER];
        InputStream is = socket.getInputStream();
        while (-1 != (bytesRead = is.read(messageArray, 0, BUFFER))) {
            buffer.with(new String(messageArray, 0, bytesRead, Charset.forName("UTF-8")));
            if (bytesRead == BUFFER || !this.allowAnswer) continue;
        }
        Message msg = null;
        if (this.space != null) {
            IdMap map = this.space.getMap();
            Object element = map.decode(buffer);
            this.space.updateNetwork(NodeProxyType.IN, this);
            if (element instanceof Message) {
                msg = (Message)element;
                NodeProxy receiver = msg.getReceiver();
                if (element instanceof ConnectMessage) {
                    receiver.updateReceive(buffer.size(), false);
                } else {
                    receiver.updateReceive(buffer.size(), true);
                }
                if (receiver != null) {
                    this.space.with(receiver);
                }
            }
        }
        if (msg == null) {
            msg = new Message();
        }
        msg.withMessage(buffer.flip(false));
        msg.withSession(socket);
        msg.withAddToReceived(this);
        if (this.listener != null) {
            this.listener.update(msg);
        }
        if (this.allowAnswer) {
            this.getExecutor().handleMsg(msg);
        } else {
            socket.close();
            this.getExecutor().handleMsg(msg);
        }
        return msg;
    }

    @Override
    protected boolean sending(Message msg) {
        if (super.sending(msg)) {
            return true;
        }
        boolean success = false;
        try {
            if (this.url != null && (msg.isSendAnyHow() || this.isOnline())) {
                InetAddress addr = InetAddress.getByName(this.url);
                Socket requestSocket = new Socket(addr, this.port);
                if (msg.getTimeOut() > 0) {
                    requestSocket.setSoTimeout(msg.getTimeOut());
                }
                OutputStream os = requestSocket.getOutputStream();
                byte[] buffer = this.space != null ? this.space.convertMessage(msg).getBytes() : msg.toString().getBytes();
                int start = 0;
                int size = BUFFER;
                while (true) {
                    int end;
                    if ((end = start + BUFFER) > buffer.length) break;
                    os.write(buffer, start, size);
                    start = end;
                }
                size = buffer.length - start;
                os.write(buffer, start, size);
                os.flush();
                if (this.allowAnswer) {
                    this.readFromInputStream(requestSocket);
                }
                this.setSendTime(buffer.length);
                requestSocket.close();
                success = true;
            }
        }
        catch (IOException ioException) {
            this.withOnline(false);
            success = false;
        }
        return success;
    }

    public boolean start() {
        return this.initProxy();
    }

    @Override
    public boolean close() {
        if (this.serverSocket != null) {
            this.serverSocket.closeServer();
            this.serverSocket = null;
        }
        return true;
    }

    @Override
    protected boolean initProxy() {
        boolean isInput = NodeProxyType.isInput(this.getType());
        if (this.url == null && this.getType() == null || isInput) {
            if (this.serverSocket != null) {
                return true;
            }
            if (!isInput) {
                this.withType(NodeProxyType.IN);
            }
            this.serverSocket = new Server_TCP(this);
            if (this.url == null) {
                try {
                    String url = InetAddress.getLocalHost().getHostAddress();
                    if (!LOCALHOST.equals(url)) {
                        this.url = url;
                    }
                }
                catch (UnknownHostException unknownHostException) {}
            }
        } else {
            this.withType(NodeProxyType.OUT);
            if (this.url == null) {
                try {
                    this.url = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    @Override
    public boolean isSendable() {
        return this.url != null;
    }

    public static NodeProxyTCP create(String url, int port) {
        NodeProxyTCP proxy = new NodeProxyTCP().withURLPort(url, port);
        return proxy;
    }

    public static NodeProxyTCP createServer(int port) {
        NodeProxyTCP proxy = new NodeProxyTCP();
        proxy.withPort(port);
        proxy.withType(NodeProxyType.INOUT);
        return proxy;
    }

    @Override
    public NodeProxyTCP getSendableInstance(boolean reference) {
        return new NodeProxyTCP();
    }

    public NodeProxyTCP withListener(ObjectCondition condition) {
        this.listener = condition;
        this.allowAnswer = true;
        return this;
    }
}

