/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.proxy;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.ext.petaf.Message;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.NodeProxyType;
import de.uniks.networkparser.json.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;

public class NodeProxyGoogleCloud
extends NodeProxy {
    private String API_KEY;
    private String senderId;

    @Override
    public int compareTo(NodeProxy o) {
        return 0;
    }

    @Override
    public String getKey() {
        return this.API_KEY;
    }

    @Override
    public boolean close() {
        return true;
    }

    @Override
    protected boolean initProxy() {
        this.withType(NodeProxyType.OUT);
        return true;
    }

    @Override
    public boolean isSendable() {
        return this.API_KEY != null;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new NodeProxyGoogleCloud();
    }

    @Override
    protected boolean sending(Message msg) {
        boolean success = super.sending(msg);
        if (success) {
            return true;
        }
        try {
            int bytesRead;
            JsonObject jGcmData = new JsonObject();
            JsonObject jData = new JsonObject();
            String buffer = this.space != null ? this.space.convertMessage(msg) : msg.toString();
            jData.put("message", buffer.trim());
            if (this.senderId != null && this.senderId.length() > 1) {
                jGcmData.put("to", this.senderId.trim());
            } else {
                jGcmData.put("to", "/topics/global");
            }
            jGcmData.put("data", jData);
            URL url = new URL("https://android.googleapis.com/gcm/send");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Authorization", "key=" + this.API_KEY);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(jGcmData.toString().getBytes());
            byte[] messageArray = new byte[BUFFER];
            ByteBuffer readBuffer = new ByteBuffer();
            InputStream is = conn.getInputStream();
            while (-1 != (bytesRead = is.read(messageArray, 0, BUFFER))) {
                readBuffer.with(new String(messageArray, 0, bytesRead, Charset.forName("UTF-8")));
                if (bytesRead == BUFFER) continue;
            }
            String resp = buffer.toString();
            System.out.println(resp);
            System.out.println("Check your device/emulator for notification or logcat for confirmation of the receipt of the GCM message.");
        }
        catch (IOException e) {
            System.out.println("Unable to send GCM message.");
            System.out.println("Please ensure that API_KEY has been replaced by the server API key, and that the device's registration token is correct (if specified).");
            e.printStackTrace();
        }
        return true;
    }
}

