/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.DiagramEvents;
import de.uniks.networkparser.ext.javafx.GUIEvent;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.io.File;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DiagramController
extends SimpleController {
    private static final String CRLF = "\r\n";
    private Object browser;
    private Object webEngine;
    private Object logic;

    public DiagramController(Object primitiveStage) {
        super(primitiveStage);
    }

    public void show() {
        String string3;
        this.withTitle("ClassdiagrammEditor");
        this.withSize(900.0, 600.0);
        this.withErrorPath("errors");
        SimpleKeyValueList<String, String> map = this.getParameterMap();
        String value = map.get("logic");
        if (value == null) {
            this.logic = this;
        } else {
            try {
                Class<?> clazz = Class.forName(value);
                this.logic = clazz.newInstance();
            }
            catch (Exception clazz) {
                // empty catch block
            }
        }
        this.browser = ReflectionLoader.newInstance(ReflectionLoader.WEBVIEW, new Object[0]);
        this.webEngine = ReflectionLoader.call("getEngine", this.browser, new Object[0]);
        StringBuilder content = new StringBuilder("<html><head>\r\n");
        String body = "</head><body>\r\n<script language=\"Javascript\">classEditor = new ClassEditor(\"board\");</script></body></html>";
        if (map.containsKey("export")) {
            content.append("<script src=\"drawer.js\"></script>\r\n");
            content.append("<script src=\"graph.js\"></script>\r\n");
            content.append("<link href=\"diagramstyle.css\" rel=\"stylesheet\" type=\"text/css\">\r\n");
            content.append(body);
            FileBuffer.writeFile("drawer.js", FileBuffer.readResource("graph/drawer.js"));
            FileBuffer.writeFile("graph.js", FileBuffer.readResource("graph/graph.js"));
            FileBuffer.writeFile("diagramstyle.css", FileBuffer.readResource("graph/diagramstyle.css"));
            FileBuffer.writeFile("Editor.html", content.toString());
            try {
                string3 = new File("Editor.html").toURI().toURL().toString();
                ReflectionLoader.call("load", this.webEngine, string3);
            }
            catch (MalformedURLException string2) {}
        } else if (map.containsKey("exportall")) {
            content.append(this.readFile("graph/drawer.js"));
            content.append(this.readFile("graph/graph.js"));
            content.append(this.readFile("graph/diagramstyle.css"));
            content.append(body);
            FileBuffer.writeFile("Editor.html", content.toString());
            try {
                string3 = new File("Editor.html").toURI().toURL().toString();
                ReflectionLoader.call("load", this.webEngine, string3);
            }
            catch (MalformedURLException string3) {}
        } else {
            content.append(this.readFile("graph/drawer.js"));
            content.append(this.readFile("graph/graph.js"));
            content.append(this.readFile("graph/diagramstyle.css"));
            content.append(body);
            ReflectionLoader.call("loadContent", this.webEngine, content.toString());
        }
        GUIEvent eventListener = new GUIEvent().withListener(new DiagramEvents(this.webEngine, this));
        Object proxy = ReflectionLoader.createProxy(eventListener, ReflectionLoader.EVENTHANDLER);
        ReflectionLoader.call("setOnError", this.webEngine, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnDragExited", this.browser, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnDragOver", this.browser, ReflectionLoader.EVENTHANDLER, proxy);
        ReflectionLoader.call("setOnDragDropped", this.browser, ReflectionLoader.EVENTHANDLER, proxy);
        Object stateProperty = ReflectionLoader.callChain(this.webEngine, "getLoadWorker", "stateProperty");
        Object changeProxy = ReflectionLoader.createProxy(eventListener, ReflectionLoader.CHANGELISTENER);
        ReflectionLoader.call("addListener", stateProperty, ReflectionLoader.CHANGELISTENER, changeProxy);
        super.show(this.browser);
    }

    private CharacterBuffer readFile(String file) {
        CharacterBuffer readResource = FileBuffer.readResource(file);
        if (file.endsWith(".js")) {
            readResource.withStart("<script language=\"Javascript\">", true);
            readResource.with("</script>", CRLF);
        } else if (file.endsWith(".css")) {
            readResource.withStart("<style>", true);
            readResource.with("</style>", CRLF);
        }
        return readResource;
    }

    public boolean generate(JsonObject model) {
        if (this.logic != null) {
            return (Boolean)ReflectionLoader.call("generate", this.logic, JsonObject.class, model);
        }
        return false;
    }

    public boolean save(JsonObject model) {
        String name = model.getString("package");
        if (name == null || name.length() < 1) {
            name = "model";
            if (model.size() < 1) {
                return false;
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        name = name + "_" + formatter.format(new Date().getTime()) + ".json";
        return FileBuffer.writeFile(name, model.toString());
    }
}

