/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.NetworkParserLog;
import de.uniks.networkparser.ext.ErrorHandler;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.ext.petaf.Server_TCP;
import de.uniks.networkparser.ext.petaf.Server_UPD;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyBroadCast;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import de.uniks.networkparser.ext.story.Story;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleSet;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;

public class ReflectionBlackBoxTester {
    public static final String NULLVALUE = "nullValue";
    public static final String MINVALUE = "minValue";
    public static final String MAXVALUE = "maxValue";
    public static final String RANDOMVALUE = "randomValue";
    private SimpleSet<String> tests = (SimpleSet)new SimpleSet().with("nullValue", "minValue", "randomValue");
    private SimpleKeyValueList<String, SimpleSet<String>> ignoreMethods = new SimpleKeyValueList();
    private int errorCount;
    private int successCount;
    private String packageName;
    private NetworkParserLog logger;

    public ReflectionBlackBoxTester() {
        String className = Story.class.getName();
        this.withIgnoreClazzes(className + ":dumpHTML");
        this.withIgnoreClazzes(className + ":writeFile");
        this.withIgnoreClazzes(ErrorHandler.class.getName());
        className = SimpleController.class.getName();
        this.withIgnoreClazzes(className + ":init");
        this.withIgnoreClazzes(className + ":saveException");
        this.withIgnoreClazzes(className + ":createContent");
        this.withIgnoreClazzes(className + ":showContent");
        this.withIgnoreClazzes(className + ":withErrorPath");
        this.withIgnoreClazzes(Server_TCP.class.getName());
        this.withIgnoreClazzes(Server_UPD.class.getName());
        this.withIgnoreClazzes(Space.class.getName());
        this.withIgnoreClazzes(NodeProxyBroadCast.class.getName());
        this.withIgnoreClazzes(NodeProxyTCP.class.getName());
    }

    public ReflectionBlackBoxTester withIgnoreClazzes(String ... values) {
        if (values == null) {
            return this;
        }
        for (String item : values) {
            int pos = item.indexOf(":");
            if (pos < 0) {
                if (this.ignoreMethods.contains(item)) continue;
                this.ignoreMethods.put(item, new SimpleSet());
                continue;
            }
            String clazz = item.substring(0, pos);
            String method = item.substring(pos + 1);
            SimpleSet methods = this.ignoreMethods.get(clazz);
            if (methods instanceof SimpleSet) {
                methods.add((String)method);
                continue;
            }
            methods = (SimpleSet)new SimpleSet().with(method);
            this.ignoreMethods.put(clazz, methods);
        }
        return this;
    }

    public void test(String packageName, NetworkParserLog logger) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<Class<?>> classesForPackage = this.getClassesForPackage(packageName);
        this.errorCount = 0;
        this.successCount = 0;
        this.packageName = packageName;
        this.logger = logger;
        for (Class<?> clazz : classesForPackage) {
            SimpleSet<String> methods = this.ignoreMethods.get(clazz.getName());
            if (methods != null && methods.size() < 1) {
                System.out.println("Ignore:" + clazz.getName());
                continue;
            }
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            Object obj = null;
            for (Constructor<?> c : constructors) {
                Object[] call = this.getParameters(c.getParameterTypes(), NULLVALUE);
                c.setAccessible(true);
                try {
                    obj = c.newInstance(call);
                    if (obj == null || obj == null) continue;
                    this.testClass(obj, clazz, methods);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.output("Errors: " + this.errorCount + "/" + (this.errorCount + this.successCount), logger, 1);
    }

    private void testClass(Object obj, Class<?> clazz, SimpleSet<String> ignoreMethods) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getDeclaringClass().isInterface() || ignoreMethods != null && ignoreMethods.contains(method.getName())) continue;
            Object[] call = null;
            method.setAccessible(true);
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (this.tests.contains(NULLVALUE)) {
                try {
                    call = this.getParameters(parameterTypes, NULLVALUE);
                    method.invoke(obj, call);
                    ++this.successCount;
                }
                catch (Exception e) {
                    this.saveException(e, clazz, method, call);
                }
            }
            if (this.tests.contains(MINVALUE)) {
                try {
                    call = this.getParameters(parameterTypes, MINVALUE);
                    method.invoke(obj, call);
                    ++this.successCount;
                }
                catch (Exception e) {
                    this.saveException(e, clazz, method, call);
                }
            }
            if (this.tests.contains(MAXVALUE)) {
                try {
                    call = this.getParameters(parameterTypes, MAXVALUE);
                    method.invoke(obj, call);
                    ++this.successCount;
                }
                catch (Exception e) {
                    this.saveException(e, clazz, method, call);
                }
            }
            if (!this.tests.contains(RANDOMVALUE)) continue;
            try {
                call = this.getParameters(parameterTypes, RANDOMVALUE);
                method.invoke(obj, call);
                ++this.successCount;
            }
            catch (Exception e) {
                this.saveException(e, clazz, method, call);
            }
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            try {
                ((Field)accessibleObject).setAccessible(true);
                Object value = ((Field)accessibleObject).get(obj);
                if (value == null) {
                    this.output("field null", this.logger, 2);
                }
                if (Modifier.isFinal(((Field)accessibleObject).getModifiers()) || value == null) continue;
                ((Field)accessibleObject).set(obj, this.getNullValue(value.getClass()));
                ((Field)accessibleObject).set(obj, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void saveException(Exception e, Class<?> clazz, Method m, Object[] call) {
        String line = this.getLine(this.packageName, e, clazz.getSimpleName());
        if (line.length() < 1) {
            line = clazz.getName() + ".java:1";
        }
        String shortName = "";
        if (line.lastIndexOf(".") > 0) {
            String[] split = line.split("\\.");
            shortName = line.substring(0, line.lastIndexOf(":") - 4) + m.getName() + "(" + split[split.length - 2] + "." + split[split.length - 1] + ")";
        }
        this.output("at " + clazz.getName() + ": " + e.getCause() + " " + shortName + " : ", this.logger, 2);
        ++this.errorCount;
    }

    public String getParamtoString(Object[] params) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (params == null) {
            sb.append(")");
            return sb.toString();
        }
        boolean hasParam = false;
        for (Object item : params) {
            if (hasParam) {
                sb.append(",");
            }
            if (item == null) {
                sb.append("null");
            } else {
                sb.append(item.toString());
            }
            hasParam = true;
        }
        sb.append(")");
        return sb.toString();
    }

    public void output(String message, NetworkParserLog logger, int logLevel) {
        if (logger != null) {
            logger.log(this, "output", message, logLevel);
        }
    }

    private Object[] getParameters(Class<?>[] parameters, String type) {
        int length = parameters.length;
        Object[] objects = new Object[length];
        if (NULLVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getNullValue(parameters[i]);
            }
            return objects;
        }
        if (MINVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getMinValue(parameters[i]);
            }
            return objects;
        }
        if (MAXVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getMaxValue(parameters[i]);
            }
            return objects;
        }
        if (RANDOMVALUE.equals(type)) {
            for (int i = 0; i < length; ++i) {
                objects[i] = this.getRandomValue(parameters[i]);
            }
        }
        return objects;
    }

    private boolean euqalsClass(Class<?> clazz, Class<?> ... checkClasses) {
        if (checkClasses == null) {
            return true;
        }
        for (Class<?> check : checkClasses) {
            if (!clazz.getName().equals(check.getName())) continue;
            return true;
        }
        return false;
    }

    private Object getNullValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (this.euqalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return false;
            }
            if (this.euqalsClass(clazz, Byte.TYPE, Byte.class)) {
                return (byte)0;
            }
            if (this.euqalsClass(clazz, Short.TYPE, Short.class)) {
                return 0;
            }
            if (this.euqalsClass(clazz, Integer.TYPE, Integer.class)) {
                return 0;
            }
            if (this.euqalsClass(clazz, Long.TYPE, Long.class)) {
                return 0L;
            }
            if (this.euqalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('\u0000');
            }
            if (this.euqalsClass(clazz, Float.TYPE, Float.class)) {
                return Float.valueOf(0.0f);
            }
            if (this.euqalsClass(clazz, Double.TYPE, Double.class)) {
                return 0.0;
            }
            if (this.euqalsClass(clazz, String.class, CharSequence.class)) {
                return null;
            }
        }
        return null;
    }

    private Object getMinValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (this.euqalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return false;
            }
            if (this.euqalsClass(clazz, Byte.TYPE, Byte.class)) {
                return (byte)-128;
            }
            if (this.euqalsClass(clazz, Integer.TYPE, Integer.class)) {
                return Integer.MIN_VALUE;
            }
            if (this.euqalsClass(clazz, Short.TYPE, Short.class)) {
                return (short)Short.MIN_VALUE;
            }
            if (this.euqalsClass(clazz, Long.TYPE, Long.class)) {
                return Long.MIN_VALUE;
            }
            if (this.euqalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('\u0000');
            }
            if (this.euqalsClass(clazz, Float.TYPE, Float.class)) {
                return Float.valueOf(Float.MIN_VALUE);
            }
            if (this.euqalsClass(clazz, Double.TYPE, Double.class)) {
                return Double.MIN_VALUE;
            }
            if (this.euqalsClass(clazz, String.class, CharSequence.class)) {
                return "";
            }
        }
        return null;
    }

    private Object getRandomValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (this.euqalsClass(clazz, Byte.TYPE, Byte.class)) {
                return 80;
            }
            if (this.euqalsClass(clazz, Integer.TYPE, Integer.class)) {
                return 42;
            }
            if (this.euqalsClass(clazz, Short.TYPE, Short.class)) {
                return 2;
            }
            if (this.euqalsClass(clazz, Long.TYPE, Long.class)) {
                return 3;
            }
            if (this.euqalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('g');
            }
            if (this.euqalsClass(clazz, Float.TYPE, Float.class)) {
                return 6;
            }
            if (this.euqalsClass(clazz, Double.TYPE, Double.class)) {
                return 8;
            }
            if (this.euqalsClass(clazz, String.class, CharSequence.class)) {
                return "Albert";
            }
        } else {
            if (clazz.isArray()) {
                Class<?> arrayClazz = clazz.getComponentType();
                int nrDims = 1 + clazz.getName().lastIndexOf(91);
                int[] dims = new int[nrDims];
                for (int i = 0; i < nrDims; ++i) {
                    dims[i] = i + 1;
                }
                return Array.newInstance(arrayClazz, dims);
            }
            try {
                if (ReflectionLoader.STAGE == clazz) {
                    return null;
                }
                return clazz.newInstance();
            }
            catch (Exception e) {
                Constructor<?>[] declaredConstructors;
                for (Constructor<?> c : declaredConstructors = clazz.getDeclaredConstructors()) {
                    try {
                        Object[] call = this.getParameters(c.getParameterTypes(), NULLVALUE);
                        c.setAccessible(true);
                        return c.newInstance(call);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        return null;
    }

    private Object getMaxValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (this.euqalsClass(clazz, Boolean.TYPE, Boolean.class)) {
                return false;
            }
            if (this.euqalsClass(clazz, Byte.TYPE, Byte.class)) {
                return (byte)127;
            }
            if (this.euqalsClass(clazz, Integer.TYPE, Integer.class)) {
                return Integer.MAX_VALUE;
            }
            if (this.euqalsClass(clazz, Short.TYPE, Short.class)) {
                return (short)Short.MAX_VALUE;
            }
            if (this.euqalsClass(clazz, Long.TYPE, Long.class)) {
                return Long.MAX_VALUE;
            }
            if (this.euqalsClass(clazz, Character.TYPE, Character.class)) {
                return Character.valueOf('\uffff');
            }
            if (this.euqalsClass(clazz, Float.TYPE, Float.class)) {
                return Float.valueOf(Float.MAX_VALUE);
            }
            if (this.euqalsClass(clazz, Double.TYPE, Double.class)) {
                return Double.MAX_VALUE;
            }
        }
        return null;
    }

    private String getLine(String packageName, Exception e, String clazzName) {
        String line;
        Throwable cause = e.getCause();
        if (cause != null && (line = this.getLineFromThrowable(packageName, cause, clazzName)).length() > 0) {
            return line;
        }
        return this.getLineFromThrowable(packageName, e, clazzName);
    }

    private String getLineFromThrowable(String packageName, Throwable e, String clazzName) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement ste : stackTrace = e.getStackTrace()) {
            String name = ste.getClassName();
            if (!name.startsWith(packageName) || name.startsWith(packageName + ".test")) continue;
            return name + ".java:" + ste.getLineNumber();
        }
        return "";
    }

    private void checkDirectory(File directory, String pckgname, ArrayList<Class<?>> classes) throws ClassNotFoundException {
        if (directory.exists() && directory.isDirectory()) {
            String[] files = directory.list();
            if (files == null) {
                return;
            }
            for (String file : files) {
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(pckgname + '.' + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory() || file.equalsIgnoreCase("test")) continue;
                this.checkDirectory(tmpDirectory, pckgname + "." + file, classes);
            }
        }
    }

    public ArrayList<Class<?>> getClassesForPackage(String pckgname) throws ClassNotFoundException, IOException {
        Class<?> forName;
        ArrayList classes = new ArrayList();
        ClassLoader cld = Thread.currentThread().getContextClassLoader();
        if (cld == null) {
            return classes;
        }
        Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
        URL url = null;
        while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
            this.checkDirectory(new File(URLDecoder.decode(url.getPath(), "utf-8")), pckgname, classes);
        }
        if (classes.size() == 0 && (forName = Class.forName(pckgname)) != null) {
            classes.add(forName);
        }
        return classes;
    }
}

