/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.generic;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.ext.generic.GenericCreator;
import de.uniks.networkparser.json.JsonObject;

public class JsonParser {
    private IdMap map;

    public IdMap getMap() {
        if (this.map == null) {
            this.map = new IdMap();
        }
        return this.map;
    }

    public <T> T decode(Object json) {
        return this.decode(json, null);
    }

    public <T> T decode(Object json, Class<T> classOfT) {
        JsonObject jsonObject = null;
        if (json instanceof String) {
            jsonObject = new JsonObject().withValue((String)json);
        } else if (json instanceof JsonObject) {
            jsonObject = (JsonObject)json;
        }
        if (jsonObject == null) {
            return null;
        }
        String className = jsonObject.getString("class");
        if (className == null || className.length() < 1) {
            if (classOfT == null) {
                return null;
            }
            className = classOfT.getName();
            if (!jsonObject.has("prop")) {
                JsonObject obj = new JsonObject();
                obj.put("prop", jsonObject);
                jsonObject = obj;
            }
            jsonObject.put("class", className);
        }
        IdMap map = this.getMap();
        GenericCreator.create(map, className);
        Object result = map.decode(jsonObject);
        if (classOfT == null) {
            try {
                Class<?> targetClass = Class.forName(className);
                if (targetClass == null) {
                    return null;
                }
                return (T)targetClass.cast(result);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return classOfT.cast(result);
    }

    public JsonObject encode(Object src) {
        if (src == null) {
            return new JsonObject();
        }
        IdMap map = this.getMap();
        GenericCreator.create(map, src.getClass());
        return map.toJsonObject(src);
    }

    public static <T> T fromJson(Object json) {
        return new JsonParser().decode(json);
    }

    public static <T> T fromJson(Object json, Class<T> classOfT) {
        return new JsonParser().decode(json, classOfT);
    }

    public static JsonObject toJson(Object src) {
        return new JsonParser().encode(src);
    }
}

