/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.MapEntity;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleList;

public class SimpleGrammar
implements Grammar {
    private SimpleList<String> basicProperties = (SimpleList)new SimpleList().with("id", "class", "session", "timestamp");

    @Override
    public BaseItem getProperties(Entity item, MapEntity map, boolean isId) {
        if (isId) {
            if (item.has("prop")) {
                return ((JsonObject)item).getJsonObject("prop");
            }
            return item;
        }
        JsonObject props = new JsonObject();
        for (int i = 0; i < item.size(); ++i) {
            if ("class".equalsIgnoreCase(item.getKeyByIndex(i))) continue;
            props.put(item.getKeyByIndex(i), item.getValueByIndex(i));
        }
        return props;
    }

    @Override
    public String getId(Object obj, IdMap map) {
        return null;
    }

    @Override
    public Entity writeBasicValue(Entity entity, String className, String id, IdMap map) {
        String session;
        if (this.basicProperties.contains("session") && (session = map.getSession()) != null) {
            entity.put("session", session);
        }
        if (this.basicProperties.contains("class")) {
            entity.setType(className);
        }
        if (id != null) {
            if (this.basicProperties.contains("id")) {
                entity.put("id", id);
            }
            if (this.basicProperties.contains("timestamp") && map.getTimeStamp() == 0L) {
                String ts = null;
                if (id.length() > 0) {
                    ts = id.substring(1);
                }
                if (EntityUtil.isNumeric(ts)) {
                    entity.put("timestamp", ts);
                }
            }
        }
        return entity;
    }

    @Override
    public SendableEntityCreator getCreator(String type, Object item, IdMap map, boolean searchForSuperCreator, String className) {
        SendableEntityCreator creator;
        if ("write".equals(type)) {
            SendableEntityCreator creator2 = map.getCreator(className, true, null);
            if (creator2 != null) {
                return creator2;
            }
            if (item instanceof SendableEntityCreator) {
                return (SendableEntityCreator)item;
            }
            return this.getSuperCreator(map, searchForSuperCreator, item);
        }
        if (className == null && item instanceof Entity) {
            Object name = ((Entity)item).getValue("class");
            if (name == null) {
                return null;
            }
            className = (String)name;
        }
        if ((creator = map.getCreator(className, true, null)) != null) {
            return creator;
        }
        Class<?> clazzName = this.getClassForName(className);
        return this.getSuperCreator(map, searchForSuperCreator, clazzName);
    }

    public SendableEntityCreator getSuperCreator(IdMap map, boolean searchForSuperCreator, Object modelItem) {
        return null;
    }

    protected Class<?> getClassForName(String name) {
        return null;
    }

    @Override
    public boolean hasValue(Entity item, String property) {
        return item.has(property);
    }

    @Override
    public Object getNewEntity(SendableEntityCreator creator, String className, boolean prototype) {
        return creator.getSendableInstance(prototype);
    }

    @Override
    public String getValue(Entity item, String property) {
        return item.getString(property);
    }

    @Override
    public BaseItem encode(Object entity, MapEntity map) {
        return map.getTokener().encode(entity, map);
    }

    public SimpleGrammar withBasicFeature(String ... values) {
        if (values == null) {
            return this;
        }
        for (String item : values) {
            this.basicProperties.add(item);
        }
        return this;
    }

    public SimpleGrammar withoutBasicFeature(String ... values) {
        if (values == null) {
            return this;
        }
        for (String item : values) {
            this.basicProperties.without(item);
        }
        return this;
    }

    @Override
    public boolean writeValue(BaseItem parent, String property, Object value, MapEntity map, Tokener tokener) {
        return false;
    }
}

