/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser.generator.logic;

import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.BooleanList;
import de.uniks.networkparser.list.NumberList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.StringList;
import de.uniks.networkparser.logic.CustomCondition;

public class JavaListCondition
extends CustomCondition<Attribute> {
    public static final String TAG = "listType";

    @Override
    public String getKey() {
        return TAG;
    }

    @Override
    public ParserCondition getSendableInstance(boolean isExpression) {
        return new JavaListCondition();
    }

    @Override
    public Object getValue(SendableEntityCreator creator, Attribute member) {
        String attributeType = member.getType().getName(true);
        if (attributeType.equals("boolean")) {
            return this.addImport((Object)creator, BooleanList.class);
        }
        if (" long Long short Short int Integer byte Byte float Float double Double ".indexOf(" " + attributeType + " ") >= 0) {
            return this.addImport((Object)creator, NumberList.class);
        }
        if (attributeType.equals("String")) {
            return this.addImport((Object)creator, StringList.class);
        }
        if (attributeType.equals("char")) {
            this.addImport((Object)creator, SimpleList.class);
            return "SimpleList<Character>";
        }
        this.addImport((Object)creator, SimpleList.class);
        return "SimpleList<" + attributeType + ">";
    }
}

