/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.ClazzType;
import de.uniks.networkparser.graph.DataType;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Method;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.Parameter;
import de.uniks.networkparser.graph.SourceCode;
import de.uniks.networkparser.graph.Throws;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.graph.util.MethodSet;
import de.uniks.networkparser.graph.util.ParameterSet;
import de.uniks.networkparser.interfaces.Condition;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.parser.SymTabEntry;
import de.uniks.networkparser.parser.Token;
import java.util.Collection;
import java.util.Set;

public class ParserEntity {
    public static final char EOF = '\u0000';
    public static final char COMMENT_START = 'c';
    public static final char LONG_COMMENT_END = 'd';
    public static final String VOID = "void";
    public static final String CLASS = "class";
    public static final String INTERFACE = "interface";
    public static final String ENUM = "enum";
    public static final String IMPLEMENTS = "implements";
    public static final String EXTENDS = "extends";
    public static final String NAME_TOKEN = "nameToken";
    public static final String CLASS_BODY = "classBody";
    public static final String CLASS_END = "classEnd";
    public static final String ENUMVALUE = "enumvalue";
    public static char NEW_LINE = (char)10;
    private Clazz file;
    public Token lookAheadToken = new Token();
    public Token previousToken = new Token();
    public Token currentToken = new Token();
    public char currentChar;
    public char lookAheadChar;
    public int index;
    public int lookAheadIndex = -1;
    public int parsePos;
    public SymTabEntry symTabEntry;
    private SourceCode code;
    private String searchString;
    public int indexOfResult;
    private boolean verbose = false;
    private static final String SDMLIBFILES = "org.sdmlib.serialization.EntityFactory org.sdmlib.models.pattern.PatternObject org.sdmlib.models.pattern.util.PatternObjectCreator org.sdmlib.models.modelsets.SDMSet org.sdmlib.serialization.PropertyChangeInterface";
    private static final String SKIPMETGODS = "get(String) firePropertyChange(String,Object,Object) set(String,Object) getPropertyChangeSupport() removeYou() addPropertyChangeListener(PropertyChangeListener) removePropertyChangeListener(PropertyChangeListener) addPropertyChangeListener(String,PropertyChangeListener) removePropertyChangeListener(String,PropertyChangeListener) toString()";

    public static Clazz create(CharacterBuffer content) {
        ParserEntity parser = new ParserEntity();
        return parser.parse(content);
    }

    public Clazz parse(CharacterBuffer sequence) {
        return this.parse(sequence, new Clazz(""), "");
    }

    public Clazz parse(CharacterBuffer sequence, Clazz file, String fileName) {
        if (sequence == null || sequence.length() < 1) {
            return file;
        }
        this.file = file;
        this.code = new SourceCode().withContent(sequence);
        this.code.withFileName(fileName);
        this.code.with(this.file);
        this.nextChar();
        this.nextChar();
        this.nextToken();
        this.nextToken();
        if (this.currentTokenEquals("package")) {
            this.parsePackageDecl();
        }
        this.code.withStartImports(this.currentToken.startPos);
        while (this.currentTokenEquals("import")) {
            this.parseImport();
        }
        this.code.withEndOfImports(this.currentToken.startPos);
        this.parseClassDecl();
        return this.file;
    }

    public String currentWord() {
        return this.currentToken.text.toString();
    }

    public boolean currentKindEquals(char c) {
        return this.currentToken.kind == c;
    }

    public int getCurrentStart() {
        return this.currentToken.startPos;
    }

    public int getCurrentEnd() {
        return this.currentToken.endPos;
    }

    public boolean lookAheadKindEquals(char c) {
        return this.lookAheadToken.kind == c;
    }

    public boolean currentTokenEquals(String word) {
        return ParserEntity.stringEquals(this.currentWord(), word);
    }

    public static boolean stringEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public boolean skip(char character, boolean skipCRLF) {
        if (this.currentKindEquals(character)) {
            if (skipCRLF) {
                this.nextRealToken();
                return true;
            }
            this.nextToken();
            return true;
        }
        this.error("" + character);
        return false;
    }

    public boolean skip(String string, boolean skipCRLF) {
        if (this.currentTokenEquals(string)) {
            if (skipCRLF) {
                this.nextRealToken();
                return true;
            }
            this.nextToken();
            return true;
        }
        this.error(string);
        return false;
    }

    public void error(CharSequence info) {
        System.err.println("Parser Error: expected token " + info + " found " + this.currentWord() + " at pos " + this.currentToken.startPos + " at line " + this.getLineIndexOf(this.currentToken.startPos, this.code.getContent()));
        throw new RuntimeException("parse error");
    }

    public void nextRealToken() {
        this.nextToken();
        while (this.currentToken.kind == NEW_LINE) {
            this.nextToken();
        }
    }

    public void nextToken() {
        Token tmp = this.previousToken;
        this.previousToken = this.currentToken;
        this.currentToken = this.lookAheadToken;
        this.lookAheadToken = tmp;
        this.lookAheadToken.kind = '\u0000';
        this.lookAheadToken.text.delete(0, this.lookAheadToken.text.length());
        int state = 105;
        while (true) {
            switch (state) {
                case 105: {
                    if (Character.isLetter(this.currentChar) || this.currentChar == '_') {
                        state = 118;
                        this.lookAheadToken.kind = (char)118;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '\u0000') {
                        this.lookAheadToken.kind = '\u0000';
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        return;
                    }
                    if (Character.isDigit(this.currentChar)) {
                        state = 57;
                        this.lookAheadToken.kind = (char)57;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '/' && (this.lookAheadChar == '*' || this.lookAheadChar == '/')) {
                        this.lookAheadToken.kind = (char)99;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '*' && this.lookAheadChar == '/') {
                        this.lookAheadToken.kind = (char)100;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if ("+-*/\\\"'~=()><{}!.,@[]&|?;:#".indexOf(this.currentChar) >= 0) {
                        this.lookAheadToken.kind = this.currentChar;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '\r') {
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == NEW_LINE) {
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        return;
                    }
                    if (!Character.isWhitespace(this.currentChar)) break;
                    break;
                }
                case 57: {
                    if (Character.isDigit(this.currentChar)) {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    if (this.currentChar == '.') {
                        state = 56;
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 56: {
                    if (Character.isDigit(this.currentChar)) break;
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 118: {
                    if (Character.isLetter(this.currentChar) || Character.isDigit(this.currentChar) || this.currentChar == '_') {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
            }
            this.nextChar();
        }
    }

    private void nextChar() {
        this.currentChar = this.lookAheadChar;
        this.index = this.lookAheadIndex;
        this.lookAheadChar = '\u0000';
        while (this.lookAheadChar == '\u0000' && this.lookAheadIndex < this.code.size() - 1) {
            ++this.lookAheadIndex;
            this.lookAheadChar = this.code.getContent().charAt(this.lookAheadIndex);
        }
    }

    public SymTabEntry getRoot() {
        return this.symTabEntry;
    }

    public SymTabEntry startNextSymTab(String type) {
        SymTabEntry nextEntity = new SymTabEntry(null).withParent(this.code);
        nextEntity.setType(type);
        if (this.symTabEntry == null) {
            this.symTabEntry = nextEntity;
        } else {
            this.symTabEntry.setNext(nextEntity);
        }
        this.parsePos = this.getCurrentEnd() + 1;
        this.addCurrentToken(nextEntity);
        SimpleList<SymTabEntry> list = this.code.getSymbolEntries(type);
        list.add(nextEntity);
        return nextEntity;
    }

    public SymTabEntry startNextSymTab(String type, String name) {
        SymTabEntry nextEntity = this.startNextSymTab(type);
        nextEntity.withValue(name);
        return nextEntity;
    }

    public CharSequence finishParse(SymTabEntry nextEntity) {
        int endPos = this.getCurrentEnd();
        CharSequence sequence = this.code.subString(this.parsePos, endPos);
        nextEntity.add(sequence);
        return sequence;
    }

    public void addCurrentCharacter(char checkCharacter, SymTabEntry nextEntity) {
        if (this.currentKindEquals(checkCharacter)) {
            nextEntity.add(this.currentToken.text.toString());
            this.nextToken();
        }
    }

    public void addNewLine(SymTabEntry nextEntity) {
        if (this.currentKindEquals(NEW_LINE)) {
            nextEntity.add(this.currentToken.text.toString());
            this.nextToken();
        }
    }

    public void addCurrentToken(SymTabEntry nextEntity) {
        nextEntity.add(this.currentToken.text.toString());
    }

    private long getLineIndexOf(int startPos, CharSequence fileBody) {
        long count = 1L;
        CharSequence substring = fileBody.subSequence(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    private void parseImport() {
        SymTabEntry nextEntity = this.startNextSymTab("import");
        this.nextToken();
        String modifier = this.parseModifiers();
        nextEntity.add(modifier);
        this.parseQualifiedName(nextEntity);
        if (this.currentKindEquals('*')) {
            this.skip('*', false);
        }
        this.skip(';', true);
    }

    private String parseModifiers() {
        StringBuilder result = new StringBuilder();
        while (EntityUtil.isModifier(" " + this.currentWord() + " ")) {
            result.append(this.currentWord());
            result.append(" ");
            this.nextToken();
        }
        return result.toString();
    }

    private void parsePackageDecl() {
        SymTabEntry nextEntity = this.startNextSymTab("package");
        this.nextToken();
        this.parseQualifiedName(nextEntity);
        this.addCurrentCharacter(';', nextEntity);
        this.addNewLine(nextEntity);
    }

    private String parseAnnotations() {
        String result = "";
        while ("@".equals(this.currentWord())) {
            result = result + this.currentWord();
            this.nextToken();
            result = result + this.currentWord();
            this.nextToken();
            while (this.currentWord().equals(".")) {
                result = result + this.currentWord();
                this.nextToken();
                result = result + this.currentWord();
                this.nextToken();
            }
            if (!"(".equals(this.currentWord())) continue;
            result = result + this.currentWord();
            this.nextToken();
            while (!")".equals(this.currentWord())) {
                result = result + this.currentWord();
                this.nextToken();
            }
            result = result + this.currentWord();
            this.nextToken();
        }
        return result;
    }

    private void parseClassDecl() {
        int startPos;
        SymTabEntry nextEntity;
        int preCommentStartPos = this.currentToken.preCommentStartPos;
        int preCommentEndPos = this.currentToken.preCommentEndPos;
        int startPosAnnotations = this.currentToken.startPos;
        while ("@".equals(this.currentWord())) {
            String annotation = this.parseAnnotations();
            int endPosAnnotation = this.currentToken.startPos - 1;
            if (annotation == "") continue;
            nextEntity = this.startNextSymTab("annotation", annotation.substring(1));
            nextEntity.withPosition(startPosAnnotations, endPosAnnotation);
            this.file.with(Annotation.create(annotation));
        }
        int startPosClazz = this.currentToken.startPos;
        this.file.with(Modifier.create(this.parseModifiers()));
        String classTyp = this.parseClassType();
        String className = this.currentWord();
        this.file.with(className);
        GraphUtil.setClazzType(this.file, ClazzType.create(classTyp));
        this.code.withEndOfClassName(this.currentToken.endPos);
        nextEntity = this.startNextSymTab(classTyp, className);
        nextEntity.withPosition(startPosClazz, this.currentToken.endPos);
        nextEntity.withAnnotationsStart(startPosAnnotations).withPreComment(preCommentStartPos, preCommentEndPos);
        this.nextRealToken();
        this.parseGenericTypeSpec();
        if (EXTENDS.equalsIgnoreCase(this.currentWord())) {
            startPos = this.currentToken.startPos;
            this.skip(EXTENDS, true);
            nextEntity = this.startNextSymTab(EXTENDS, this.currentWord());
            nextEntity.withPosition(this.currentToken.startPos, this.currentToken.endPos);
            this.parseTypeRef();
            this.code.withEndOfExtendsClause(this.previousToken.endPos);
            this.checkSearchStringFound(EXTENDS, startPos);
        }
        if (IMPLEMENTS.equals(this.currentWord())) {
            startPos = this.currentToken.startPos;
            this.skip(IMPLEMENTS, true);
            while (!this.currentKindEquals('\u0000') && !this.currentKindEquals('{')) {
                nextEntity = this.startNextSymTab(IMPLEMENTS, this.currentWord());
                nextEntity.withPosition(this.currentToken.startPos, this.currentToken.endPos);
                this.nextToken();
                if (!this.currentKindEquals(',')) continue;
                this.nextToken();
            }
            this.code.withEndOfImplementsClause(this.previousToken.endPos);
            this.checkSearchStringFound(IMPLEMENTS, startPos);
        }
        this.parseClassBody();
    }

    private void parseGenericTypeSpec() {
        if (this.currentKindEquals('<')) {
            this.skipTo('>');
            this.nextToken();
        }
    }

    private String parseTypeRef() {
        StringBuilder typeString = new StringBuilder();
        String typeName = VOID;
        if (this.currentTokenEquals(VOID)) {
            this.nextToken();
        } else {
            typeName = this.parseQualifiedName().toString();
        }
        typeString.append(typeName);
        if (this.currentKindEquals('<')) {
            this.parseGenericTypeDefPart(typeString);
        }
        if (this.currentKindEquals('[')) {
            typeString.append("[]");
            this.skip("[", true);
            while (!"]".equals(this.currentWord()) && !this.currentKindEquals('\u0000')) {
                this.nextToken();
            }
            this.skip("]", true);
        }
        if (this.currentKindEquals('.')) {
            typeString.append("...");
            this.skip(".", false);
            this.skip(".", false);
            this.skip(".", true);
        }
        if (EXTENDS.equals(this.lookAheadToken.text.toString())) {
            typeString.append((CharSequence)this.currentToken.text);
            this.nextToken();
            typeString.append((CharSequence)this.currentToken.text);
            this.nextToken();
            typeString.append((CharSequence)this.currentToken.text);
            this.nextToken();
            typeString.append((CharSequence)this.currentToken.text);
        }
        if ("@".equals(typeString.toString())) {
            typeString.append((CharSequence)this.currentToken.text);
        }
        return typeString.toString();
    }

    private void parseGenericTypeDefPart(StringBuilder typeString) {
        this.skip("<", false);
        typeString.append('<');
        while (!this.currentKindEquals('>') && !this.currentKindEquals('\u0000')) {
            if (this.currentKindEquals('<')) {
                this.parseGenericTypeDefPart(typeString);
                continue;
            }
            typeString.append(this.currentWord());
            this.nextToken();
        }
        typeString.append(">");
        this.skip(">", true);
    }

    private void parseClassBody() {
        this.skip('{', true);
        this.checkSearchStringFound(CLASS_BODY, this.currentToken.startPos);
        while (!this.currentKindEquals('\u0000') && !this.currentKindEquals('}')) {
            this.parseMemberDecl();
        }
        if (this.currentKindEquals('}')) {
            this.code.withEndBody(this.currentToken.startPos);
            this.checkSearchStringFound(CLASS_END, this.currentToken.startPos);
        }
        if (!this.currentKindEquals('\u0000')) {
            this.skip("}", true);
        } else {
            this.checkSearchStringFound(CLASS_END, this.currentToken.startPos);
        }
    }

    private void parseMemberDecl() {
        int preCommentStartPos = this.currentToken.preCommentStartPos;
        int preCommentEndPos = this.currentToken.preCommentEndPos;
        int annotationsStartPos = this.currentToken.startPos;
        String annotations = this.parseAnnotations();
        int startPos = this.currentToken.startPos;
        String modifiers = this.parseModifiers();
        if (this.currentTokenEquals("<")) {
            this.skip("<", true);
            while (!this.currentTokenEquals(">")) {
                this.nextToken();
            }
            this.skip(">", true);
        }
        if (this.currentTokenEquals(CLASS) || this.currentTokenEquals(INTERFACE)) {
            while (!this.currentTokenEquals("{")) {
                this.nextToken();
            }
            this.skipBody();
            return;
        }
        if (this.currentTokenEquals(ENUM)) {
            this.skip(ENUM, true);
            this.nextToken();
            this.skipBody();
            return;
        }
        if (this.currentTokenEquals(this.file.getName()) && this.lookAheadToken.kind == '(') {
            this.skip(this.file.getName(), true);
            String params = this.parseFormalParamList();
            if (this.currentTokenEquals("throws")) {
                this.skipTo('{');
            }
            this.code.withStartBody(this.currentToken.startPos);
            this.parseBlock();
            String constructorSignature = "constructor:" + this.file.getName() + params;
            SymTabEntry nextEntity = this.startNextSymTab("constructor", this.file.getName() + params);
            nextEntity.withPosition(startPos, this.previousToken.startPos);
            nextEntity.withPreComment(preCommentStartPos, preCommentEndPos);
            nextEntity.withAnnotationsStart(annotationsStartPos);
            nextEntity.withBodyStartPos(this.code.getBodyStart());
            nextEntity.withModifiers(modifiers);
            this.checkSearchStringFound(constructorSignature, startPos);
        } else {
            String type = this.parseTypeRef();
            String memberName = this.currentWord();
            this.verbose("parsing member: " + memberName);
            this.nextToken();
            if (this.currentKindEquals('=')) {
                this.skip("=", true);
                this.parseExpression();
                this.code.withEndOfAttributeInitialization(this.previousToken.startPos);
                this.skip(";", true);
                SymTabEntry nextEntity = this.startNextSymTab("attribute", memberName);
                nextEntity.withPosition(startPos, this.previousToken.startPos);
                nextEntity.withModifiers(modifiers);
                nextEntity.withDataType(type);
                nextEntity.withPreComment(preCommentStartPos, preCommentEndPos);
                nextEntity.withAnnotationsStart(annotationsStartPos);
                this.checkSearchStringFound("attribute:" + memberName, startPos);
            } else if (this.currentKindEquals(';') && !",".equals(memberName)) {
                this.checkSearchStringFound("nameToken:" + this.searchString, startPos);
                this.skip(";", true);
                SymTabEntry nextEntity = this.startNextSymTab("attribute", memberName);
                nextEntity.withPosition(startPos, this.previousToken.startPos);
                nextEntity.withModifiers(modifiers);
                nextEntity.withPreComment(preCommentStartPos, preCommentEndPos);
                nextEntity.withAnnotationsStart(annotationsStartPos);
                nextEntity.withDataType(type);
                this.checkSearchStringFound("attribute:" + memberName, startPos);
            } else if (this.currentKindEquals('(')) {
                String params = this.parseFormalParamList();
                if (type.startsWith("@")) {
                    return;
                }
                String throwsTags = null;
                if (this.currentTokenEquals("throws")) {
                    int temp = this.currentToken.startPos;
                    this.skipTo('{');
                    throwsTags = this.code.subString(temp, this.currentToken.startPos).toString();
                }
                this.code.withStartBody(this.currentToken.startPos);
                if (this.currentKindEquals('{')) {
                    this.parseBlock();
                } else if (this.currentKindEquals(';')) {
                    this.skip(';', true);
                }
                String methodSignature = "method:" + memberName + params;
                SymTabEntry nextEntity = this.startNextSymTab("method", memberName);
                nextEntity.withThrowsTags(throwsTags);
                nextEntity.withDataType(type);
                nextEntity.withParams(params);
                nextEntity.withPosition(startPos, this.previousToken.startPos);
                nextEntity.withModifiers(modifiers).withBodyStartPos(this.code.getBodyStart());
                nextEntity.withAnnotations(annotations);
                nextEntity.withPreComment(preCommentStartPos, preCommentEndPos);
                nextEntity.withAnnotationsStart(annotationsStartPos);
                this.checkSearchStringFound(methodSignature, startPos);
            } else if (ENUM.equals(this.file.getName())) {
                if (",".equalsIgnoreCase(memberName) || ";".equalsIgnoreCase(memberName) || !";".equals(type) && this.currentKindEquals('\u0000')) {
                    SymTabEntry nextEntity = this.startNextSymTab(ENUMVALUE, type);
                    nextEntity.withPosition(startPos, this.previousToken.startPos);
                    nextEntity.withModifiers(modifiers).withBodyStartPos(this.code.getBodyStart());
                    nextEntity.withPreComment(preCommentStartPos, preCommentEndPos);
                    nextEntity.withAnnotationsStart(annotationsStartPos);
                } else {
                    SymTabEntry nextEntity = this.startNextSymTab(ENUMVALUE, type);
                    nextEntity.withPosition(startPos, this.previousToken.startPos);
                    nextEntity.withModifiers(modifiers).withBodyStartPos(this.code.getBodyStart());
                    nextEntity.withPreComment(preCommentStartPos, preCommentEndPos);
                    nextEntity.withAnnotationsStart(annotationsStartPos);
                    this.skipTo(';');
                    this.skip(";", true);
                }
            }
        }
    }

    private void parseBlock() {
        this.skip("{", true);
        while (!this.currentKindEquals('\u0000') && !this.currentKindEquals('}')) {
            if (this.currentKindEquals('{')) {
                this.parseBlock();
                continue;
            }
            this.nextToken();
        }
        this.skip("}", true);
    }

    private String parseFormalParamList() {
        StringBuilder paramList = new StringBuilder().append('(');
        this.skip("(", true);
        while (!this.currentKindEquals('\u0000') && !this.currentKindEquals(')')) {
            int typeStartPos = this.currentToken.startPos;
            this.parseTypeRef();
            int typeEndPos = this.currentToken.startPos - 1;
            paramList.append(this.code.subString(typeStartPos, typeEndPos));
            if (this.currentKindEquals(')')) break;
            this.nextToken();
            if (!this.currentKindEquals(',')) continue;
            this.skip(",", true);
            paramList.append(',');
        }
        this.skip(")", true);
        paramList.append(')');
        return paramList.toString();
    }

    private void skipBody() {
        int index = 1;
        while (index > 0 && !this.currentKindEquals('\u0000')) {
            this.nextToken();
            if (this.currentTokenEquals("{")) {
                ++index;
                continue;
            }
            if (!this.currentTokenEquals("}")) continue;
            --index;
        }
        this.nextToken();
    }

    private void skipTo(char c) {
        while (!this.currentKindEquals(c) && !this.currentKindEquals('\u0000')) {
            this.nextToken();
        }
    }

    private CharSequence parseQualifiedName(SymTabEntry nextEntity) {
        this.nextToken();
        while (this.currentKindEquals('.') && !this.lookAheadKindEquals('.') && !this.currentKindEquals('\u0000')) {
            this.skip(".", false);
            this.nextToken();
        }
        return this.finishParse(nextEntity);
    }

    private CharSequence parseQualifiedName() {
        int startPos = this.currentToken.startPos;
        int endPos = this.currentToken.endPos;
        this.checkSearchStringFound("nameToken:" + this.currentWord(), this.currentToken.startPos);
        this.nextToken();
        while (this.currentKindEquals('.') && this.lookAheadToken.kind != '.' && !this.currentKindEquals('\u0000')) {
            this.skip(".", false);
            endPos = this.currentToken.endPos;
            this.checkSearchStringFound("nameToken:" + this.currentWord(), this.currentToken.startPos);
            this.nextToken();
        }
        return this.code.subString(startPos, endPos + 1);
    }

    private void checkSearchStringFound(String foundElem, int startPos) {
        if (EntityUtil.stringEquals(this.searchString, foundElem)) {
            this.indexOfResult = startPos;
            throw new RuntimeException("FOUND");
        }
    }

    private void verbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private void parseExpression() {
        while (!this.currentKindEquals('\u0000') && !this.currentKindEquals(';')) {
            if (this.currentKindEquals('{')) {
                this.parseBlock();
                continue;
            }
            this.nextToken();
        }
    }

    private String parseClassType() {
        String classType = "";
        if (CLASS.equals(this.currentWord())) {
            classType = CLASS;
        } else if (INTERFACE.equals(this.currentWord())) {
            classType = INTERFACE;
        } else if (ENUM.equals(this.currentWord())) {
            classType = ENUM;
        }
        if (!classType.isEmpty()) {
            this.skip(classType, true);
        }
        return classType;
    }

    public void addMemberToModel() {
        if (this.code == null) {
            return;
        }
        SimpleKeyValueList<String, SimpleList<SymTabEntry>> symbolTab = this.code.getSymbolTab();
        Set<String> keySet = symbolTab.keySet();
        for (String key : keySet) {
            SimpleList<SymTabEntry> entities = symbolTab.get(key);
            if (key.startsWith("method")) {
                for (SymTabEntry entry : entities) {
                    this.addMemberAsMethod(entry, symbolTab);
                }
                continue;
            }
            if (key.startsWith("attribute")) {
                for (SymTabEntry entry : entities) {
                    this.addMemberAsMethod(entry, symbolTab);
                    this.addMemberAsAttribut(entry, symbolTab);
                }
                continue;
            }
            if (key.startsWith(EXTENDS)) {
                if (!GraphUtil.isInterface(this.file)) continue;
                for (SymTabEntry entry : entities) {
                    this.addMemberAsInterface(entry, symbolTab);
                }
                continue;
            }
            if (!key.startsWith(IMPLEMENTS)) continue;
            for (SymTabEntry entry : entities) {
                this.addMemberAsInterface(entry, symbolTab);
            }
        }
    }

    private void addMemberAsInterface(SymTabEntry memberName, SimpleKeyValueList<String, SimpleList<SymTabEntry>> symbolTab) {
        boolean found;
        Clazz memberClass = this.findMemberClass(this.file, memberName, symbolTab);
        if (memberClass == null) {
            return;
        }
        boolean bl = found = SDMLIBFILES.indexOf(memberClass.getName(false)) > 0;
        if (found) {
            GraphUtil.removeYou(memberClass);
            return;
        }
        if (memberClass != null) {
            this.file.withSuperClazz(memberClass);
        }
    }

    private Clazz findClassInModel(String name) {
        GraphModel model = this.file.getClassModel();
        if (model == null) {
            return null;
        }
        ClazzSet classes = model.getClazzes(new Condition[0]);
        for (Clazz eClazz : classes) {
            if (!eClazz.getName(false).equals(name)) continue;
            return eClazz;
        }
        return null;
    }

    private Clazz findMemberClass(Clazz clazz, SymTabEntry memberName, SimpleKeyValueList<String, SimpleList<SymTabEntry>> symbolTab) {
        String signature = memberName.getValue();
        for (String key : symbolTab.keySet()) {
            Clazz modelClass;
            String importName = ((SymTabEntry)symbolTab.get(key).first()).getValue();
            if (key.startsWith("import:") && importName.endsWith(signature)) {
                modelClass = this.findClassInModel(importName);
                if (modelClass != null) {
                    return modelClass;
                }
                GraphModel model = this.file.getClassModel();
                if (model == null) {
                    return null;
                }
                Clazz externClass = model.createClazz(importName).withExternal(true);
                return externClass;
            }
            if (!key.startsWith("import:") || !importName.endsWith("*") || (modelClass = this.findClassInModel(importName = importName.substring(0, importName.length() - 1) + signature)) == null) continue;
            return modelClass;
        }
        String name = clazz.getName(false);
        int lastIndex = name.lastIndexOf(46);
        name = name.substring(0, lastIndex + 1) + signature;
        return this.findClassInModel(name);
    }

    private void addMemberAsAttribut(SymTabEntry symTabEntry, SimpleKeyValueList<String, SimpleList<SymTabEntry>> symbolTab) {
        String modifiers = symTabEntry.getModifiers();
        if ((modifiers.indexOf("public") >= 0 || modifiers.indexOf("private") >= 0) && modifiers.indexOf("static") >= 0 && modifiers.indexOf("final") >= 0) {
            return;
        }
        String type = symTabEntry.getDataType();
        type = type.replace("[]", "");
        String attrName = symTabEntry.getValue();
        if (EntityUtil.isPrimitiveType(type)) {
            if (!this.classContainsAttribut(attrName, symTabEntry.getType())) {
                this.file.withAttribute(attrName, DataType.create(symTabEntry.getDataType()));
            }
        } else {
            this.handleComplexAttr(attrName, symTabEntry, symbolTab);
        }
    }

    private boolean classContainsAttribut(String attrName, String type) {
        for (Attribute attr : this.file.getAttributes(new Condition[0])) {
            if (!attrName.equals(attr.getName()) || !type.equals(attr.getType())) continue;
            return true;
        }
        return false;
    }

    private void handleComplexAttr(String attrName, SymTabEntry symTabEntry, SimpleKeyValueList<String, SimpleList<SymTabEntry>> symbolTab) {
        GraphModel model = this.file.getClassModel();
        if (model == null) {
            return;
        }
        String memberName = symTabEntry.getValue();
        String partnerTypeName = symTabEntry.getType();
        String partnerClassName = this.findPartnerClassName(partnerTypeName);
        Clazz partnerClass = null;
        for (Clazz clazz : model.getClazzes(new Condition[0])) {
            if (!partnerTypeName.equals(clazz.getName())) continue;
            partnerClass = clazz;
            break;
        }
        if (partnerClass == null) {
            return;
        }
        Cardinality card = this.findRoleCard(partnerTypeName, model);
        String setterPrefix = "set";
        if (Cardinality.MANY.equals((Object)card)) {
            setterPrefix = "addTo";
        }
        String name = EntityUtil.upFirstChar(memberName);
        SymTabEntry addToSymTabEntry = (SymTabEntry)symbolTab.get("method:" + setterPrefix + name + "(" + partnerClassName + ")").first();
        if (addToSymTabEntry == null && "addTo".equals(setterPrefix)) {
            addToSymTabEntry = (SymTabEntry)symbolTab.get("method:with" + name + "(" + partnerClassName + "...)").first();
        }
        if (addToSymTabEntry == null) {
            this.file.withAttribute(memberName, DataType.create(partnerTypeName));
            return;
        }
        SimpleList<SymTabEntry> methodBodyQualifiedNames = symbolTab.get("method");
        boolean done = false;
        for (SymTabEntry qualifiedEntry : methodBodyQualifiedNames) {
            String qualifiedName = qualifiedEntry.getValue();
            if (qualifiedName.startsWith("value.set")) {
                done = true;
                continue;
            }
            if (qualifiedName.startsWith("value.with") || qualifiedName.startsWith("item.with")) {
                done = true;
                continue;
            }
            if (!qualifiedName.startsWith("value.addTo")) continue;
            done = true;
        }
        if (!done) {
            this.file.withAttribute(memberName, DataType.create(partnerTypeName));
        }
    }

    public String findPartnerClassName(String partnerTypeName) {
        int openAngleBracket = partnerTypeName.indexOf("<");
        int closeAngleBracket = partnerTypeName.indexOf(">");
        String partnerClassName = openAngleBracket > -1 && closeAngleBracket > openAngleBracket ? partnerTypeName.substring(openAngleBracket + 1, closeAngleBracket) : (partnerTypeName.endsWith("Set") ? partnerTypeName.substring(0, partnerTypeName.length() - 3) : partnerTypeName);
        return partnerClassName;
    }

    private Cardinality findRoleCard(String partnerTypeName, GraphModel model) {
        Cardinality partnerCard = Cardinality.ONE;
        int _openAngleBracket = partnerTypeName.indexOf("<");
        int _closeAngleBracket = partnerTypeName.indexOf(">");
        if (_openAngleBracket > 1 && _closeAngleBracket > _openAngleBracket) {
            partnerCard = Cardinality.MANY;
        } else if (partnerTypeName.endsWith("Set") && partnerTypeName.length() > 3) {
            String prefix = partnerTypeName.substring(0, partnerTypeName.length() - 3);
            for (Clazz clazz : model.getClazzes(new Condition[0])) {
                if (!prefix.equals(EntityUtil.shortClassName(clazz.getName()))) continue;
                partnerCard = Cardinality.MANY;
                break;
            }
        }
        return partnerCard;
    }

    private void addMemberAsMethod(SymTabEntry symTabEntry, SimpleKeyValueList<String, SimpleList<SymTabEntry>> symTab) {
        String fullSignature = symTabEntry.getType();
        String signature = symTabEntry.getValue();
        if (!"method".equals(fullSignature)) {
            return;
        }
        String sign = signature + symTabEntry.getParams();
        if (SKIPMETGODS.indexOf(sign) < 0 && !this.isGetterSetter(signature, symTab) && this.isNewMethod(signature)) {
            String paramsStr = symTabEntry.getParams();
            String[] params = paramsStr.substring(1, paramsStr.length() - 1).split(",");
            Method method = new Method(signature).with(DataType.create(symTabEntry.getDataType()));
            for (String param : params) {
                if (param == null || param.length() <= 0) continue;
                method.with(new Parameter(DataType.create(param)));
            }
            method = this.getMethod(method);
            method.withParent(this.file);
            if (!symTabEntry.getAnnotations().isEmpty()) {
                method.with(new Annotation(symTabEntry.getAnnotations()));
            }
            method.with(new Throws(symTabEntry.getThrowsTags()));
            method.withBody(this.code.subString(symTabEntry.getBodyStartPos(), symTabEntry.getEndPos() + 1).toString());
        }
    }

    private Method getMethod(Method search) {
        MethodSet methods = this.file.getMethods(new Condition[0]);
        for (Method method : methods) {
            if (method.toString().equals(search.toString())) {
                return method;
            }
            if (!search.getName().equals(method.getName()) || !search.getReturnType().equals(method.getReturnType())) continue;
            ParameterSet searchParam = search.getParameter(new Condition[0]);
            ParameterSet param = method.getParameter(new Condition[0]);
            if (searchParam.size() != param.size()) continue;
            boolean found = true;
            for (int i = 0; i < param.size(); ++i) {
                if (((Parameter)param.get(i)).getType().equals(((Parameter)searchParam.get(i)).getType())) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return search;
    }

    private boolean isGetterSetter(String methodName, SimpleKeyValueList<String, SimpleList<SymTabEntry>> symTab) {
        if (methodName.startsWith("with") || methodName.startsWith("set") || methodName.startsWith("get") || methodName.startsWith("add") || methodName.startsWith("remove") || methodName.startsWith("create")) {
            SimpleList<SymTabEntry> attributes = new SimpleList<SymTabEntry>();
            for (String key : symTab.keySet()) {
                if (!key.startsWith("attribute")) continue;
                SimpleList<SymTabEntry> simpleList = symTab.get(key);
                attributes.addAll((Collection<SymTabEntry>)simpleList);
            }
            for (SymTabEntry entry : attributes) {
                String attrName = entry.getValue();
                if (!methodName.toLowerCase().endsWith(attrName.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isNewMethod(String memberName) {
        for (Method method : this.file.getMethods(new Condition[0])) {
            if (!method.getName(false).equals(memberName)) continue;
            return false;
        }
        return true;
    }

    public SourceCode getCode() {
        return this.code;
    }

    public SymTabEntry getSymbolEntry(String type, String name) {
        if (this.code != null) {
            return this.code.getSymbolEntry(type, name);
        }
        return null;
    }
}

