/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;
import de.uniks.networkparser.logic.Not;

public class IfCondition
implements ParserCondition,
SendableEntityCreator {
    public static final String TAG = "if";
    public static final String IFNOT = "ifnot";
    public static final String EXPRESSION = "expression";
    public static final String TRUECONDITION = "truecondition";
    public static final String FALSECONDITION = "falsecondition";
    private String tag = "if";
    private ObjectCondition expression;
    private ObjectCondition trueCondition;
    private ObjectCondition falseCondition;

    public IfCondition withExpression(ObjectCondition value) {
        this.expression = value;
        return this;
    }

    public ObjectCondition getExpression() {
        return this.expression;
    }

    public IfCondition withTrue(ObjectCondition condition) {
        this.trueCondition = condition;
        return this;
    }

    public ObjectCondition getTrue() {
        return this.trueCondition;
    }

    public IfCondition withFalse(ObjectCondition condition) {
        this.falseCondition = condition;
        return this;
    }

    public ObjectCondition getFalse() {
        return this.falseCondition;
    }

    @Override
    public boolean update(Object evt) {
        if (this.expression != null && this.expression.update(evt)) {
            if (this.trueCondition != null) {
                return this.trueCondition.update(evt);
            }
            return true;
        }
        if (this.falseCondition != null) {
            this.falseCondition.update(evt);
        }
        return false;
    }

    @Override
    public String[] getProperties() {
        return new String[]{EXPRESSION, TRUECONDITION, FALSECONDITION};
    }

    @Override
    public ParserCondition getSendableInstance(boolean prototyp) {
        return new IfCondition().withKey(this.tag);
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (EXPRESSION.equalsIgnoreCase(attribute)) {
            return ((IfCondition)entity).getExpression();
        }
        if (TRUECONDITION.equalsIgnoreCase(attribute)) {
            return ((IfCondition)entity).getTrue();
        }
        if (FALSECONDITION.equalsIgnoreCase(attribute)) {
            return ((IfCondition)entity).getFalse();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (EXPRESSION.equalsIgnoreCase(attribute)) {
            ((IfCondition)entity).withExpression((ObjectCondition)value);
            return true;
        }
        if (TRUECONDITION.equalsIgnoreCase(attribute)) {
            ((IfCondition)entity).withTrue((ObjectCondition)value);
            return true;
        }
        if (FALSECONDITION.equalsIgnoreCase(attribute)) {
            ((IfCondition)entity).withFalse((ObjectCondition)value);
            return true;
        }
        return false;
    }

    @Override
    public Object getValue(LocalisationInterface variables) {
        return null;
    }

    @Override
    public String getKey() {
        return this.tag;
    }

    public IfCondition withKey(String key) {
        this.tag = key;
        return this;
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
        buffer.skip();
        ObjectCondition expression = parser.parsing(buffer, customTemplate, true, true, new String[0]);
        if (this.tag.equalsIgnoreCase(IFNOT)) {
            this.withExpression(Not.create(expression));
        } else {
            this.withExpression(expression);
        }
        buffer.skipChar('}');
        buffer.skipChar('}');
        this.withTrue(parser.parsing(buffer, customTemplate, false, true, "else", "endif"));
        CharacterBuffer tokenPart = buffer.nextToken(false, '}');
        if ("else".equalsIgnoreCase(tokenPart.toString())) {
            buffer.skipChar('}');
            buffer.skipChar('}');
            this.withFalse(parser.parsing(buffer, customTemplate, false, true, "endif"));
            buffer.skipTo('}', false);
        }
        buffer.skipChar('}');
        buffer.skipChar('}');
    }

    @Override
    public boolean isExpression() {
        return false;
    }

    public String toString() {
        return "{{IF " + this.expression + "}}" + this.trueCondition + "{{#else}}" + this.falseCondition + "{{#ENDIF}}";
    }
}

