/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.StringEntity;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.bytes.SHA1;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.PropertyList;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleList;
import java.io.OutputStream;
import java.net.Socket;

public class Message
implements SendableEntityCreator,
SendableEntityCreatorNoIndex {
    public static final String PROPERTY_HISTORYID = "id";
    public static final String PROPERTY_PREVIOUSCHANGE = "prevChange";
    public static final String PROPERTY_MSG = "msg";
    public static final String PROPERTY_RECEIVER = "receiver";
    public static final String PROPERTY_RECEIVED = "received";
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_TYPE = "type";
    public static final int TIMEOUTDEFAULT = 0;
    protected static final PropertyList props = PropertyList.create("type", "id", "msg", "prevChange", "receiver", "received");
    protected String historyId;
    protected Object received;
    protected String prevChange;
    protected BaseItem msg;
    protected NodeProxy receiver;
    protected int timeOut;
    protected boolean sendAnyHow = false;
    protected String type;
    protected Object session;

    public String getMessageId(Space space, NodeProxy proxy) {
        if (this.historyId == null) {
            this.historyId = SHA1.value(this.getBlob()).toString();
        }
        return this.historyId;
    }

    public Message withType(String value) {
        this.type = value;
        return this;
    }

    public String getType() {
        if (this.type != null) {
            return this.type;
        }
        return this.getClass().getName();
    }

    public Message withHistoryId(String id) {
        this.historyId = id;
        return this;
    }

    public SimpleList<NodeProxy> getReceived() {
        if (this.received instanceof SimpleList) {
            return (SimpleList)this.received;
        }
        SimpleList<NodeProxy> result = new SimpleList<NodeProxy>();
        if (this.received != null) {
            result.add((NodeProxy)new Object[]{this.received});
        }
        return result;
    }

    public Message withAddToReceived(NodeProxy value) {
        SimpleList list;
        if (this.received == null) {
            this.received = value;
        }
        if (this.received instanceof NodeProxy) {
            list = new SimpleList();
            list.with(this.received);
            this.received = list;
        } else {
            list = (SimpleList)this.received;
        }
        list.add(new Object[]{value});
        return this;
    }

    public CharacterBuffer getBlob() {
        CharacterBuffer list = new CharacterBuffer();
        list.withObjects(this.getPrevChange(), this.getMessage(), this.getReceiver());
        return list;
    }

    public boolean handle(Space space) {
        return false;
    }

    public Message withReceiver(NodeProxy value) {
        this.receiver = value;
        return this;
    }

    public Message withMessage(BaseItem value) {
        this.msg = value;
        return this;
    }

    public String getPrevChange() {
        return this.prevChange;
    }

    public Message withPrevChange(String prevChange) {
        this.prevChange = prevChange;
        return this;
    }

    public NodeProxy getReceiver() {
        return this.receiver;
    }

    public BaseItem getMessage() {
        return this.msg;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public Message withTimeOut(int timeOut) {
        this.timeOut = timeOut;
        return this;
    }

    public boolean isSendAnyHow() {
        return this.sendAnyHow;
    }

    public Message withSendAnyHow(boolean sendAnyHow) {
        this.sendAnyHow = sendAnyHow;
        return this;
    }

    protected IdMap getInternMap(Space space) {
        return space.getMap();
    }

    public static Message createSimpleString(String text) {
        StringEntity stringEntity = new StringEntity();
        stringEntity.add(text);
        Message message = new Message().withSendAnyHow(true).withMessage(stringEntity);
        return message;
    }

    public String toString() {
        BaseItem message = this.getMessage();
        if (message != null) {
            return message.toString();
        }
        return super.toString();
    }

    public boolean write(String answer) {
        OutputStream stream = this.getOutputStream();
        if (stream == null) {
            return false;
        }
        try {
            stream.write(answer.getBytes());
            stream.flush();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public OutputStream getOutputStream() {
        if (this.session instanceof Socket) {
            try {
                return ((Socket)this.session).getOutputStream();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Message withSession(Object session) {
        this.session = session;
        return this;
    }

    @Override
    public String[] getProperties() {
        return props.getList();
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new Message();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (attribute == null || !(entity instanceof Message)) {
            return null;
        }
        Message msg = (Message)entity;
        if (PROPERTY_HISTORYID.equalsIgnoreCase(attribute)) {
            return msg.historyId;
        }
        if (PROPERTY_PREVIOUSCHANGE.equalsIgnoreCase(attribute)) {
            return msg.getPrevChange();
        }
        if (PROPERTY_MSG.equalsIgnoreCase(attribute)) {
            return msg.getMessage();
        }
        if (PROPERTY_RECEIVER.equalsIgnoreCase(attribute)) {
            return msg.getReceiver();
        }
        if (PROPERTY_RECEIVED.equalsIgnoreCase(attribute)) {
            return msg.getReceived();
        }
        if (PROPERTY_TYPE.equalsIgnoreCase(attribute)) {
            return msg.getType();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (attribute == null || !(entity instanceof Message)) {
            return false;
        }
        Message msg = (Message)entity;
        if (PROPERTY_HISTORYID.equalsIgnoreCase(attribute)) {
            msg.withHistoryId((String)value);
        }
        if (PROPERTY_PREVIOUSCHANGE.equalsIgnoreCase(attribute)) {
            msg.withPrevChange((String)value);
            return true;
        }
        if (PROPERTY_MSG.equalsIgnoreCase(attribute)) {
            msg.withMessage((JsonObject)value);
            return true;
        }
        if (PROPERTY_RECEIVER.equalsIgnoreCase(attribute)) {
            msg.withReceiver((NodeProxy)value);
            return true;
        }
        if (PROPERTY_RECEIVED.equalsIgnoreCase(attribute)) {
            msg.withAddToReceived((NodeProxy)value);
            return true;
        }
        if (PROPERTY_TYPE.equalsIgnoreCase(attribute)) {
            msg.withType((String)value);
            return true;
        }
        return false;
    }
}

