/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.DiagramController;
import de.uniks.networkparser.ext.javafx.DiagrammCallBack;
import de.uniks.networkparser.interfaces.ObjectCondition;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class DiagramEvents
implements ObjectCondition {
    public static final String DRAGOVER = "Drag_Over";
    public static final String DRAGDROPPED = "Drag_Dropped";
    public static final String ERROR = "Error";
    public static final String DRAGEXITED = "Drag_Exited";
    public static final String STATE = "javafx.concurrent.Worker$State";
    private Object webEngine;
    private DiagramController controller;

    public DiagramEvents(Object webEngine, DiagramController controller) {
        this.webEngine = webEngine;
        this.controller = controller;
    }

    @Override
    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (STATE.equalsIgnoreCase(value.getClass().getName())) {
            if (value.toString() == "SUCCEEDED") {
                Object win = ReflectionLoader.call("executeScript", this.webEngine, "window");
                ReflectionLoader.call("setMember", win, String.class, "java", Object.class, new DiagrammCallBack(this.controller));
            }
            return true;
        }
        String name = (String)ReflectionLoader.callChain(value, "getEventType", "getName");
        if (DRAGOVER.equalsIgnoreCase(name)) {
            return this.onDragOver(value);
        }
        if (DRAGDROPPED.equalsIgnoreCase(name)) {
            return this.onDragDropped(value);
        }
        if (ERROR.equalsIgnoreCase(name)) {
            return this.onError(value);
        }
        if (DRAGEXITED.equalsIgnoreCase(name)) {
            return this.onDragExited(value);
        }
        return false;
    }

    private boolean onError(Object event) {
        System.err.println(ReflectionLoader.call("getMessage", event, new Object[0]));
        return true;
    }

    private List<File> getFiles(Object event) {
        Object db = ReflectionLoader.call("getDragboard", event, new Object[0]);
        if (((Boolean)ReflectionLoader.call("hasFiles", db, new Object[0])).booleanValue()) {
            List files = (List)ReflectionLoader.call("getFiles", db, new Object[0]);
            return files;
        }
        return null;
    }

    private boolean onDragOver(Object event) {
        List<File> files = this.getFiles(event);
        if (files != null) {
            Object mode;
            boolean error = true;
            for (File file : files) {
                String name = file.getName().toLowerCase();
                if (name.indexOf("json", name.length() - 4) < 0) continue;
                error = false;
            }
            if (!error) {
                mode = ReflectionLoader.getField("COPY", ReflectionLoader.TRANSFERMODE);
                ReflectionLoader.call("acceptTransferModes", event, ReflectionLoader.TRANSFERMODE, mode);
                ReflectionLoader.call("executeScript", this.webEngine, String.class, "classEditor.setBoardStyle(\"Ok\");");
            } else {
                mode = ReflectionLoader.getField("NONE", ReflectionLoader.TRANSFERMODE);
                ReflectionLoader.call("acceptTransferModes", event, ReflectionLoader.TRANSFERMODE, mode);
                ReflectionLoader.call("executeScript", this.webEngine, String.class, "classEditor.setBoardStyle(\"Error\");");
            }
        }
        ReflectionLoader.call("consume", event, new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean onDragDropped(Object event) {
        block14: {
            Iterator<File> iterator;
            List<File> files = this.getFiles(event);
            if (files == null || !(iterator = files.iterator()).hasNext()) break block14;
            File file = iterator.next();
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[1024];
            FileInputStream is = null;
            try {
                int read;
                is = new FileInputStream(file);
                do {
                    if ((read = is.read(buf, 0, buf.length)) <= 0) continue;
                    sb.append(new String(buf, 0, read, "UTF-8"));
                } while (read >= 0);
            }
            catch (IOException iOException) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ReflectionLoader.call("executeScript", this.webEngine, String.class, "classEditor.dropFile('" + sb.toString() + "', \"" + file.getAbsolutePath() + "\");");
        }
        return true;
    }

    private boolean onDragExited(Object event) {
        ReflectionLoader.call("executeScript", this.webEngine, "classEditor.setBoardStyle(\"dragleave\");");
        return true;
    }
}

