/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.ext.ErrorHandler;
import de.uniks.networkparser.ext.io.StringOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class StringPrintStream
extends PrintStream {
    private ErrorHandler handler;
    private boolean error;

    public StringPrintStream() {
        super(new StringOutputStream());
    }

    public StringPrintStream(ErrorHandler handler, boolean error) {
        super(new StringOutputStream());
        this.handler = handler;
        this.error = error;
    }

    public StringPrintStream(OutputStream out) {
        super(out);
    }

    public StringPrintStream withListener(ErrorHandler value) {
        this.handler = value;
        return this;
    }

    @Override
    public void print(Object value) {
        if (this.handler != null && value != null) {
            this.handler.writeOutput(value.toString(), this.error);
        }
    }

    @Override
    public void print(String value) {
        if (this.handler != null) {
            this.handler.writeOutput(value, this.error);
        }
    }

    @Override
    public void println() {
        if (this.handler != null) {
            this.handler.writeOutput("\r\n", this.error);
        }
    }

    @Override
    public void println(String value) {
        if (this.handler != null) {
            this.handler.writeOutput(value, this.error);
            this.handler.writeOutput("\r\n", this.error);
        }
    }

    @Override
    public void println(Object value) {
        if (this.handler != null && value != null) {
            this.handler.writeOutput(value.toString(), this.error);
            this.handler.writeOutput("\r\n", this.error);
        }
    }
}

