/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.buffer.Buffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter64;
import de.uniks.networkparser.ext.io.EMailMessage;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SMTPSession {
    public static final String RESPONSE_SERVERREADY = "220";
    public static final String RESPONSE_MAILACTIONOKEY = "250";
    public static final String RESPONSE_STARTMAILINPUT = "354";
    public static final String RESPONSE_SMTP_AUTH_NTLM_BLOB_Response = "334";
    public static final String RESPONSE_LOGIN_SUCCESS = "235";
    public static final String RESPONSE_SERVICE_CLOSING_TRANSMISSION = "221";
    public static final int SSLPORT = 587;
    public static final int SOCKET_READ_TIMEOUT = 15000;
    private static final byte[] CRLF = new byte[]{13, 10};
    private String host;
    private int port;
    private String sender;
    protected Socket serverSocket;
    protected BufferedReader in;
    protected OutputStream out;
    protected SimpleList<String> supportedFeature = new SimpleList();
    private boolean allowutf8;
    private CharacterBuffer lastAnswer;
    private String lastSended;

    public SMTPSession(String host, int port, String sender) {
        this.host = host;
        this.port = port;
        this.sender = sender;
    }

    public SMTPSession(String host, String sender) {
        this(host, 25, sender);
    }

    public SMTPSession() {
    }

    public SMTPSession connectSSL(String host, String sender, String password) {
        this.host = host;
        this.port = 587;
        this.sender = sender;
        this.connect(sender, password);
        return this;
    }

    public boolean close() {
        try {
            this.in.close();
            this.out.close();
            this.serverSocket.close();
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean connect(String userName, String password) {
        if (this.serverSocket == null) {
            if (this.host == null) {
                return false;
            }
            try {
                this.serverSocket = new Socket(this.host, this.port);
                this.serverSocket.setSoTimeout(15000);
                this.in = new BufferedReader(new InputStreamReader(this.serverSocket.getInputStream()));
                this.out = this.serverSocket.getOutputStream();
                this.checkServerResponse(this.getResponse(), RESPONSE_SERVERREADY);
                this.sendHelo();
                CharacterBuffer answer = this.sendCommand("STARTTLS");
                this.startTLS();
                this.sendHelo();
                answer = this.sendCommand("AUTH LOGIN");
                if (!this.checkServerResponse(answer, RESPONSE_SMTP_AUTH_NTLM_BLOB_Response)) {
                    this.close();
                    return false;
                }
                ByteConverter64 converter = new ByteConverter64();
                answer = this.sendCommand(converter.toStaticString(userName).toString());
                if (!this.checkServerResponse(answer, RESPONSE_SMTP_AUTH_NTLM_BLOB_Response)) {
                    this.close();
                    return false;
                }
                answer = this.sendCommand(converter.toStaticString(password).toString());
                if (!this.checkServerResponse(answer, RESPONSE_LOGIN_SUCCESS)) {
                    this.close();
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private boolean sendHelo() {
        String response = this.sendCommand("EHLO " + this.getLocalHost()).toString();
        this.supportedFeature.clear();
        String[] lines = response.split("\n");
        for (int i = 1; i < lines.length; ++i) {
            this.supportedFeature.add(lines[i]);
        }
        return this.checkServerResponse(response, RESPONSE_MAILACTIONOKEY);
    }

    public void startTLS() {
        SSLSocketFactory ssf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        try {
            this.serverSocket = ssf.createSocket(this.serverSocket, this.host, this.port, true);
            this.in = new BufferedReader(new InputStreamReader(this.serverSocket.getInputStream()));
            this.out = this.serverSocket.getOutputStream();
            if (this.serverSocket instanceof SSLSocket) {
                SSLSocket socket = (SSLSocket)this.serverSocket;
                String[] prots = socket.getEnabledProtocols();
                SimpleList<String> eprots = new SimpleList<String>();
                for (int i = 0; i < prots.length; ++i) {
                    if (prots[i] == null || prots[i].startsWith("SSL")) continue;
                    eprots.add(prots[i]);
                }
                socket.setEnabledProtocols(eprots.toArray(new String[eprots.size()]));
                socket.startHandshake();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean connect() {
        return this.connect(null, null);
    }

    protected CharacterBuffer sendCommand(String commandString) {
        this.lastSended = commandString;
        byte[] cmd = this.toBytes(commandString);
        this.sendValues(cmd);
        CharacterBuffer response = this.getResponse();
        return response;
    }

    protected void sendValues(String commandString) {
        this.lastSended = commandString;
        byte[] cmd = this.toBytes(commandString);
        this.sendValues(cmd);
    }

    protected void sendValues(byte ... cmd) {
        try {
            this.out.write(cmd);
            this.out.write(CRLF);
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        if (this.allowutf8) {
            return s.getBytes(StandardCharsets.UTF_8);
        }
        return s.getBytes();
    }

    protected boolean doCommand(String commandString, String responseCode) {
        CharacterBuffer response = this.sendCommand(commandString);
        return this.checkServerResponse(response, responseCode);
    }

    protected boolean checkServerResponse(CharSequence response, String code) {
        if (response == null || code == null) {
            return false;
        }
        if (response.length() < code.length()) {
            return false;
        }
        for (int i = 0; i < code.length(); ++i) {
            if (response.charAt(i) == code.charAt(i)) continue;
            return false;
        }
        return true;
    }

    protected CharacterBuffer getResponse() {
        CharacterBuffer response = new CharacterBuffer();
        String line = null;
        do {
            try {
                line = this.in.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (line == null) {
                response.with("[EOF]");
                return response;
            }
            response.with(line).with('\n');
        } while (line.length() > 3 && line.charAt(3) == '-');
        this.lastAnswer = response;
        return response;
    }

    public String getLocalHost() {
        InetAddress localHost;
        String localHostName = null;
        try {
            localHost = InetAddress.getLocalHost();
            localHostName = localHost.getCanonicalHostName();
            if (localHostName == null) {
                localHostName = "[" + localHost.getHostAddress() + "]";
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if ((localHostName == null || localHostName.length() <= 0) && this.serverSocket != null && this.serverSocket.isBound() && (localHostName = (localHost = this.serverSocket.getLocalAddress()).getCanonicalHostName()) == null) {
            localHostName = "[" + localHost.getHostAddress() + "]";
        }
        return localHostName;
    }

    public String getLocalAdress() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return "@" + localHost.getHostName();
        }
        catch (Exception exception) {
            return "mailer@localhost";
        }
    }

    public boolean sendMessage(EMailMessage message) {
        if (!this.connect()) {
            return false;
        }
        if (!this.doCommand(message.getHeaderFrom(this.sender), RESPONSE_MAILACTIONOKEY)) {
            return false;
        }
        SimpleList<String> headerTo = message.getHeaderTo();
        int pos = 0;
        for (int i = 0; i < headerTo.size(); ++i) {
            if (!this.doCommand((String)headerTo.get(i), RESPONSE_MAILACTIONOKEY)) {
                message.removeToAdress(pos);
                continue;
            }
            ++pos;
        }
        if (!this.doCommand("DATA", RESPONSE_STARTMAILINPUT)) {
            return false;
        }
        message.generateMessageId(this.getLocalAdress());
        this.sendValues(message.getHeader("Date: "));
        this.sendValues(message.getHeader("From: "));
        this.sendValues(message.getHeader("To"));
        this.sendValues(message.getHeader("Message-Id: "));
        this.sendValues(message.getHeader("Subject: "));
        this.sendValues(message.getHeader("MIME-Version: "));
        SimpleList<BaseItem> messages = message.getMessages();
        boolean multiPart = message.isMultiPart();
        String splitter = "--";
        if (multiPart) {
            this.sendValues(message.getHeader("Content-Type: ") + message.getHeader("boundary="));
        } else {
            this.sendValues(message.getHeader("Content-Type: "));
            this.sendValues("Content-Transfer-Encoding: 7bit");
        }
        this.sendValues(CRLF);
        for (BaseItem msg : messages) {
            CharacterBuffer buffer = new CharacterBuffer();
            if (msg != null) {
                buffer.with(msg.toString());
            }
            if (multiPart) {
                this.sendValues(splitter + message.generateBoundaryValue());
                this.sendValues("Content-Type: " + message.getContentType(msg));
                this.sendValues("Content-Transfer-Encoding: 7bit");
            }
            this.sendValues(CRLF);
            while (!buffer.isEnd()) {
                CharacterBuffer line = buffer.readLine();
                if (line.startsWith(".")) {
                    this.sendValues(46);
                }
                this.sendValues(line.toByteArray());
            }
        }
        SimpleKeyValueList<String, Buffer> attachments = message.getAttachments();
        for (int i = 0; i < attachments.size(); ++i) {
            String fileName = (String)attachments.get(i);
            Buffer buffer = attachments.getValueByIndex(i);
            this.sendValues(splitter + message.generateBoundaryValue());
            this.sendValues("Content-Type: text/plain; charset=utf-8; name=" + fileName);
            this.sendValues("Content-Transfer-Encoding: 7bit");
            this.sendValues("Content-Disposition: attachment; filename=" + fileName);
            this.sendValues(CRLF);
            while (!buffer.isEnd()) {
                CharacterBuffer line = buffer.getString(1024);
                this.sendValues(line.toByteArray());
            }
        }
        if (multiPart) {
            this.sendValues(splitter + message.generateBoundaryValue() + splitter);
        }
        this.doCommand(".", RESPONSE_MAILACTIONOKEY);
        return this.doCommand("QUIT", RESPONSE_SERVICE_CLOSING_TRANSMISSION);
    }

    public CharacterBuffer getLastAnswer() {
        return this.lastAnswer;
    }

    public String getLastSended() {
        return this.lastSended;
    }
}

