/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.ext.generic.ReflectionLoader;
import java.io.File;

public class Os {
    public static final String WINDOWS = "windows";
    public static final String MAC = "mac";
    public static final String UNIX = "unix";
    public static final String ANDROID = "android";
    public static final String UNKNOWN = "unknown";

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf(MAC) >= 0;
    }

    public static boolean isIOS() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("ios") >= 0;
    }

    public static boolean isAndroid() {
        String javafxPlatform = System.getProperty("javafx.platform").toLowerCase();
        String vmName = System.getProperty("java.vm.name").toLowerCase();
        return ANDROID.equals(javafxPlatform) || "dalvik".equals(vmName);
    }

    public static boolean isEclipse() {
        String fileName = new Os().getFilename().toLowerCase();
        return !fileName.endsWith(".jar");
    }

    public static boolean isUnix() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0;
    }

    public static boolean isSolaris() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("sunos") >= 0;
    }

    public static String getCurrentPlatform() {
        if (Os.isWindows()) {
            return WINDOWS;
        }
        if (Os.isMac()) {
            return MAC;
        }
        if (Os.isUnix()) {
            return UNIX;
        }
        if (Os.isAndroid()) {
            return ANDROID;
        }
        return UNKNOWN;
    }

    public String getFilename() {
        File jar = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath());
        return jar.getAbsoluteFile().getName();
    }

    public static boolean isUTF8() {
        return "UTF-8".equals(System.getProperty("file.encoding")) || "UTF8".equals(System.getProperty("file.encoding"));
    }

    public static boolean isNotFirstThread(String[] args) {
        for (String item : args) {
            if (!"-XstartOnFirstThread".equalsIgnoreCase(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkSystemTray() {
        Object value = ReflectionLoader.call("isSupported", ReflectionLoader.SYSTEMTRAY, new Object[0]);
        if (value != null) {
            return (Boolean)value;
        }
        return false;
    }
}

