/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.DateTimeEntity;
import de.uniks.networkparser.ext.petaf.SendableItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;

public class LogItem
extends SendableItem
implements SendableEntityCreator {
    public static final String INCOMING = "Empfange";
    public static final String OUTGOING = "Sende";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_TIMESTAMP = "timestamp";
    public static final String PROPERTY_CURRENTTIME = "currenttime";
    public static final String PROPERTY_THREADNAME = "threadName";
    public static final String PROPERTY_MESSAGE = "message";
    private final String[] properties = new String[]{"currenttime", "timestamp", "threadName", "type", "message"};
    private static final long STARTTIME = System.currentTimeMillis();
    private String type;
    private long timestamp;
    private long currentTime;
    private String message;
    private String threadName;

    public LogItem(String message, String type) {
        long currentTimeMillis = System.currentTimeMillis();
        this.timestamp = currentTimeMillis - STARTTIME;
        this.currentTime = currentTimeMillis;
        this.threadName = Thread.currentThread().getName();
        this.type = type;
        this.message = message;
    }

    public LogItem(String message) {
        this(message, "INFO");
    }

    public LogItem() {
        this("", "INFO");
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public boolean setThreadName(String value) {
        if (this.threadName != null ? value == null : this.threadName.equals(value)) {
            String oldValue = this.threadName;
            this.threadName = value;
            this.firePropertyChange(PROPERTY_THREADNAME, oldValue, value);
            return true;
        }
        return false;
    }

    public LogItem withThreadName(String value) {
        this.setThreadName(value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public boolean setType(String value) {
        if (this.type != null ? value == null : this.type.equals(value)) {
            String oldValue = this.type;
            this.type = value;
            this.firePropertyChange(PROPERTY_TYPE, oldValue, value);
            return true;
        }
        return false;
    }

    public LogItem withType(String value) {
        this.setType(value);
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean setMessage(String value) {
        if (this.message != null ? value == null : this.message.equals(value)) {
            String oldValue = this.message;
            this.message = value;
            this.firePropertyChange(PROPERTY_MESSAGE, oldValue, value);
            return true;
        }
        return false;
    }

    public LogItem withMessage(String value) {
        this.setMessage(value);
        return this;
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (attribute == null || !(entity instanceof LogItem)) {
            return null;
        }
        int pos = attribute.indexOf(46);
        String attrName = attribute;
        LogItem item = (LogItem)entity;
        if (pos > 0) {
            attribute = attrName.substring(0, pos);
        }
        if (PROPERTY_TIMESTAMP.equalsIgnoreCase(attribute)) {
            return item.getTimestamp();
        }
        if (PROPERTY_THREADNAME.equalsIgnoreCase(attribute)) {
            return item.getThreadName();
        }
        if (PROPERTY_TYPE.equalsIgnoreCase(attribute)) {
            return item.getType();
        }
        if (PROPERTY_MESSAGE.equalsIgnoreCase(attribute)) {
            return item.getMessage();
        }
        if (PROPERTY_CURRENTTIME.equalsIgnoreCase(attribute)) {
            return item.getCurrentDate();
        }
        return null;
    }

    public DateTimeEntity getCurrentDate() {
        return new DateTimeEntity().withNewDate(this.getCurrentTime());
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (attribute == null || !(entity instanceof LogItem)) {
            return false;
        }
        LogItem item = (LogItem)entity;
        if (PROPERTY_TIMESTAMP.equalsIgnoreCase(attribute)) {
            item.timestamp = Long.parseLong(value.toString());
            return true;
        }
        if (PROPERTY_THREADNAME.equalsIgnoreCase(attribute)) {
            item.withThreadName((String)value);
            return true;
        }
        if (PROPERTY_TYPE.equalsIgnoreCase(attribute)) {
            item.setType((String)value);
            return true;
        }
        if (PROPERTY_MESSAGE.equalsIgnoreCase(attribute)) {
            item.setMessage((String)value);
            return true;
        }
        return false;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return null;
    }
}

