/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphEntity;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.ModifyEntry;
import de.uniks.networkparser.graph.SourceCode;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleSet;
import de.uniks.networkparser.list.SortedSet;
import de.uniks.networkparser.parser.SymTabEntry;
import de.uniks.networkparser.parser.TemplateResultFragment;
import java.util.Collection;

public class TemplateResultFile
extends SortedSet<TemplateResultFragment>
implements SendableEntityCreator,
LocalisationInterface {
    public static final String PROPERTY_PARENT = "parent";
    public static final String PROPERTY_CHILD = "child";
    public static final String PROPERTY_MEMBER = "member";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_HEADERS = "headers";
    private String name;
    private String postfix;
    private String extension;
    private String path;
    private SendableEntityCreator parent;
    private GraphEntity member;
    private boolean metaModell;

    TemplateResultFile() {
        super(true);
    }

    public TemplateResultFile(Clazz clazz, boolean comparator) {
        super(comparator);
        this.withName(clazz);
        this.withMember(clazz);
    }

    public TemplateResultFile(Clazz clazz, String name, boolean comparator) {
        super(comparator);
        this.withName(name);
        this.withMember(clazz);
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        CharacterBuffer buffer = new CharacterBuffer();
        if (this.path != null) {
            buffer.with(this.path);
            buffer.with('/');
        }
        buffer.with(this.name);
        buffer.with(this.postfix);
        buffer.with('.');
        buffer.with(this.extension);
        return buffer.toString();
    }

    public TemplateResultFile withName(String name) {
        this.name = name;
        return this;
    }

    public TemplateResultFile withName(Clazz clazz) {
        this.name = clazz.getName().replace(".", "/");
        return this;
    }

    public TemplateResultFile withPostfix(String value) {
        this.postfix = value;
        return this;
    }

    public TemplateResultFile withExtension(String value) {
        this.extension = value;
        return this;
    }

    public TemplateResultFile withPath(String value) {
        this.path = value;
        return this;
    }

    public boolean addChild(SendableEntityCreator child) {
        TemplateResultFragment fragment;
        if (!this.isComparator() && child instanceof TemplateResultFragment && (fragment = (TemplateResultFragment)child).getKey() == 3) {
            super.add(0, fragment);
            return true;
        }
        if (!super.add(new Object[]{child})) {
            return false;
        }
        child.setValue(child, PROPERTY_PARENT, this, "new");
        return true;
    }

    @Override
    public String getText(CharSequence label, Object model, Object gui) {
        return null;
    }

    @Override
    public String put(String label, Object object) {
        return null;
    }

    public boolean setParent(SendableEntityCreator value) {
        if (value != this.parent) {
            this.parent = value;
            return true;
        }
        return false;
    }

    public SendableEntityCreator getParent() {
        return this.parent;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new TemplateResultFile();
    }

    @Override
    public String[] getProperties() {
        return new String[]{PROPERTY_NAME, PROPERTY_PARENT};
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (!(entity instanceof TemplateResultFile)) {
            return null;
        }
        TemplateResultFile element = (TemplateResultFile)entity;
        int pos = attribute.indexOf(46);
        String attrName = pos > 0 ? attribute.substring(0, pos) : attribute;
        if (PROPERTY_PARENT.equalsIgnoreCase(attrName)) {
            if (pos > 0) {
                return element.getParent().getValue(element, attribute.substring(pos + 1));
            }
            return element.getParent();
        }
        if (PROPERTY_MEMBER.equalsIgnoreCase(attrName)) {
            GraphEntity member = element.getMember();
            if (pos > 0) {
                return member.getValue(attribute.substring(pos + 1));
            }
            return member;
        }
        if (PROPERTY_HEADERS.equalsIgnoreCase(attrName)) {
            SimpleSet<String> headers = new SimpleSet<String>();
            for (TemplateResultFragment child : this) {
                headers.addAll((Collection<String>)child.getHeaders());
            }
            return headers;
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (PROPERTY_PARENT.equalsIgnoreCase(attribute)) {
            return this.setParent((SendableEntityCreator)value);
        }
        if (PROPERTY_CHILD.equalsIgnoreCase(attribute)) {
            return this.addChild((SendableEntityCreator)value);
        }
        return false;
    }

    public SourceCode getCode() {
        Clazz clazz;
        GraphMember code;
        if (this.member instanceof Clazz && (code = (clazz = (Clazz)this.member).getChildByName("SourceCode", SourceCode.class)) != null && code instanceof SourceCode) {
            return (SourceCode)code;
        }
        return null;
    }

    @Override
    public String toString() {
        SourceCode code = this.getCode();
        if (this.size() < 1 && code != null) {
            return code.toString();
        }
        if (code != null && this.isMetaModell()) {
            StringBuilder sb = new StringBuilder();
            sb.append(code.getContent().toString());
            TemplateResultFragment importDecl = null;
            GraphSimpleSet children = GraphUtil.getChildren(this.member);
            for (GraphMember member : children) {
                SymTabEntry symbolEntry;
                GraphMember entry;
                ModifyEntry modifierChild;
                if (!(member instanceof ModifyEntry) || !"delete".equalsIgnoreCase((modifierChild = (ModifyEntry)member).getType()) || (entry = modifierChild.getEntry()) == null || (symbolEntry = code.getSymbolEntry(entry.getClass().getSimpleName(), entry.getName())) == null) continue;
                sb.replace(symbolEntry.getStartPos(), symbolEntry.getEndPos(), "");
            }
            for (TemplateResultFragment fragment : this) {
                int pos;
                SymTabEntry symbolEntry;
                if (fragment.getKey() == 0) continue;
                if (fragment.getKey() == 2) {
                    fragment.update();
                    importDecl = fragment;
                    continue;
                }
                if (fragment.getName() != null) {
                    if (!"method".equalsIgnoreCase(fragment.getName()) || (symbolEntry = code.getSymbolEntry(fragment.getName(), fragment.getMember().getName())) != null) continue;
                    pos = code.getEndOfBody();
                    sb.replace(pos, pos, fragment.getValue().toString());
                    continue;
                }
                if (fragment.getKey() != 5 || (symbolEntry = code.getSymbolEntry("ATTRIBUTE", fragment.getMember().getName())) != null) continue;
                pos = code.getEndOfBody();
                sb.replace(pos, pos, fragment.getValue().toString());
            }
            if (importDecl != null) {
                int start = code.getStartOfImports();
                int n = code.getEndOfImports();
            }
            return sb.toString();
        }
        CharacterBuffer buffer = new CharacterBuffer();
        for (TemplateResultFragment fragment : this) {
            if (fragment.getKey() == 0) continue;
            if (fragment.getKey() == 2) {
                fragment.update();
            }
            buffer.with(fragment.getValue());
        }
        return buffer.toString();
    }

    public GraphEntity getMember() {
        return this.member;
    }

    public TemplateResultFile withMember(GraphEntity member) {
        this.member = member;
        return this;
    }

    public TemplateResultFile withMetaModel(boolean value) {
        this.metaModell = value;
        return this;
    }

    public boolean isMetaModell() {
        return this.metaModell;
    }

    public static TemplateResultFile createJava(Clazz clazz) {
        TemplateResultFile templateResult = new TemplateResultFile(clazz, true);
        templateResult.withExtension("java");
        templateResult.withPath((String)clazz.getClassModel().getValue("path"));
        return templateResult;
    }
}

