/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.interfaces.LocalisationInterface;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.ParserCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.TemplateParser;

public abstract class CustomCondition<T>
implements ParserCondition {
    protected static final String PROPERTY_MEMBER = "member";
    protected boolean isExpression;

    @Override
    public boolean isExpression() {
        return this.isExpression;
    }

    public <ST extends CustomCondition<T>> ST withExpression(boolean value) {
        this.isExpression = value;
        return (ST)this;
    }

    @Override
    public void create(CharacterBuffer buffer, TemplateParser parser, LocalisationInterface customTemplate) {
        this.skipEnd(buffer);
    }

    protected String addImport(Object value, Class<?> importName) {
        if (value instanceof SendableEntityCreator) {
            SendableEntityCreator creator = (SendableEntityCreator)value;
            creator.setValue(value, "headers", importName.getName(), "new");
            return importName.getSimpleName();
        }
        return null;
    }

    protected boolean addImport(Object value, String importName) {
        if (value instanceof SendableEntityCreator) {
            SendableEntityCreator creator = (SendableEntityCreator)value;
            return creator.setValue(value, "headers", importName, "new");
        }
        return false;
    }

    protected GraphMember getMember(Object value) {
        if (value instanceof SendableEntityCreator) {
            SendableEntityCreator creator = (SendableEntityCreator)value;
            GraphMember member = (GraphMember)creator.getValue(creator, PROPERTY_MEMBER);
            return member;
        }
        return null;
    }

    protected void skipEnd(CharacterBuffer buffer) {
        buffer.skipTo('}', true);
        buffer.skipChar('}');
        buffer.skipChar('}');
    }

    @Override
    public boolean update(Object value) {
        if (value instanceof ObjectCondition) {
            return ((ObjectCondition)value).update(this);
        }
        if (value instanceof LocalisationInterface) {
            return this.getValue((LocalisationInterface)value) != null;
        }
        return false;
    }

    @Override
    public Object getValue(LocalisationInterface variables) {
        if (variables instanceof SendableEntityCreator) {
            SendableEntityCreator creator = (SendableEntityCreator)((Object)variables);
            return this.getValue(creator, this.getMember(variables));
        }
        return null;
    }

    public abstract Object getValue(SendableEntityCreator var1, T var2);
}

