/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf.messages;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.UpdateAccumulate;
import de.uniks.networkparser.ext.petaf.NodeProxy;
import de.uniks.networkparser.ext.petaf.ReceivingTimerTask;
import de.uniks.networkparser.ext.petaf.Space;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyModel;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.list.SortedSet;

public class AcceptMessage
extends ReceivingTimerTask {
    public static final String PROPERTY_TYPE = "accept";
    public static final String PROPERTY_PROXIES = "proxies";
    public static final String PROPERTY_MODEL = "model";
    public static final String PROPERTY_MODELID = "model_id";
    public static final String PROPERTY_MODELCLASS = "model_class";
    private String id;

    public AcceptMessage() {
        props.add(PROPERTY_PROXIES, PROPERTY_MODELID, PROPERTY_MODELCLASS, PROPERTY_MODEL);
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (attribute == null || !(entity instanceof AcceptMessage)) {
            return null;
        }
        AcceptMessage message = (AcceptMessage)entity;
        Space space = message.getSpace();
        if (space != null) {
            if (PROPERTY_MODELID.equalsIgnoreCase(attribute)) {
                NodeProxyModel modelProxy = space.getModel();
                if (modelProxy != null) {
                    IdMap map = space.getMap();
                    return map.getId(modelProxy.getModell(), false);
                }
                return null;
            }
            if (PROPERTY_MODELCLASS.equalsIgnoreCase(attribute)) {
                Object model;
                NodeProxyModel modelProxy = space.getModel();
                if (modelProxy != null && (model = modelProxy.getModell()) != null) {
                    return model.getClass().getName();
                }
                return null;
            }
            if (PROPERTY_PROXIES.equalsIgnoreCase(attribute)) {
                SortedSet<NodeProxy> nodeProxies = space.getNodeProxies();
                SimpleList<NodeProxy> candidates = new SimpleList<NodeProxy>();
                for (NodeProxy proxy : nodeProxies) {
                    if (!proxy.isSendable()) continue;
                    candidates.add(proxy);
                }
                return candidates;
            }
            if (PROPERTY_MODEL.equalsIgnoreCase(attribute)) {
                NodeProxyModel modelProxy = space.getModel();
                return modelProxy.getModell();
            }
        }
        return super.getValue(entity, attribute);
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (attribute == null || !(entity instanceof AcceptMessage)) {
            return false;
        }
        AcceptMessage message = (AcceptMessage)entity;
        Space space = message.getSpace();
        if (space != null) {
            if (PROPERTY_MODELID.equalsIgnoreCase(attribute)) {
                this.id = "" + value;
                return true;
            }
            if (PROPERTY_MODELCLASS.equalsIgnoreCase(attribute)) {
                IdMap map = space.getMap();
                if (map == null) {
                    return false;
                }
                if (map.getObject(this.id) != null) {
                    return true;
                }
                String className = "" + value;
                SortedSet<NodeProxy> nodeProxies = space.getNodeProxies();
                SimpleList<NodeProxyModel> candidates = new SimpleList<NodeProxyModel>();
                for (NodeProxy proxy : nodeProxies) {
                    Object modell;
                    NodeProxyModel modelProxy;
                    if (!(proxy instanceof NodeProxyModel) || (modelProxy = (NodeProxyModel)proxy).getId() != null || (modell = modelProxy.getModell()) == null || !modell.getClass().getName().equals(className)) continue;
                    candidates.add(modelProxy);
                }
                if (candidates.size() != 1) {
                    return false;
                }
                NodeProxyModel modelProxy = (NodeProxyModel)candidates.first();
                map.put(this.id, modelProxy.getModell(), false);
                space.suspendNotification(new UpdateAccumulate[0]);
                return true;
            }
            if (PROPERTY_MODEL.equalsIgnoreCase(attribute)) {
                space.resetNotification();
                return true;
            }
        }
        return super.setValue(entity, attribute, value, type);
    }

    @Override
    public boolean runTask() throws Exception {
        if (super.runTask()) {
            return true;
        }
        if (this.space == null) {
            return false;
        }
        NodeProxy proxy = this.space.updateProxy(this);
        return proxy != null;
    }

    public static AcceptMessage create() {
        AcceptMessage msg = new AcceptMessage();
        msg.withSendAnyHow(true);
        return msg;
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        AcceptMessage acceptMessage = new AcceptMessage();
        if (!prototyp && this.space != null) {
            acceptMessage.withSpace(this.space);
        }
        return acceptMessage;
    }

    @Override
    public String getType() {
        return PROPERTY_TYPE;
    }
}

