/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.petaf;

import de.uniks.networkparser.ext.petaf.MessageRequest;
import de.uniks.networkparser.ext.petaf.proxy.NodeProxyTCP;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class Server_TCP
extends Thread {
    protected boolean run = true;
    protected ServerSocket serverSocket;
    private NodeProxyTCP proxy;

    public Server_TCP(int port) {
        this(NodeProxyTCP.createServer(port));
    }

    public Server_TCP(NodeProxyTCP proxy) {
        this.proxy = proxy;
        if (this.init()) {
            this.start();
        }
    }

    public boolean isRun() {
        return this.run;
    }

    public void closeServer() {
        this.run = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        if (this.proxy.getUrl() != null) {
            Thread.currentThread().setName(this.proxy.getUrl() + ":" + this.proxy.getPort() + " com server");
        } else {
            Thread.currentThread().setName("localhost:" + this.proxy.getPort() + " com server");
        }
        while (!this.isInterrupted() && this.run) {
            Socket requestSocket = null;
            try {
                requestSocket = this.serverSocket.accept();
                MessageRequest.executeTask(this.proxy, requestSocket);
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    private boolean init() {
        boolean success = true;
        try {
            this.serverSocket = new ServerSocket(this.proxy.getPort(), 10, null);
        }
        catch (UnknownHostException e) {
            success = false;
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }
}

