/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx.dialog;

import de.uniks.networkparser.ext.HTMLUtil;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.javafx.dialog.DialogBox;

public class DialogPane
implements Runnable {
    private Object opaqueLayer;
    private DialogBox owner;
    private Object parent;
    private Object pane;
    private double initWidth;
    private double initHeight;
    private int initCount = 1;

    public DialogPane(DialogBox owner, Object parent) {
        this.owner = owner;
        this.parent = parent;
        this.pane = ReflectionLoader.newInstance(ReflectionLoader.PANE, new Object[0]);
        if (owner != null) {
            this.initHeight = this.owner.prefWidth(-1.0);
            this.initWidth = this.owner.prefHeight(-1.0);
            if (!owner.isModel()) {
                this.opaqueLayer = ReflectionLoader.newInstance(ReflectionLoader.REGION, new Object[0]);
                HTMLUtil.setStyle(this.opaqueLayer, false, "lightweight-dialog-background");
                HTMLUtil.addChildren(this.pane, 0, this.opaqueLayer);
            }
            HTMLUtil.addChildren(this.pane, -1, owner.getRoot());
        }
        ReflectionLoader.call("setManaged", this.pane, Boolean.TYPE, true);
    }

    public Object getPane() {
        return this.pane;
    }

    protected void layoutChildren() {
        double dialogWidth = this.owner.prefWidth(-1.0);
        double dialogHeight = this.owner.prefHeight(-1.0);
        if (this.initCount > 999) {
            this.initCount = -1;
        }
        if (dialogHeight == this.initHeight && dialogWidth == this.initWidth) {
            if (this.initCount > 0) {
                ++this.initCount;
                ReflectionLoader.call("runLater", ReflectionLoader.PLATFORM, this);
            }
        } else if (this.initCount > 0) {
            this.initCount = -1;
        }
        double w = this.owner.getOverlayWidth();
        double h = this.owner.getOverlayHeight();
        double x = 0.0;
        double y = 0.0;
        if (this.parent != null) {
            ReflectionLoader.call("resizeRelocate", this.parent, Double.TYPE, 0.0, Double.TYPE, 0.0, Double.TYPE, w, Double.TYPE, h);
        }
        if (this.opaqueLayer != null) {
            ReflectionLoader.call("resizeRelocate", this.opaqueLayer, Double.TYPE, 0.0, Double.TYPE, 0.0, Double.TYPE, w, Double.TYPE, h);
        }
        Object root = this.owner.getRoot();
        ReflectionLoader.call("resize", root, Double.TYPE, (int)dialogWidth, Double.TYPE, (int)dialogHeight);
        if (this.initCount == -1) {
            this.initCount = -2;
            double dialogX = (Double)ReflectionLoader.call("getLayoutX", root, new Object[0]);
            dialogX = dialogX == 0.0 ? w / 2.0 - dialogWidth / 2.0 : dialogX;
            double dialogY = (Double)ReflectionLoader.call("getLayoutY", root, new Object[0]);
            dialogY = dialogY == 0.0 ? h / 2.0 - dialogHeight / 2.0 : dialogY;
            ReflectionLoader.call("relocate", root, Double.TYPE, (int)dialogX, Double.TYPE, (int)dialogY);
        }
    }

    protected double computeMinHeight(double width) {
        return (Double)ReflectionLoader.call("minHeight", this.parent, width);
    }

    protected double computeMinWidth(double height) {
        return (Double)ReflectionLoader.call("minWidth", this.parent, height);
    }

    protected double computePrefHeight(double width) {
        return (Double)ReflectionLoader.call("prefHeight", this.parent, width);
    }

    protected double computePrefWidth(double height) {
        return (Double)ReflectionLoader.call("prefWidth", this.parent, height);
    }

    protected double computeMaxHeight(double width) {
        return (Double)ReflectionLoader.call("maxHeight", this.parent, width);
    }

    protected double computeMaxWidth(double height) {
        return (Double)ReflectionLoader.call("maxWidth", this.parent, height);
    }

    @Override
    public void run() {
        this.layoutChildren();
    }
}

