/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.UpdateAccumulate;
import de.uniks.networkparser.UpdateCondition;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.MapListener;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleIteratorSet;
import de.uniks.networkparser.list.SimpleList;
import java.beans.PropertyChangeEvent;
import java.util.Collection;

public class UpdateListener
implements MapListener {
    private IdMap map;
    private Tokener factory;
    private SimpleList<UpdateAccumulate> suspendIdList;
    private Filter updateFilter = new Filter().withStrategy("upd").withConvertable(new UpdateCondition());

    public UpdateListener(IdMap map, Tokener factory) {
        this.map = map;
        this.factory = factory;
    }

    @Override
    public boolean suspendNotification(UpdateAccumulate ... accumulates) {
        this.suspendIdList = new SimpleList();
        if (accumulates == null) {
            this.suspendIdList.add(new UpdateAccumulate().withTokener(this.factory));
        } else {
            for (UpdateAccumulate item : accumulates) {
                this.suspendIdList.add(item);
            }
        }
        return true;
    }

    @Override
    public SimpleList<UpdateAccumulate> resetNotification() {
        SimpleList<UpdateAccumulate> list = this.suspendIdList;
        this.suspendIdList = null;
        return list;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object source = evt instanceof SimpleEvent ? ((SimpleEvent)evt).getModelValue() : evt.getSource();
        String property = evt.getPropertyName();
        SendableEntityCreator creatorClass = this.map.getCreatorClass(source);
        if (creatorClass == null) {
            return;
        }
        if (this.suspendIdList != null) {
            for (UpdateAccumulate listener : this.suspendIdList) {
                listener.changeAttribute(this, source, creatorClass, property, oldValue, newValue);
            }
            return;
        }
        Entity jsonObject = this.change(property, source, creatorClass, oldValue, newValue);
        ObjectCondition listener = this.map.getUpdateListener();
        if (listener == null) {
            return;
        }
        if (oldValue != null && newValue != null) {
            listener.update(new SimpleEvent("upd", jsonObject, evt, this.map));
        } else {
            listener.update(new SimpleEvent("new", jsonObject, evt, this.map));
        }
    }

    public Entity change(String property, Object source, SendableEntityCreator creatorClass, Object oldValue, Object newValue) {
        Entity jsonObject = this.factory.newInstance();
        String id = this.map.getId(source, true);
        Grammar grammar = this.map.getGrammar();
        grammar.writeBasicValue(jsonObject, source.getClass().getName(), id, this.map);
        this.change(property, creatorClass, jsonObject, oldValue, newValue);
        return jsonObject;
    }

    public boolean change(String property, SendableEntityCreator creator, Entity change, Object oldValue, Object newValue) {
        SendableEntityCreator creatorClass;
        boolean done = false;
        String[] properties = creator.getProperties();
        if (properties == null) {
            return false;
        }
        for (String attrName : properties) {
            if (!attrName.equals(property)) continue;
            done = true;
            break;
        }
        if (!done) {
            if ("REMOVE_YOU".equals(property)) {
                this.removeObj(oldValue, true);
            }
            return false;
        }
        Object child = null;
        if (oldValue != null) {
            Entity entity;
            creatorClass = this.map.getCreatorClass(oldValue);
            child = change.getValue("rem");
            if (child instanceof Entity) {
                entity = (Entity)child;
            } else {
                entity = this.factory.newInstance();
                change.put("rem", entity);
            }
            if (creatorClass != null) {
                String oldId = this.map.getId(oldValue, true);
                if (oldId != null) {
                    Entity childItem = this.factory.newInstance();
                    childItem.put("id", oldId);
                    entity.put(property, childItem);
                }
            } else {
                entity.put(property, oldValue);
            }
        }
        if (newValue != null) {
            Entity entity;
            creatorClass = this.map.getCreatorClass(newValue);
            child = change.getValue("upd");
            if (child instanceof Entity) {
                entity = (Entity)child;
            } else {
                entity = this.factory.newInstance();
                change.put("upd", entity);
            }
            if (creatorClass != null) {
                Entity item;
                String key = this.map.getKey(newValue);
                if (key != null) {
                    item = this.factory.newInstance();
                    item.put("class", newValue.getClass().getName());
                    item.put("id", key);
                    entity.put(property, item);
                } else {
                    item = (Entity)this.map.encode(newValue, this.factory, this.updateFilter);
                    entity.put(property, item);
                }
            } else {
                entity.put(property, newValue);
            }
        }
        return true;
    }

    @Override
    public Object execute(Entity updateMessage, Filter filter) {
        Object refObject;
        if (!updateMessage.has("upd") && !updateMessage.has("rem")) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        String id = updateMessage.getString("id");
        Entity remove = (Entity)updateMessage.getValue("rem");
        Entity update = (Entity)updateMessage.getValue("upd");
        Object masterObj = this.map.getObject(id);
        if (masterObj == null) {
            String masterObjClassName = (String)updateMessage.getValue("class");
            if (masterObjClassName != null) {
                SendableEntityCreator creator = this.map.getCreator(masterObjClassName, true, null);
                masterObj = creator.getSendableInstance(false);
            }
            if (masterObj == null) {
                return null;
            }
            this.map.put(id, masterObj, false);
        }
        SendableEntityCreator creator = this.map.getCreatorClass(masterObj);
        if (remove == null && update != null) {
            refObject = creator.getSendableInstance(true);
            SimpleIteratorSet i = new SimpleIteratorSet(update);
            while (i.hasNext()) {
                Object item = i.next();
                String key = (String)item.getKey();
                Object value = creator.getValue(masterObj, key);
                if (value == null) {
                    return this.setValue(creator, masterObj, key, item.getValue(), "new");
                }
                if (value instanceof Collection) {
                    return this.setValue(creator, masterObj, key, item.getValue(), "new");
                }
                if (!value.equals(creator.getValue(refObject, key))) continue;
                return this.setValue(creator, masterObj, key, update.getValue(key), "new");
            }
            return true;
        }
        if (update == null && remove != null) {
            refObject = creator.getSendableInstance(true);
            for (int i = 0; i < remove.size(); ++i) {
                Object removeJsonObject;
                String key = remove.getKeyByIndex(i);
                Object value = creator.getValue(masterObj, key);
                if (value instanceof Collection) {
                    removeJsonObject = (Entity)remove.getValue(key);
                    this.setValue(creator, masterObj, key, removeJsonObject, "rem");
                } else if (this.checkValue(value, key, remove)) {
                    this.setValue(creator, masterObj, key, creator.getValue(refObject, key), "rem");
                }
                removeJsonObject = remove.getValue(key);
                if (removeJsonObject == null || !(removeJsonObject instanceof Entity)) continue;
                Entity json = (Entity)removeJsonObject;
                this.map.notify(new SimpleEvent("rem", json, this.map, key, this.map.decode(json), null).withModelValue(masterObj));
            }
            return masterObj;
        }
        if (update != null) {
            for (int i = 0; i < update.size(); ++i) {
                String key = update.getKeyByIndex(i);
                Object oldValue = creator.getValue(masterObj, key);
                if (!this.checkValue(oldValue, key, remove)) continue;
                Object newValue = update.getValue(key);
                this.setValue(creator, masterObj, key, newValue, "upd");
                this.map.notify(new SimpleEvent("upd", update, this.map, key, oldValue, newValue).withModelValue(masterObj));
            }
            return masterObj;
        }
        return null;
    }

    private boolean checkValue(Object value, String key, Entity oldJsonObject) {
        Object oldValue = oldJsonObject.getValue(key);
        if (value != null) {
            if (oldValue instanceof Entity) {
                String oldId = (String)((Entity)oldValue).getValue("id");
                return oldId.equals(this.map.getId(value, true));
            }
            return value.equals(oldValue);
        }
        return oldValue == null;
    }

    private Object setValue(SendableEntityCreator creator, Object element, String key, Object newValue, String typ) {
        if (newValue instanceof Entity) {
            Entity json = (Entity)newValue;
            Object value = this.map.decode(json);
            if (value != null) {
                creator.setValue(element, key, value, typ);
                if (this.map.notify(new SimpleEvent(typ, json, this.map, key, null, value).withModelValue(element))) {
                    return element;
                }
            }
        } else {
            creator.setValue(element, key, newValue, typ);
            if (this.map.notify(new SimpleEvent(typ, null, this.map, key, null, newValue).withModelValue(element))) {
                return element;
            }
        }
        return null;
    }

    @Override
    public UpdateListener withFilter(Filter filter) {
        this.updateFilter = filter;
        return this;
    }

    @Override
    public Filter getFilter() {
        return this.updateFilter;
    }

    public boolean removeObj(Object oldValue, boolean destroy) {
        if (this.map != null) {
            return this.map.removeObj(oldValue, destroy);
        }
        return false;
    }
}

