/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.parser.SymTabEntry;
import java.util.Collection;

public class SourceCode
extends GraphMember {
    public static final String NAME = "SourceCode";
    private CharacterBuffer content;
    private SimpleKeyValueList<String, SimpleList<SymTabEntry>> keys = new SimpleKeyValueList();
    private boolean fileBodyHasChanged = false;
    private String fileName;
    private int size;
    private int startOfImports;
    private int endOfClassName;
    private int endOfExtendsClause;
    private int endOfImports;
    private int endOfImplementsClause;
    private int bodyStart;
    private int endOfAttributeInitialization;
    private int endOfBody;

    public SourceCode() {
        this.name = NAME;
    }

    public SourceCode withFileName(String name) {
        this.fileName = name;
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public CharacterBuffer getContent() {
        return this.content;
    }

    public SourceCode withContent(CharacterBuffer content) {
        this.content = content;
        this.size = content.length();
        return this;
    }

    public int size() {
        return this.size;
    }

    public SimpleList<SymTabEntry> getSymbolEntries(String type) {
        SimpleList<Object> list = this.keys.get(type);
        if (list == null) {
            list = new SimpleList();
            this.keys.add(type, list);
        }
        return list;
    }

    public SymTabEntry getSymbolEntry(String type, String name) {
        if (name == null || type == null) {
            return null;
        }
        SimpleList<SymTabEntry> list = this.keys.get(type.toLowerCase());
        if (list != null) {
            for (SymTabEntry entry : list) {
                if (!name.equals(entry.getValue())) continue;
                return entry;
            }
        }
        return null;
    }

    public SimpleKeyValueList<String, SimpleList<SymTabEntry>> getSymbolTab() {
        return this.keys;
    }

    public GraphMember with(Clazz parent) {
        this.parentNode = parent;
        GraphSimpleSet children = new GraphSimpleSet();
        children.withList((Collection)parent.getChildren());
        for (GraphMember item : children) {
            if (!(item instanceof SourceCode) || item == this) continue;
            parent.remove(item);
        }
        parent.withChildren(this);
        return this;
    }

    public boolean isFileBodyHasChanged() {
        return this.fileBodyHasChanged;
    }

    public void setFileBodyHasChanged(boolean fileBodyHasChanged) {
        this.fileBodyHasChanged = fileBodyHasChanged;
    }

    public CharSequence subString(int start, int end) {
        return this.content.subSequence(start, end);
    }

    public int getEndOfClassName() {
        return this.endOfClassName;
    }

    public SourceCode withEndOfClassName(int value) {
        this.endOfClassName = value;
        return this;
    }

    public int getEndOfExtendsClause() {
        return this.endOfExtendsClause;
    }

    public SourceCode withEndOfExtendsClause(int value) {
        this.endOfExtendsClause = value;
        return this;
    }

    public int getEndOfImports() {
        return this.endOfImports;
    }

    public SourceCode withEndOfImports(int value) {
        this.endOfImports = value;
        return this;
    }

    public SourceCode withEndOfImplementsClause(int value) {
        this.endOfImplementsClause = value;
        return this;
    }

    public int getEndOfImplementsClause() {
        return this.endOfImplementsClause;
    }

    public SourceCode withStartBody(int value) {
        this.bodyStart = value;
        return this;
    }

    public int getBodyStart() {
        return this.bodyStart;
    }

    public SourceCode withEndOfAttributeInitialization(int value) {
        this.endOfAttributeInitialization = value;
        return this;
    }

    public int getEndOfAttributeInitialization() {
        return this.endOfAttributeInitialization;
    }

    public void replaceAll(int bodyStartPos, String value) {
        this.content.replace(bodyStartPos, bodyStartPos, value);
        this.fileBodyHasChanged = true;
    }

    public String toString() {
        return this.content.toString();
    }

    public SourceCode withEndBody(int value) {
        this.endOfBody = value;
        return this;
    }

    public int getEndOfBody() {
        return this.endOfBody;
    }

    public SourceCode withStartImports(int value) {
        this.startOfImports = value;
        return this;
    }

    public int getStartOfImports() {
        return this.startOfImports;
    }
}

