/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.graph;

import de.uniks.networkparser.graph.Annotation;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Attribute;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphMember;
import de.uniks.networkparser.graph.GraphModel;
import de.uniks.networkparser.graph.GraphSimpleSet;
import de.uniks.networkparser.graph.ModifyEntry;
import de.uniks.networkparser.graph.util.AssociationSet;
import de.uniks.networkparser.interfaces.Condition;

public abstract class GraphEntity
extends GraphMember {
    private boolean external;
    private String id;

    public String getName(boolean shortName) {
        if (this.name == null) {
            return null;
        }
        if (!shortName) {
            String parentName;
            if (this.name.indexOf(46) < 0 && this.parentNode != null && (parentName = ((GraphMember)this.parentNode).getName()) != null) {
                return parentName + "." + this.name.replace("$", ".");
            }
            return this.name.replace("$", ".");
        }
        if (this.name.endsWith("...")) {
            String realName = this.name.substring(0, this.name.length() - 3);
            int pos = realName.lastIndexOf(".");
            return this.name.substring(pos + 1);
        }
        return this.name.substring(this.name.lastIndexOf(".") + 1);
    }

    protected boolean setId(String id) {
        if (id != this.id) {
            this.id = id;
            return true;
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    protected String getTyp(String typ, boolean shortName) {
        if (typ.equals("objectdiagram")) {
            return this.getId();
        }
        if (typ.equals("classdiagram")) {
            return this.getName(shortName);
        }
        return "";
    }

    AssociationSet getEdges(AssociationTypes type, Condition<?> ... filters) {
        if (this.children == null) {
            return AssociationSet.EMPTY_SET;
        }
        AssociationSet collection = new AssociationSet();
        if (this.children instanceof Association) {
            if (this.check((Association)this.children, filters)) {
                collection.add((Association)this.children);
            }
        } else if (this.children instanceof GraphSimpleSet) {
            GraphSimpleSet list = (GraphSimpleSet)this.children;
            for (GraphMember item : list) {
                Association assoc;
                if (!(item instanceof Association) || !this.check(assoc = (Association)item, filters)) continue;
                if (type == AssociationTypes.EDGE) {
                    collection.add(assoc);
                    continue;
                }
                if (type != AssociationTypes.ASSOCIATION || !AssociationTypes.isEdge(assoc.getType())) continue;
                collection.add(assoc);
            }
        }
        return collection;
    }

    protected GraphMember getByObject(String clazz, boolean fullName) {
        String id;
        if (clazz == null || this.children == null) {
            return null;
        }
        String sub = clazz;
        if (clazz.lastIndexOf(".") >= 0) {
            sub = clazz.substring(clazz.lastIndexOf(".") + 1);
        }
        GraphSimpleSet collection = this.getChildren();
        for (GraphMember item : collection) {
            id = item.getFullId();
            if (!clazz.equalsIgnoreCase(id) && !sub.equalsIgnoreCase(id)) continue;
            return item;
        }
        if (fullName || clazz.lastIndexOf(".") < 0) {
            return null;
        }
        for (GraphMember item : collection) {
            id = item instanceof Clazz ? ((Clazz)item).getId() : item.getName();
            if (!id.endsWith(clazz)) continue;
            return item;
        }
        return null;
    }

    public boolean isExternal() {
        return this.external;
    }

    public GraphEntity withExternal(boolean value) {
        if (this.external != value) {
            this.external = value;
        }
        return this;
    }

    protected GraphEntity with(Association ... values) {
        if (values != null) {
            AssociationSet allAssoc = this.getEdges(AssociationTypes.ASSOCIATION, new Condition[0]);
            for (Association assoc : values) {
                GraphSimpleSet list;
                if (assoc == null || assoc.getOther() == null) continue;
                boolean add = true;
                Association assocOther = assoc.getOther();
                boolean mergeFlag = assoc.getType() == AssociationTypes.ASSOCIATION && assocOther.getType() == AssociationTypes.EDGE || assoc.getType() == AssociationTypes.EDGE && assocOther.getType() == AssociationTypes.ASSOCIATION;
                for (Association item : allAssoc) {
                    GraphMember attribute;
                    if (item == assoc || item.getOther() == assoc) {
                        add = false;
                        break;
                    }
                    Association itemOther = item.getOther();
                    String name = itemOther.name();
                    if (name != null && name.equals(assocOther.name()) && itemOther.getClazz() == assocOther.getClazz()) {
                        add = false;
                        break;
                    }
                    if (!mergeFlag || itemOther.getClazz() != assocOther.getClazz() || item.getClazz() != assoc.getClazz()) continue;
                    add = false;
                    if (assocOther.name() != null && assoc.name() == null) {
                        if (itemOther.getType() != AssociationTypes.EDGE || item.getType() != AssociationTypes.ASSOCIATION) break;
                        itemOther.with(AssociationTypes.ASSOCIATION);
                        itemOther.with(assocOther.getName());
                        itemOther.with(assocOther.getCardinality());
                        attribute = itemOther.getClazz().getChildByName(assocOther.getName(), Attribute.class);
                        if (attribute == null) break;
                        itemOther.getClazz().without(attribute);
                        break;
                    }
                    if (item.getType() != AssociationTypes.EDGE || itemOther.getType() != AssociationTypes.ASSOCIATION) break;
                    item.with(AssociationTypes.ASSOCIATION);
                    item.with(assoc.getName());
                    item.with(assoc.getCardinality());
                    attribute = item.getClazz().getChildByName(assoc.getName(), Attribute.class);
                    if (attribute == null) break;
                    item.getClazz().without(attribute);
                    break;
                }
                if (!add) continue;
                if (this.parentNode != null && this.parentNode instanceof GraphModel) {
                    ((GraphModel)this.parentNode).with(assoc);
                }
                if (this.children == null) {
                    this.children = assoc;
                    continue;
                }
                if (this.children instanceof GraphSimpleSet) {
                    list = (GraphSimpleSet)this.children;
                    list.add(assoc);
                    continue;
                }
                list = new GraphSimpleSet();
                list.with((GraphMember)this.children);
                this.children = list;
                list.add(assoc);
            }
        }
        return this;
    }

    public GraphMember getChildByName(String name, Class<?> subClass) {
        if (this.children == null) {
            return null;
        }
        GraphSimpleSet children = this.getChildren();
        for (GraphMember item : children) {
            String itemName;
            if (item instanceof Association) {
                Association assoc = (Association)item;
                itemName = assoc.getOther().name();
            } else {
                itemName = item.getName();
            }
            if (itemName == null || !itemName.equals(name) || subClass == null || subClass != item.getClass()) continue;
            return item;
        }
        return null;
    }

    public AssociationSet getAssociations(Condition<?> ... filters) {
        return this.getEdges(AssociationTypes.EDGE, filters);
    }

    @Override
    public Annotation getAnnotation() {
        return super.getAnnotation();
    }

    public GraphEntity with(Annotation value) {
        this.withAnnotation(value);
        return this;
    }

    protected GraphEntity with(ModifyEntry modifier) {
        super.withChildren(modifier);
        return this;
    }
}

