/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.converter.ByteConverter;
import de.uniks.networkparser.converter.ByteConverterHTTP;
import de.uniks.networkparser.converter.ByteConverterString;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Converter;
import java.nio.charset.Charset;

public class ByteBuffer
extends BufferedBuffer
implements BaseItem {
    protected byte[] buffer;

    @Override
    public char charAt(int index) {
        if (index < 0 || this.buffer == null || index >= this.buffer.length) {
            return '\u0000';
        }
        return (char)this.buffer[index];
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0 || this.buffer == null || index >= this.buffer.length) {
            return 0;
        }
        return this.buffer[index];
    }

    @Override
    public CharacterBuffer subSequence(int start, int end) {
        int len = end - start;
        byte[] sub = new byte[len];
        if (start < this.buffer.length && len <= this.buffer.length) {
            for (int i = 0; i < len; ++i) {
                sub[i] = this.buffer[start + i];
            }
        }
        return new CharacterBuffer().with(sub);
    }

    public ByteBuffer withBufferLength(int length) {
        super.withLength(length);
        this.buffer = new byte[length];
        return this;
    }

    @Override
    public char getChar() {
        byte no = this.getByte();
        if (no >= 0) {
            return (char)no;
        }
        char result = (char)(no << 8 + (char)this.getByte());
        return result;
    }

    @Override
    public byte getByte() {
        if (this.buffer == null || this.position >= this.buffer.length - 1) {
            return 0;
        }
        return this.buffer[++this.position];
    }

    public Byte[] getBytes() {
        if (this.buffer == null || this.position >= this.buffer.length - 1) {
            return new Byte[0];
        }
        Byte[] result = new Byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.buffer[i + this.position];
        }
        return result;
    }

    public byte[] toBytes() {
        if (this.buffer == null || this.position >= this.buffer.length - 1) {
            return new byte[0];
        }
        byte[] result = new byte[this.length - this.position];
        for (int i = 0; i < this.length - this.position; ++i) {
            result[i] = this.buffer[i + this.position];
        }
        return result;
    }

    public byte[] getValue(int start, int len) {
        this.withPosition(start);
        byte[] array = new byte[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.getByte();
        }
        return array;
    }

    public byte[] array() {
        return this.buffer;
    }

    public boolean add(byte bytes) {
        return this.addBytes(bytes, 1);
    }

    public boolean add(int bytes) {
        return this.addBytes((byte)bytes, 1);
    }

    public boolean add(Byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        return this.addBytes(bytes, bytes.length);
    }

    public boolean add(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        return this.addBytes(bytes, bytes.length);
    }

    protected boolean addBytes(Object bytes, int len) {
        byte[] oldBuffer;
        int newSize;
        int bufferLen = 0;
        if (this.buffer != null) {
            bufferLen = this.buffer.length;
        }
        if (this.position < 0) {
            newSize = this.length + len + (this.length + len) / 2 + 5;
            oldBuffer = this.buffer;
            this.buffer = new byte[newSize];
            int oldSize = 0;
            if (oldBuffer != null) {
                oldSize = oldBuffer.length;
                System.arraycopy(oldBuffer, oldBuffer.length - this.length, this.buffer, newSize - this.length, this.length);
            }
            this.position += newSize - oldSize;
        } else if (this.position + len > bufferLen) {
            if (bufferLen > 0) {
                newSize = this.position + len + (this.position + len) / 2 + 5;
                oldBuffer = this.buffer;
                this.buffer = new byte[newSize];
                System.arraycopy(oldBuffer, 0, this.buffer, 0, this.position);
            } else {
                this.buffer = new byte[len];
            }
        }
        if (bytes instanceof Byte) {
            this.buffer[this.position] = (Byte)bytes;
        } else if (bytes instanceof byte[]) {
            byte[] source = (byte[])bytes;
            if (this.buffer != null && this.buffer.length >= this.position + len) {
                for (int i = 0; i < len; ++i) {
                    this.buffer[this.position + i] = source[i];
                }
            }
        } else {
            Byte[] source = (Byte[])bytes;
            if (this.buffer != null && this.buffer.length >= this.position + len) {
                for (int i = 0; i < len; ++i) {
                    this.buffer[this.position + i] = source[i];
                }
            }
        }
        this.length += len;
        return true;
    }

    public void put(byte value) {
        if (this.buffer != null && this.position + 1 <= this.buffer.length) {
            this.buffer[this.position++] = value;
        }
    }

    public void put(short value) {
        if (this.buffer != null && this.position + 2 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(int value) {
        if (this.buffer != null && this.position + 4 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(long value) {
        if (this.buffer != null && this.position + 8 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 56);
            this.buffer[this.position++] = (byte)(value >>> 48);
            this.buffer[this.position++] = (byte)(value >>> 40);
            this.buffer[this.position++] = (byte)(value >>> 32);
            this.buffer[this.position++] = (byte)(value >>> 24);
            this.buffer[this.position++] = (byte)(value >>> 16);
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(char value) {
        if (this.buffer != null && this.position + 2 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(value >>> 8);
            this.buffer[this.position++] = (byte)value;
        }
    }

    public void put(float value) {
        int bits = Float.floatToIntBits(value);
        if (this.buffer != null && this.position + 4 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(bits & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 8 & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 16 & 0xFF);
            this.buffer[this.position++] = (byte)(bits >> 24 & 0xFF);
        }
    }

    public void put(double value) {
        long bits = Double.doubleToLongBits(value);
        if (this.buffer != null && this.position + 8 <= this.buffer.length) {
            this.buffer[this.position++] = (byte)(bits >> 56 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 48 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 40 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 32 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 24 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 16 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 8 & 0xFFL);
            this.buffer[this.position++] = (byte)(bits >> 0 & 0xFFL);
        }
    }

    public void put(byte[] value) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                this.put(value[i]);
            }
        }
    }

    public void put(byte[] value, int offset, int length) {
        if (value == null || offset < 0 || offset > value.length) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.put(value[offset + i]);
        }
    }

    public ByteBuffer flip(boolean preFirst) {
        if (preFirst) {
            this.position = -1;
            return this;
        }
        this.position = 0;
        return this;
    }

    public ByteBuffer getNewBuffer(int capacity) {
        return new ByteBuffer().withBufferLength(capacity);
    }

    public static ByteBuffer allocate(int len) {
        ByteBuffer bytesBuffer = new ByteBuffer();
        bytesBuffer.withBufferLength(len);
        return bytesBuffer;
    }

    public ByteBuffer getNewBuffer(byte[] array) {
        return new ByteBuffer().with(array);
    }

    public ByteBuffer with(String string) {
        this.buffer = string.getBytes(Charset.forName("utf-8"));
        this.position = 0;
        this.length = this.buffer.length;
        return this;
    }

    public ByteBuffer with(byte[] array) {
        this.buffer = array;
        this.position = 0;
        this.length = array.length;
        return this;
    }

    public ByteBuffer with(byte value) {
        if (this.buffer == null) {
            this.buffer = new byte[]{value};
            this.length = 1;
            this.position = 0;
        } else if (this.length < this.buffer.length) {
            this.buffer[this.length++] = value;
        }
        return this;
    }

    @Override
    public String toString() {
        return this.toString(new ByteConverterString());
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new ByteBuffer();
    }

    @Override
    public int size() {
        return this.length();
    }

    public String string() {
        return new String(this.buffer);
    }

    @Override
    public String toString(Converter converter) {
        if (converter == null) {
            converter = new ByteConverterHTTP();
        }
        if (converter instanceof ByteConverter) {
            return ((ByteConverter)converter).toString(this.toBytes());
        }
        return String.valueOf(this.buffer);
    }

    public ByteBuffer with(byte[] array, int len) {
        this.position = 0;
        if (len < 0 || len > array.length) {
            len = array.length;
        }
        if (this.buffer == null) {
            this.buffer = array;
            this.length = len;
        } else {
            byte[] oldBuffer = this.buffer;
            this.buffer = new byte[this.length * 2 + len];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, this.length);
            System.arraycopy(array, 0, this.buffer, this.length, len);
            this.length += len;
        }
        return this;
    }

    @Override
    public boolean add(Object ... values) {
        if (values == null) {
            return true;
        }
        for (Object item : values) {
            if (!(item instanceof byte[])) continue;
            this.with((byte[])item, -1);
        }
        return true;
    }
}

