/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.ext.LogItem;
import de.uniks.networkparser.interfaces.ObjectCondition;

public class NetworkParserLog {
    public static final String ERROR_TYP_PARSING = "PARSING";
    public static final String ERROR_TYP_CONCURRENTMODIFICATION = "CONCURRENTMODIFICATION";
    public static final String ERROR_TYP_NOCREATOR = "NOCREATORFOUND";
    public static final String ERROR_TYP_DUPPLICATE = "DUPPLICATE";
    public static final byte LOGLEVEL_INFO = 1;
    public static final byte LOGLEVEL_WARNING = 2;
    public static final byte LOGLEVEL_ERROR = 4;
    public static final byte LOGLEVEL_ALL = 7;
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String DEBUG = "DEBUG";
    public static final String ERROR = "ERROR";
    public static final String LOG = "LOG";
    private byte flag = (byte)5;
    private ObjectCondition condition;

    public boolean debug(Object owner, String method, String message) {
        if (this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withType(DEBUG));
        }
        return false;
    }

    public boolean print(Object owner, LogItem item) {
        if (this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, null, null, item).withType(LOG));
        }
        return false;
    }

    public boolean info(Object owner, String method, String message) {
        if ((this.flag & 1) != 0 && this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withType(INFO));
        }
        return false;
    }

    public NetworkParserLog withFlag(byte flag) {
        this.flag = (byte)(this.flag | flag);
        return this;
    }

    public NetworkParserLog withoutFlag(byte flag) {
        this.flag = (byte)(this.flag | flag);
        this.flag = (byte)(this.flag - flag);
        return this;
    }

    public boolean warn(Object owner, String method, String message) {
        if ((this.flag & 2) != 0 && this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withType(WARNING));
        }
        return false;
    }

    public boolean error(Object owner, String method, String message, Object ... params) {
        if ((this.flag & 4) != 0 && this.condition != null) {
            return this.condition.update(new SimpleEvent(owner, method, null, message).withModelValue(params).withType(ERROR));
        }
        return false;
    }

    public boolean log(Object owner, String method, String msg, int level) {
        if (level == 4) {
            return this.error(owner, method, msg, new Object[0]);
        }
        if (level == 2) {
            return this.warn(owner, method, msg);
        }
        return this.info(owner, method, msg);
    }

    public NetworkParserLog withListener(ObjectCondition condition) {
        this.condition = condition;
        return this;
    }
}

