/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.Tokener;
import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorTag;
import de.uniks.networkparser.list.AbstractList;
import de.uniks.networkparser.xml.MapEntityStack;
import de.uniks.networkparser.xml.XMLEntity;

public class MapEntity
extends AbstractList<Object> {
    protected Filter filter;
    protected int deep;
    protected Object target;
    protected MapEntityStack stack;
    protected byte tokenerFlag;
    private IdMap map;
    public byte mapFlag;
    private Grammar grammar;

    public MapEntity(Filter filter, byte flag, IdMap map) {
        if (filter != null) {
            this.filter = filter;
        }
        this.mapFlag = flag;
        this.map = map;
        this.grammar = map.getGrammar();
    }

    public MapEntity(IdMap map) {
        if (map != null) {
            this.filter = map.getFilter();
            this.mapFlag = map.getFlag();
            this.grammar = map.getGrammar();
        }
        this.map = map;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Entity encode(Object entity, Tokener tokener) {
        return tokener.getMap().encode(entity, this, tokener);
    }

    public int getDeep() {
        return this.deep;
    }

    public boolean isId(Object target) {
        String className = target.getClass().getName();
        return this.filter.isId(target, className, this.map);
    }

    public boolean isSearchForSuperClass() {
        return (this.mapFlag & 2) != 0;
    }

    public boolean isSimpleFormat() {
        boolean result;
        boolean bl = result = (this.mapFlag & 2) != 0;
        if (result) {
            return result;
        }
        return this.filter.isSimpleFormat();
    }

    public Object getTarget() {
        return this.target;
    }

    public MapEntity withTarget(Object target) {
        this.target = target;
        return this;
    }

    public MapEntity withDeep(int value) {
        this.deep = value;
        return this;
    }

    public int addDeep() {
        ++this.deep;
        return this.deep;
    }

    public Object getCloneByEntity(Object value) {
        for (int i = 0; i < this.size(); i += 2) {
            if (this.get(i) != value) continue;
            return this.get(i + 1);
        }
        return null;
    }

    public Object getEntityByClone(Object value) {
        for (int i = 1; i < this.size(); i += 2) {
            if (this.get(i) != value) continue;
            return this.get(i - 1);
        }
        return null;
    }

    public MapEntityStack getStack() {
        return this.stack;
    }

    public void pushStack(String className, Object entity, SendableEntityCreator creator) {
        if (this.stack != null) {
            this.stack.withStack(className, entity, creator);
        }
        ++this.deep;
    }

    public void popStack() {
        if (this.stack != null) {
            this.stack.popStack();
        }
        --this.deep;
    }

    public MapEntity withStack(MapEntityStack stack) {
        this.stack = stack;
        return this;
    }

    public CharacterBuffer getPrefixProperties(SendableEntityCreator creator, Object entity, String className) {
        CharacterBuffer result = new CharacterBuffer();
        if (this.isSimpleFormat()) {
            return result;
        }
        boolean isComplex = this.filter.isSimpleFormat(entity, creator, className, this.map);
        if (isComplex) {
            return result;
        }
        result.with('.').with("prop").with('.');
        return result;
    }

    public MapEntity withFilter(Filter filter) {
        this.filter = filter;
        return this;
    }

    public String getId(Object entity, String className) {
        if (this.filter.isId(entity, className, this.map)) {
            boolean newMessage = !"upd".equals(this.getFilter().getStrategy());
            String id = this.map.getId(entity, newMessage);
            this.with(id);
            return id;
        }
        this.with(entity);
        return null;
    }

    public Entity writeBasicValue(SendableEntityCreator creator, Entity entity, BaseItem parent, String className, String id) {
        if ((this.mapFlag & 1) == 0) {
            if (creator instanceof SendableEntityCreatorTag) {
                className = ((SendableEntityCreatorTag)creator).getTag();
            }
            id = null;
        }
        return this.grammar.writeBasicValue(entity, className, id, this.getMap());
    }

    public boolean isAddOwnerLink(Object value) {
        if ((this.mapFlag & 1) != 0) {
            return true;
        }
        if (this.stack != null) {
            return this.stack.getPrevItem() != value;
        }
        return false;
    }

    public int getIndexOfClazz(String clazzName) {
        if (clazzName == null) {
            return -1;
        }
        int pos = 0;
        for (Object item : this) {
            if (clazzName.equalsIgnoreCase(item.getClass().getName())) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int getIndexVisitedObjects(Object element) {
        int pos = 0;
        for (Object item : this) {
            if (item == element) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public Object getVisitedObjects(int index) {
        if (index >= 0 && index < this.size()) {
            return this.get(index);
        }
        return null;
    }

    public String getClazz(int pos) {
        if (pos < 0 || pos > this.size()) {
            return null;
        }
        Object item = this.get(pos);
        if (item instanceof String) {
            return "" + item;
        }
        return null;
    }

    public String getLastClazz() {
        Object item = this.last();
        if (item != null) {
            return item.getClass().getName();
        }
        return null;
    }

    public Entity convertProperty(CharacterBuffer property, BaseItem parent) {
        BaseItem child = parent;
        while (property.charAt(0) == '.' && property.length() != 1) {
            int pos = property.indexOf(46, 1);
            if (pos < 0) {
                property.trimStart(1);
                break;
            }
            String label = property.substring(1, pos);
            property.trimStart(label.length() + 1);
            if (!(child instanceof Entity)) continue;
            Entity entity = (Entity)child;
            BaseItem newItem = entity.getElementBy("tag", label);
            if (newItem == null) {
                newItem = child.getNewList(true);
                if (newItem instanceof XMLEntity) {
                    ((XMLEntity)newItem).setType(label);
                    entity.add(newItem);
                } else {
                    ((Entity)child).put(label, newItem);
                }
            }
            child = newItem;
        }
        return (Entity)child;
    }

    public boolean isFlag(byte flag) {
        return (this.mapFlag & flag) != 0;
    }

    public MapEntity withTokenerFlag(byte flag) {
        this.tokenerFlag = (byte)(this.tokenerFlag | flag);
        return this;
    }

    public MapEntity withoutTokenerFlag(byte flag) {
        this.tokenerFlag = (byte)(this.tokenerFlag | flag);
        this.tokenerFlag = (byte)(this.tokenerFlag - flag);
        return this;
    }

    public boolean isTokenerFlag(byte flag) {
        return (this.tokenerFlag & flag) != 0;
    }

    public IdMap getMap() {
        return this.map;
    }

    @Override
    public BaseItem getNewList(boolean keyValue) {
        return new MapEntity(null);
    }
}

