/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.SendableEntityCreatorNoIndex;

public class Filter {
    public static final String MERGE = "merge";
    public static final String COLLISION = "collision";
    public static final Filter SIMPLEFORMAT = new Filter().withSimpleFormat(true);
    protected ObjectCondition idFilter;
    protected ObjectCondition convertable;
    protected ObjectCondition property;
    private static final int FORMAT_REFERENCE = 0;
    private static final int FORMAT_NULL = 1;
    private static final int FORMAT_FULL = 2;
    private static final int FORMAT_TYPESAVE = 3;
    private int format;
    private String strategy = "new";
    private boolean simpleFormat;

    public Filter withIdFilter(ObjectCondition idFilter) {
        this.idFilter = idFilter;
        return this;
    }

    public boolean isId(Object entity, String className, IdMap map) {
        if (this.idFilter != null) {
            return this.idFilter.update(new SimpleEvent("new", null, map, className, null, entity));
        }
        SendableEntityCreator creator = map.getCreator(className, true, null);
        if (creator != null) {
            return !(creator instanceof SendableEntityCreatorNoIndex);
        }
        return true;
    }

    public boolean isSimpleFormat(Object entity, SendableEntityCreator creator, String className, IdMap map) {
        if (this.isSimpleFormat()) {
            return true;
        }
        return creator instanceof SendableEntityCreatorNoIndex || !this.isId(entity, className, map);
    }

    public boolean isFullSerialization() {
        return this.format >= 2;
    }

    public boolean isTypSave() {
        return this.format >= 3;
    }

    public boolean isReferenceCheck() {
        return this.format >= 0;
    }

    public boolean isNullCheck() {
        return this.format >= 1;
    }

    public Filter withFull(boolean value) {
        if (value) {
            if (this.format < 2) {
                this.format = 2;
            }
        } else if (this.format >= 2) {
            this.format = 1;
        }
        return this;
    }

    public Filter withNullCheck(boolean value) {
        if (value) {
            if (this.format < 1) {
                this.format = 1;
            }
        } else if (this.format >= 1) {
            this.format = 0;
        }
        return this;
    }

    public Filter withPropertyRegard(ObjectCondition property) {
        this.property = property;
        return this;
    }

    public Filter withConvertable(ObjectCondition convertable) {
        this.convertable = convertable;
        return this;
    }

    public int convert(Object entity, String property, Object value, IdMap map, int deep) {
        if (this.convertable == null && this.property == null) {
            return 1;
        }
        SimpleEvent event = new SimpleEvent(this.strategy, map, property, null, value, deep, entity);
        if (this.property != null && !this.property.update(event)) {
            return -1;
        }
        if (this.convertable != null && !this.convertable.update(event)) {
            return 0;
        }
        return 1;
    }

    public boolean isConvertable(SimpleEvent event) {
        return this.convertable == null || this.convertable.update(event);
    }

    public ObjectCondition getPropertyRegard() {
        return this.property;
    }

    public static Filter regard(ObjectCondition convertable) {
        return new Filter().withPropertyRegard(convertable);
    }

    public static Filter convertable(ObjectCondition convertable) {
        return new Filter().withConvertable(convertable);
    }

    public static Filter createFull() {
        return new Filter().withFull(true);
    }

    public String[] getProperties(SendableEntityCreator creator) {
        return creator.getProperties();
    }

    public String getStrategy() {
        return this.strategy;
    }

    public Filter withStrategy(String strategy) {
        this.strategy = strategy;
        return this;
    }

    public boolean isSimpleFormat() {
        return this.simpleFormat;
    }

    public Filter withSimpleFormat(boolean value) {
        this.simpleFormat = value;
        return this;
    }

    public void suspendNotification() {
        this.strategy = "upd";
    }
}

