/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.parser;

import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.parser.SymTabEntry;
import de.uniks.networkparser.parser.Token;

public class JavaFile {
    public static final char EOF = '\u0000';
    public static final char COMMENT_START = 'c';
    public static final char LONG_COMMENT_END = 'd';
    public static char NEW_LINE = (char)10;
    private CharSequence content;
    private Token lookAheadToken = new Token();
    private Token previousToken = new Token();
    private Token currentToken = new Token();
    private char currentChar;
    private char lookAheadChar;
    private int index;
    private int lookAheadIndex = -1;
    private int endPos;
    private int parsePos;
    private SymTabEntry symTabEntry;
    private SimpleKeyValueList<String, SimpleList<SymTabEntry>> keys = new SimpleKeyValueList();

    public JavaFile(CharSequence content) {
        this.content = content;
        this.endPos = content.length();
        this.nextChar();
        this.nextChar();
        this.nextToken();
        this.nextToken();
    }

    public String currentWord() {
        return this.currentToken.text.toString();
    }

    public boolean currentKindEquals(char c) {
        return this.currentToken.kind == c;
    }

    public int getCurrentStart() {
        return this.currentToken.startPos;
    }

    public int getCurrentEnd() {
        return this.currentToken.endPos;
    }

    public boolean lookAheadKindEquals(char c) {
        return this.lookAheadToken.kind == c;
    }

    public boolean currentTokenEquals(String word) {
        return JavaFile.stringEquals(this.currentWord(), word);
    }

    public static boolean stringEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public boolean skip(char character) {
        if (this.currentKindEquals(character)) {
            this.nextToken();
            return true;
        }
        this.error("" + character);
        return false;
    }

    public boolean skip(String string) {
        if (this.currentTokenEquals(string)) {
            this.nextToken();
            return true;
        }
        this.error(string);
        return false;
    }

    public void error(CharSequence info) {
        System.err.println("Parser Error: expected token " + info + " found " + this.currentWord() + " at pos " + this.currentToken.startPos + " at line " + this.getLineIndexOf(this.currentToken.startPos, this.content));
        throw new RuntimeException("parse error");
    }

    private long getLineIndexOf(int startPos, CharSequence fileBody) {
        long count = 1L;
        CharSequence substring = fileBody.subSequence(0, startPos);
        for (int index = 0; index < substring.length() - 1; ++index) {
            char firstChar = substring.charAt(index);
            if (firstChar != NEW_LINE) continue;
            ++count;
        }
        return count;
    }

    public void nextToken() {
        Token tmp = this.previousToken;
        this.previousToken = this.currentToken;
        this.currentToken = this.lookAheadToken;
        this.lookAheadToken = tmp;
        this.lookAheadToken.kind = '\u0000';
        this.lookAheadToken.text.delete(0, this.lookAheadToken.text.length());
        int state = 105;
        while (true) {
            switch (state) {
                case 105: {
                    if (Character.isLetter(this.currentChar) || this.currentChar == '_') {
                        state = 118;
                        this.lookAheadToken.kind = (char)118;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '\u0000') {
                        this.lookAheadToken.kind = '\u0000';
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        return;
                    }
                    if (Character.isDigit(this.currentChar)) {
                        state = 57;
                        this.lookAheadToken.kind = (char)57;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        break;
                    }
                    if (this.currentChar == '/' && (this.lookAheadChar == '*' || this.lookAheadChar == '/')) {
                        this.lookAheadToken.kind = (char)99;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '*' && this.lookAheadChar == '/') {
                        this.lookAheadToken.kind = (char)100;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if ("+-*/\\\"'~=()><{}!.,@[]&|?;:#".indexOf(this.currentChar) >= 0) {
                        this.lookAheadToken.kind = this.currentChar;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == '\r') {
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        this.lookAheadToken.text.append(this.currentChar);
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.endPos = this.index;
                        this.nextChar();
                        return;
                    }
                    if (this.currentChar == NEW_LINE) {
                        this.lookAheadToken.kind = NEW_LINE;
                        this.lookAheadToken.startPos = this.index;
                        this.lookAheadToken.endPos = this.index;
                        this.lookAheadToken.text.append(this.currentChar);
                        this.nextChar();
                        return;
                    }
                    if (!Character.isWhitespace(this.currentChar)) break;
                    break;
                }
                case 57: {
                    if (Character.isDigit(this.currentChar)) {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    if (this.currentChar == '.') {
                        state = 56;
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 56: {
                    if (Character.isDigit(this.currentChar)) break;
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
                case 118: {
                    if (Character.isLetter(this.currentChar) || Character.isDigit(this.currentChar) || this.currentChar == '_') {
                        this.lookAheadToken.text.append(this.currentChar);
                        break;
                    }
                    this.lookAheadToken.endPos = this.index - 1;
                    return;
                }
            }
            this.nextChar();
        }
    }

    private void nextChar() {
        this.currentChar = this.lookAheadChar;
        this.index = this.lookAheadIndex;
        this.lookAheadChar = '\u0000';
        while (this.lookAheadChar == '\u0000' && this.lookAheadIndex < this.endPos - 1) {
            ++this.lookAheadIndex;
            this.lookAheadChar = this.content.charAt(this.lookAheadIndex);
        }
    }

    public SymTabEntry getRoot() {
        return this.symTabEntry;
    }

    public SymTabEntry startNextSymTab(String type) {
        SymTabEntry nextEntity = new SymTabEntry();
        nextEntity.setType(type);
        if (this.symTabEntry == null) {
            this.symTabEntry = nextEntity;
        } else {
            this.symTabEntry.setNext(nextEntity);
        }
        this.parsePos = this.getCurrentEnd() + 1;
        this.addCurrentToken(nextEntity);
        SimpleList<SymTabEntry> list = this.keys.get(type);
        if (list == null) {
            list = new SimpleList();
            this.keys.add(type, list);
        }
        list.add(nextEntity);
        return nextEntity;
    }

    public CharSequence finishParse(SymTabEntry nextEntity) {
        int endPos = this.getCurrentEnd();
        CharSequence sequence = this.subString(this.parsePos, endPos);
        nextEntity.add(sequence);
        return sequence;
    }

    public void addCurrentCharacter(char checkCharacter, SymTabEntry nextEntity) {
        if (this.currentKindEquals(checkCharacter)) {
            nextEntity.add(this.currentToken.text.toString());
            this.nextToken();
        }
    }

    public void addNewLine(SymTabEntry nextEntity) {
        if (this.currentKindEquals(NEW_LINE)) {
            nextEntity.add(this.currentToken.text.toString());
            this.nextToken();
        }
    }

    public void addCurrentToken(SymTabEntry nextEntity) {
        nextEntity.add(this.currentToken.text.toString());
    }

    public CharSequence subString(int start, int end) {
        return this.content.subSequence(start, end);
    }
}

