/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import com.sun.management.OperatingSystemMXBean;
import de.uniks.networkparser.ext.Os;
import de.uniks.networkparser.ext.javafx.FXStageController;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.awt.SystemTray;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javafx.application.Application;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.stage.Stage;

public abstract class SimpleShell
extends Application {
    protected String icon;
    private String errorPath;
    protected FXStageController controller;

    protected abstract Parent createContents(FXStageController var1, Application.Parameters var2);

    public void closeWindow() {
        this.controller.close();
    }

    public SimpleKeyValueList<String, String> getParameterMap() {
        SimpleKeyValueList<String, String> map = new SimpleKeyValueList<String, String>();
        List raw = this.getParameters().getRaw();
        for (String item : raw) {
            if (item.startsWith("--")) {
                item = item.substring(2);
            }
            int pos = item.indexOf(":");
            int posEnter = item.indexOf("=");
            if (posEnter > 0 && (posEnter < pos || pos == -1)) {
                pos = posEnter;
            }
            if (pos > 0) {
                map.add(item.substring(0, pos), item.substring(pos + 1));
                continue;
            }
            map.add(item, null);
        }
        return map;
    }

    public void start(Stage primaryStage) throws Exception {
        block16: {
            String debugPort = null;
            String outputRedirect = null;
            if (this.getDefaultString() != null && !this.getDefaultString().equalsIgnoreCase(System.getProperty("file.encoding"))) {
                System.setProperty("file.encoding", this.getDefaultString());
                Class<Charset> c = Charset.class;
                Field defaultCharsetField = c.getDeclaredField("defaultCharset");
                defaultCharsetField.setAccessible(true);
                defaultCharsetField.set(null, null);
            }
            SimpleKeyValueList<String, String> params = this.getParameterMap();
            for (int i = 0; i < params.size(); ++i) {
                String key = (String)params.get(i);
                String value = params.getValueByIndex(i);
                if (key.equalsIgnoreCase("debug")) {
                    if (value != null) {
                        debugPort = value;
                        continue;
                    }
                    debugPort = "4223";
                    continue;
                }
                if (key.equalsIgnoreCase("output")) {
                    if (value == null) {
                        outputRedirect = "INHERIT";
                        continue;
                    }
                    outputRedirect = value;
                    continue;
                }
                if (!key.equalsIgnoreCase("-?")) continue;
                System.out.println(this.getCommandHelp());
                Runtime.getRuntime().exit(1);
            }
            if (debugPort != null) {
                ArrayList<String> items = new ArrayList<String>();
                if (new Os().isMac()) {
                    items.add(System.getProperty("java.home").replace("\\", "/") + "/bin/java");
                } else {
                    items.add("\"" + System.getProperty("java.home").replace("\\", "/") + "/bin/java\"");
                }
                items.add("-Xdebug");
                items.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=" + debugPort);
                items.add("-jar");
                String fileName = new Os().getFilename().toLowerCase();
                items.add(fileName);
                ProcessBuilder processBuilder = new ProcessBuilder(items);
                if (outputRedirect != null) {
                    if (outputRedirect.equalsIgnoreCase("inherit")) {
                        processBuilder.redirectErrorStream(true);
                        processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                    } else {
                        int pos = outputRedirect.lastIndexOf(".");
                        if (pos > 0) {
                            processBuilder.redirectError(new File(outputRedirect.substring(0, pos) + "_error" + outputRedirect.substring(pos)));
                            processBuilder.redirectOutput(new File(outputRedirect.substring(0, pos) + "_stdout" + outputRedirect.substring(pos)));
                        } else {
                            processBuilder.redirectError(new File(outputRedirect + "_error.txt"));
                            processBuilder.redirectOutput(new File(outputRedirect + "_stdout.txt"));
                        }
                    }
                }
                processBuilder.start();
                Runtime.getRuntime().exit(1);
            }
            try {
                this.controller = new FXStageController(primaryStage);
                Parent pane = this.createContents(this.controller, this.getParameters());
                this.controller.withCenter((Node)pane);
                this.controller.show();
            }
            catch (Exception e) {
                this.saveException(e, new Object[0]);
                if (!new Os().isEclipse()) break block16;
                throw e;
            }
        }
    }

    protected String getCommandHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("Help for the Commandline - ");
        sb.append(this.getCaption());
        sb.append("\n\n");
        sb.append("Debug\t\tDebug with <port> for debugging. Default is 4223\n");
        sb.append("Output\t\tOutput the debug output in standard-outputstream or file\n");
        return sb.toString();
    }

    protected String getDefaultString() {
        return "UTF-8";
    }

    public SimpleShell withIcon(String value) {
        this.controller.withIcon(value);
        this.icon = value;
        return this;
    }

    public SimpleShell withIcon(URL value) {
        this.withIcon(value.toString());
        return this;
    }

    public SimpleShell withTitle(String value) {
        this.controller.withTitle(value);
        return this;
    }

    public static boolean checkSystemTray() {
        return SystemTray.isSupported();
    }

    public void saveException(Throwable e, Object ... extra) {
        if (this.errorPath == null) {
            return;
        }
        GregorianCalendar temp = new GregorianCalendar();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String prefixName = formatter.format(temp.getTime()) + "_";
        this.writeErrorFile(prefixName + "error.txt", e, extra);
        this.writeModel(prefixName);
        this.controller.saveScreenShoot(this.errorPath + prefixName + "Full.jpg", this.errorPath + prefixName + "App.jpg");
    }

    protected void writeModel(String prefixName) {
    }

    protected boolean writeErrorFile(String fileName, Throwable e, Object ... extras) {
        boolean success;
        try {
            String fullfilename;
            File file;
            this.errorPath = this.createDir(this.errorPath);
            if (this.errorPath == null) {
                this.errorPath = "";
            }
            if (!this.errorPath.endsWith("/")) {
                this.errorPath = this.errorPath + "/";
            }
            if (!(file = new File(fullfilename = this.errorPath + fileName)).exists() && !file.createNewFile()) {
                return false;
            }
            FileOutputStream networkFile = new FileOutputStream(this.errorPath + "/" + fileName);
            OutputStreamWriter ps = new OutputStreamWriter((OutputStream)networkFile, "UTF-8");
            PrintWriter pw = new PrintWriter(ps);
            pw.println("Error: " + e.getMessage());
            if (extras != null) {
                StringBuilder sb = new StringBuilder();
                for (Object item : extras) {
                    if (item == null) continue;
                    sb.append(item.toString() + ", ");
                }
                pw.println("Extra: " + sb.toString());
            }
            pw.println("Thread: " + Thread.currentThread().getName());
            pw.println("------------ SYSTEM-INFO ------------");
            this.printProperty(pw, "java.class.version");
            this.printProperty(pw, "java.runtime.version");
            this.printProperty(pw, "java.specification.version");
            this.printProperty(pw, "java.version");
            this.printProperty(pw, "os.arch");
            this.printProperty(pw, "os.name");
            this.printProperty(pw, "os.version");
            this.printProperty(pw, "user.dir");
            this.printProperty(pw, "user.home");
            this.printProperty(pw, "user.language");
            this.printProperty(pw, "user.name");
            this.printProperty(pw, "user.timezone");
            pw.println("");
            Runtime r = Runtime.getRuntime();
            pw.println("Prozessoren :\t   " + r.availableProcessors());
            pw.println("Freier Speicher JVM:\t" + r.freeMemory());
            pw.println("Maximaler Speicher JVM: " + r.maxMemory());
            pw.println("Gesamter Speicher JVM:  " + r.totalMemory());
            pw.println("Gesamter Speicher Java:  " + ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalSwapSpaceSize());
            pw.println("***  ***");
            pw.println();
            e.printStackTrace(pw);
            ps.close();
            success = true;
        }
        catch (FileNotFoundException exception) {
            success = false;
        }
        catch (IOException exception) {
            success = false;
        }
        return success;
    }

    protected String createDir(String path) {
        File dirPath = new File(path);
        if (!(dirPath = new File(dirPath.getPath())).exists()) {
            if (dirPath.mkdirs()) {
                return path;
            }
        } else {
            return path;
        }
        return null;
    }

    private void printProperty(PrintWriter ps, String property) {
        ps.println(property + ": " + System.getProperty(property));
    }

    protected String getCaptionPrefix() {
        return null;
    }

    public String getCaption() {
        String caption = "";
        String temp = this.getCaptionPrefix();
        if (temp != null) {
            caption = temp + " ";
        }
        return caption + this.getVersion() + " (" + System.getProperty("file.encoding") + " - " + System.getProperty("sun.arch.data.model") + "-Bit)";
    }

    protected SimpleShell enableError(String path) {
        this.errorPath = path;
        if (Thread.getDefaultUncaughtExceptionHandler() == null) {
            Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    SimpleShell.this.saveException(e, new Object[0]);
                }
            });
            Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    SimpleShell.this.saveException(e, new Object[0]);
                }
            });
        }
        return this;
    }

    protected String getVersion() {
        String result = SimpleShell.class.getPackage().getImplementationVersion();
        if (result == null) {
            result = "0.42.DEBUG";
        }
        return result;
    }
}

