/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleObject;
import de.uniks.networkparser.ext.generic.ReflectionLoader;
import de.uniks.networkparser.ext.io.FileBuffer;
import de.uniks.networkparser.ext.javafx.EventFX;
import de.uniks.networkparser.ext.javafx.JsonObjectLazy;
import de.uniks.networkparser.gui.BridgeCommand;
import de.uniks.networkparser.gui.EventTypes;
import de.uniks.networkparser.gui.JavaBridge;
import de.uniks.networkparser.gui.JavaViewAdapter;
import de.uniks.networkparser.gui.StateListener;
import de.uniks.networkparser.gui.controls.Control;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.xml.HTMLEntity;
import de.uniks.networkparser.xml.XMLEntity;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSObject;

public class JavaAdapter
implements JavaViewAdapter {
    private SimpleKeyValueList<Object, String> callBack = new SimpleKeyValueList();
    private JavaBridge owner;
    private Object webView;
    private Object engine;
    private SimpleList<String> queue = new SimpleList();

    public JavaAdapter() {
        this.webView = ReflectionLoader.newInstance(ReflectionLoader.WEBVIEW);
        this.engine = ReflectionLoader.call("getEngine", this.webView, new Object[0]);
        ReflectionLoader.call("setMaxSize", this.webView, Double.TYPE, Double.MAX_VALUE, Double.TYPE, Double.MAX_VALUE);
    }

    @Override
    public JavaAdapter withOwner(JavaBridge owner) {
        this.owner = owner;
        return this;
    }

    @Override
    public boolean load(HTMLEntity entity) {
        XMLEntity headers = entity.getHeaders();
        for (int i = 0; i < headers.sizeChildren(); ++i) {
            XMLEntity child = (XMLEntity)headers.getChild(i);
            if (!"script".equalsIgnoreCase(child.getTag())) continue;
            Object value = child.getValue("src");
            if (value != null) {
                this._execute(this.readFile("" + value));
                continue;
            }
            this._execute(child.getValue());
        }
        XMLEntity body = entity.getHeaders();
        for (int i = 0; i < body.sizeChildren(); ++i) {
            XMLEntity child = (XMLEntity)body.getChild(i);
            if (!"script".equalsIgnoreCase(child.getTag()) || child.has("src")) continue;
            this._execute(child.getValue());
        }
        Object loader = ReflectionLoader.call("getLoadWorker", this.engine, new Object[0]);
        Object stateProperty = ReflectionLoader.call("stateProperty", loader, new Object[0]);
        Object changeProxy = ReflectionLoader.createProxy(new StateListener(this), ReflectionLoader.CHANGELISTENER);
        ReflectionLoader.call("addListener", stateProperty, ReflectionLoader.CHANGELISTENER, changeProxy);
        ReflectionLoader.call("loadContent", this.engine, String.class, entity.toString());
        ((WebEngine)this.engine).setOnAlert(t -> System.out.println((String)t.getData()));
        ((WebEngine)this.engine).setOnError(e -> System.err.println(e));
        return true;
    }

    public boolean executeChange(String value) {
        this.owner.setApplyingChangeMSG(true);
        JsonObject json = JsonObject.create(value);
        IdMap map = this.owner.getMap();
        Object encode = map.decode(json);
        if (encode == null) {
            SimpleObject newItem = SimpleObject.create(json);
            map.put(newItem.getId(), newItem, false);
        }
        this.owner.setApplyingChangeMSG(false);
        return true;
    }

    @Override
    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            JsonObject data = new JsonObject().withValue("" + value);
            this.owner.fireEvent(data);
            return true;
        }
        if (ReflectionLoader.JSOBJECT.isAssignableFrom(value.getClass())) {
            EventFX event = EventFX.create((JSObject)value);
            this.owner.fireEvent(event);
            return true;
        }
        return false;
    }

    @Override
    public String readFile(String file) {
        FileBuffer buffer = new FileBuffer().withFile(file);
        return buffer.toString();
    }

    @Override
    public Object executeScript(String script) {
        this.owner.logScript(script, "INFO", this, "executeScript");
        if (this.queue != null) {
            this.queue.add(script);
        }
        return this._execute(script);
    }

    private Object _execute(String script) {
        System.out.println(script);
        Object jsObject = ReflectionLoader.call("executeScript", this.engine, String.class, script);
        if (jsObject != null && ReflectionLoader.JSOBJECT.isAssignableFrom(jsObject.getClass())) {
            JsonObject item = this.convertJSObject(jsObject);
            return item;
        }
        return jsObject;
    }

    private JsonObject convertJSObject(Object element) {
        JsonObjectLazy result = new JsonObjectLazy(element);
        result.lazyLoad();
        return result;
    }

    @Override
    public Object getWebView() {
        return this.webView;
    }

    protected void addAdapter(ObjectCondition eventListener) {
        JsonObjectLazy executeScript = (JsonObjectLazy)this._execute("bridge.addAdapter(new DiagramJS.DelegateAdapter());");
        JSObject reference = executeScript.getReference();
        reference.call("setAdapter", eventListener);
    }

    @Override
    public void loadFinish() {
        this.addAdapter(this);
        while (this.queue.size() > 0) {
            String command = (String)this.queue.remove(0);
            this._execute(command);
        }
        this.queue = null;
    }

    public boolean addListener(Control control, EventTypes type, String functionName, Object callBackClazz) {
        this.owner.addControl(control);
        String id = control.getId();
        if (callBackClazz != null) {
            String callBackName = this.getCallBackName(callBackClazz);
            this.executeScript(BridgeCommand.register(type, id, callBackName + "." + functionName));
            return true;
        }
        this.executeScript("bridge.registerListener(" + (Object)((Object)type) + ", \"" + id + "\");");
        return true;
    }

    public String getCallBackName(Object clazz) {
        String callBackName = this.callBack.get(clazz);
        Object window = this._execute("window");
        if (callBackName == null) {
            callBackName = "_callBack" + (this.callBack.size() + 1);
            this.callBack.put(clazz, callBackName);
            ReflectionLoader.call("setMember", window, String.class, callBackName, Object.class, clazz);
            System.out.println("regiter: " + clazz);
        }
        return callBackName;
    }
}

