/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.javafx;

import de.uniks.networkparser.ext.javafx.AWTContainer;
import de.uniks.networkparser.ext.javafx.CustomPane;
import de.uniks.networkparser.ext.javafx.SimpleController;
import de.uniks.networkparser.ext.javafx.StageEvent;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilderFactory;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.BuilderFactory;
import javax.imageio.ImageIO;

public class FXStageController
implements StageEvent,
EventHandler<KeyEvent> {
    protected Stage stage;
    private Scene scene;
    private Object controller;
    protected Region pane;
    private boolean wait;
    private AWTContainer awtContainer;

    public FXStageController() {
    }

    public FXStageController(Stage newStage) {
        this.withStage(newStage);
        this.withPane((Region)new BorderPane());
    }

    public Stage getStage() {
        if (this.stage == null) {
            this.withStage(new Stage());
        }
        return this.stage;
    }

    public FXStageController withStage(Stage value) {
        this.stage = value;
        if (value != null) {
            this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    FXStageController.this.stageClosing(we, FXStageController.this.stage, FXStageController.this);
                }
            });
            this.stage.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent we) {
                    FXStageController.this.stageShowing(we, FXStageController.this.stage, FXStageController.this);
                }
            });
        }
        return this;
    }

    @Override
    public void stageClosing(WindowEvent event, Stage stage, FXStageController controller) {
        if (this.pane instanceof StageEvent) {
            ((StageEvent)this.pane).stageClosing(event, stage, controller);
        }
        if (this.controller instanceof StageEvent) {
            ((StageEvent)this.controller).stageClosing(event, stage, controller);
        }
    }

    @Override
    public void stageShowing(WindowEvent event, Stage stage, FXStageController controller) {
        if (this.pane instanceof StageEvent) {
            ((StageEvent)this.pane).stageShowing(event, stage, controller);
        }
        if (this.controller instanceof StageEvent) {
            ((StageEvent)this.controller).stageShowing(event, stage, controller);
        }
    }

    public Scene getScene() {
        return this.scene;
    }

    public Object getController() {
        return this.controller;
    }

    public FXStageController withController(Object value) {
        this.controller = value;
        return this;
    }

    public boolean close() {
        WindowEvent event = new WindowEvent((Window)this.stage, WindowEvent.WINDOW_CLOSE_REQUEST);
        this.stageClosing(event, this.stage, this);
        if (!event.isConsumed()) {
            this.stage.close();
            return true;
        }
        return false;
    }

    public void show(Stage stage) {
        this.withStage(stage);
        this.showing();
    }

    protected void showing() {
        if (this.pane == null) {
            return;
        }
        if (this.wait && this.stage.getOwner() != null) {
            this.stage.showAndWait();
        } else {
            this.stage.show();
        }
    }

    public void show() {
        this.showing();
    }

    public Exception saveScreenShoot(String fullScreenFileName, String windowScreenFileName) {
        try {
            BufferedImage bi;
            if (fullScreenFileName != null) {
                bi = new Robot().createScreenCapture(new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
                ImageIO.write((RenderedImage)bi, "jpg", new File(fullScreenFileName));
            }
            if (windowScreenFileName != null) {
                bi = new Robot().createScreenCapture(new Rectangle(Double.valueOf(this.stage.getX()).intValue(), Double.valueOf(this.stage.getY()).intValue(), Double.valueOf(this.stage.getWidth()).intValue(), Double.valueOf(this.stage.getHeight()).intValue()));
                ImageIO.write((RenderedImage)bi, "jpg", new File(windowScreenFileName));
            }
        }
        catch (Exception e1) {
            return e1;
        }
        return null;
    }

    public FXStageController withTitle(String value) {
        this.getStage().setTitle(value);
        return this;
    }

    public FXStageController withIcon(String value) {
        if (this.stage != null && value != null) {
            if (value.startsWith("file") || value.startsWith("jar")) {
                this.stage.getIcons().add((Object)new Image(value));
            } else {
                this.stage.getIcons().add((Object)new Image("file:" + value));
            }
        }
        return this;
    }

    public boolean isWait() {
        return this.wait;
    }

    public FXStageController withWait(boolean value) {
        this.wait = value;
        return this;
    }

    public BorderPane createBorderPane() {
        BorderPane value = new BorderPane();
        this.withPane((Region)value);
        return value;
    }

    public GridPane createGridPane() {
        GridPane value = new GridPane();
        this.withPane((Region)value);
        return value;
    }

    public Node getElementById(String id) {
        if (this.pane != null) {
            return this.pane.lookup(id);
        }
        return null;
    }

    public FXStageController withFXML(String fxmlFile) {
        this.create(FXStageController.class.getResource(fxmlFile), null);
        return this;
    }

    public FXStageController withFXML(URL urlfxmlFile) {
        this.create(urlfxmlFile, null);
        return this;
    }

    public Region create(String fxmlFile) {
        return this.create(FXStageController.class.getResource(fxmlFile), null);
    }

    public Region create(URL location, ResourceBundle resources) {
        if (location == null) {
            System.out.println("FXML not found");
            return null;
        }
        FXMLLoader fxmlLoader = resources != null ? new FXMLLoader(location, resources, (BuilderFactory)new JavaFXBuilderFactory()) : new FXMLLoader(location);
        try {
            this.withPane((Region)fxmlLoader.load(location.openStream()));
        }
        catch (IOException e) {
            System.err.println("FXML Load Error:" + e.getMessage());
            System.err.println("FXML Load Error:" + e.getCause());
            return null;
        }
        this.withController(fxmlLoader.getController());
        return this.pane;
    }

    public Region getPane() {
        return this.pane;
    }

    public FXStageController withCenter(Node value) {
        if (this.pane instanceof BorderPane) {
            ((BorderPane)this.pane).setCenter(value);
        }
        return this;
    }

    public Stage showNewStage(String fxml, Class<?> path) {
        this.loadNewStage(fxml, path);
        this.show();
        return this.stage;
    }

    public Stage showNewStage(String fxml, Class<?> path, Object extraDatapath) {
        this.showNewStage(fxml, path);
        Object controllerNew = this.getController();
        if (controllerNew instanceof SimpleController) {
            ((SimpleController)controllerNew).init(extraDatapath);
        }
        return this.stage;
    }

    public Stage loadNewStage(String fxml, Class<?> path) {
        Stage oldStage = this.getStage();
        this.withStage(new Stage());
        URL location = path == null ? this.getClass().getResource(fxml) : path.getResource(fxml);
        if (location != null) {
            FXMLLoader fxmlLoader = new FXMLLoader(location);
            Pane value = null;
            try {
                value = (Pane)fxmlLoader.load(location.openStream());
            }
            catch (IOException e) {
                System.out.println("FXML Load Error:" + e.getMessage());
                return null;
            }
            this.withPane((Region)value);
            this.withController(fxmlLoader.getController());
            if (value instanceof StageEvent) {
                Stage myStage = this.getStage();
                ((StageEvent)value).stageShowing(new WindowEvent((Window)myStage, WindowEvent.WINDOW_SHOWING), myStage, this);
            }
        }
        oldStage.close();
        return this.getStage();
    }

    public Stage showNewStage(Node value) {
        Stage oldStage = this.stage;
        this.withStage(new Stage());
        Object newPane = value instanceof Pane ? (Pane)value : new CustomPane(value);
        this.withPane((Region)newPane);
        if (value instanceof StageEvent) {
            Stage myStage = this.getStage();
            ((StageEvent)value).stageShowing(new WindowEvent((Window)myStage, WindowEvent.WINDOW_SHOWING), myStage, this);
        }
        this.show();
        this.close(oldStage);
        return this.stage;
    }

    private void close(Stage oldStage) {
        if (oldStage != null) {
            oldStage.close();
        }
        if (this.awtContainer != null) {
            this.awtContainer.exit();
        }
    }

    public Stage showNewView(StageEvent value) {
        if (value instanceof Node) {
            return this.showNewStage((Node)value);
        }
        Stage myStage = this.getStage();
        value.stageShowing(new WindowEvent((Window)myStage, WindowEvent.WINDOW_SHOWING), myStage, this);
        Stage oldStage = this.stage;
        this.withPane(null);
        this.withStage(null);
        this.close(oldStage);
        this.awtContainer = new AWTContainer(value);
        Platform.runLater((Runnable)this.awtContainer);
        return this.stage;
    }

    public FXStageController withPane(Region value) {
        this.pane = value;
        if (value != null) {
            this.pane.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)this);
            this.scene = new Scene((Parent)this.pane);
            this.stage.setScene(this.scene);
        } else {
            this.scene = null;
        }
        return this;
    }

    public FXStageController withSize(int width, int height) {
        this.getStage().setWidth((double)width);
        this.getStage().setHeight((double)height);
        return this;
    }

    public static FXStageController load(String fxml) {
        return new FXStageController().withFXML(fxml);
    }

    public static FXStageController load(String fxml, Class<?> path) {
        return new FXStageController().withFXML(path.getResource(fxml));
    }

    public static FXStageController show(Stage stage, String fxml, Class<?> path) {
        FXStageController controller = new FXStageController().withStage(stage).withFXML(path.getResource(fxml));
        controller.show();
        return controller;
    }

    public boolean replaceNode(Node oldNode, Node newNode) {
        Node child;
        if (oldNode == null || newNode == null) {
            return false;
        }
        Parent parent = oldNode.getParent();
        ObservableList childrenUnmodifiable = parent.getChildrenUnmodifiable();
        int pos = 0;
        Iterator iterator = childrenUnmodifiable.iterator();
        while (iterator.hasNext() && (child = (Node)iterator.next()) != oldNode) {
            ++pos;
        }
        if (parent instanceof Pane) {
            if (oldNode instanceof Region && newNode instanceof Region) {
                Region oldRegion = (Region)oldNode;
                Region newRegion = (Region)newNode;
                newRegion.setPrefWidth(oldRegion.getPrefWidth());
                newRegion.setPrefHeight(oldRegion.getPrefHeight());
            }
            Pane pane = (Pane)parent;
            pane.getChildren().remove(pos);
            pane.getChildren().add(pos, (Object)newNode);
            return true;
        }
        return false;
    }

    public void withIcon(URL resource) {
        if (resource != null) {
            this.withIcon(resource.toString());
        }
    }

    public void handle(KeyEvent event) {
    }
}

