/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext.io;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.parser.excel.ExcelParser;
import de.uniks.networkparser.parser.excel.ExcelSheet;
import de.uniks.networkparser.parser.excel.ExcelWorkBook;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ExcelBuffer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcelSheet parse(File file) {
        ExcelSheet data = null;
        ZipFile zipEntry = null;
        try {
            InputStream inputStream;
            CharacterBuffer sharedStrings = null;
            CharacterBuffer sheetData = null;
            zipEntry = new ZipFile(file);
            ZipEntry entry = zipEntry.getEntry("xl/sharedStrings.xml");
            if (entry != null) {
                inputStream = zipEntry.getInputStream(entry);
                sharedStrings = this.readContext(inputStream);
                inputStream.close();
            }
            if ((entry = zipEntry.getEntry("xl/worksheets/sheet1.xml")) != null) {
                inputStream = zipEntry.getInputStream(entry);
                sheetData = this.readContext(inputStream);
                inputStream.close();
            }
            zipEntry.close();
            zipEntry = null;
            if (sheetData == null) {
                sheetData = new CharacterBuffer();
            }
            data = new ExcelParser().parseSheet(sharedStrings, sheetData);
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipEntry != null) {
                try {
                    zipEntry.close();
                }
                catch (IOException iOException) {}
            }
        }
        return data;
    }

    private CharacterBuffer readContext(InputStream is) {
        char[] buffer = new char[1024];
        CharacterBuffer out = new CharacterBuffer();
        try {
            int rsz;
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                out.with(buffer, 0, rsz);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean encode(File file, ExcelWorkBook workbook) {
        boolean result = false;
        ZipOutputStream zos = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            zos = new ZipOutputStream(fos);
            ExcelParser excelParser = new ExcelParser();
            SimpleKeyValueList<String, String> content = excelParser.createExcelContent(workbook);
            for (Map.Entry<String, String> entry : content.entrySet()) {
                ZipEntry zipEntry = new ZipEntry(entry.getKey());
                zos.putNextEntry(zipEntry);
                byte[] values = entry.getValue().getBytes("UTF-8");
                zos.write(values, 0, values.length);
                zos.closeEntry();
            }
            zos.close();
            result = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (zos != null) {
                try {
                    zos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public void addToZipFile(String fileName, String content, ZipOutputStream zos) throws FileNotFoundException, IOException {
        ZipEntry zipEntry = new ZipEntry(fileName);
        zos.putNextEntry(zipEntry);
        byte[] bytes = content.getBytes("UTF-8");
        zos.write(bytes, 0, bytes.length);
        zos.closeEntry();
    }
}

