/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.ext;

import de.uniks.networkparser.buffer.CharacterBuffer;
import de.uniks.networkparser.buffer.Tokener;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.io.IOException;
import java.io.InputStream;

public class Manifest
extends SimpleKeyValueList<String, String> {
    public static char SPLITTER = (char)58;
    public static char[] CRLF = new char[]{'\r', '\n'};
    public static final String VERSION = "Implementation-Version";
    public static final String TITLE = "Specification-Title";
    public static final String BUILD = "Built-Time";
    public static final String HASH = "Hash";
    public static final String LICENCE = "Licence";
    public static final String HOMEPAGE = "Homepage";
    public static final String COVERAGE = "Coverage";
    private boolean empty = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest create() {
        String value = null;
        InputStream resources = Manifest.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");
        try {
            int len = resources.available();
            byte[] bytes = new byte[len];
            int read = resources.read(bytes, 0, len);
            value = new String(bytes, 0, read);
        }
        catch (IOException iOException) {
        }
        finally {
            if (resources != null) {
                try {
                    resources.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Manifest.create(value);
    }

    public static void printVersion() {
        Manifest manifest = Manifest.create();
        if (!manifest.isEmptyManifest()) {
            System.out.println("Title: " + manifest.getString(TITLE));
            System.out.println("Version: " + manifest.getString(VERSION));
            System.out.println("Time: " + manifest.getString(BUILD));
            System.out.println("Hash: " + manifest.getString(HASH));
            System.out.println("Licence: " + manifest.getString(LICENCE));
            System.out.println("Homepage: " + manifest.getString(HOMEPAGE));
            System.out.println("Coverage: " + manifest.getString(COVERAGE));
        }
    }

    public static Manifest create(CharSequence value) {
        Manifest manifest = new Manifest();
        Tokener tokener = new Tokener().withBuffer(value);
        while (!tokener.isEnd()) {
            CharacterBuffer section = tokener.nextToken(true, SPLITTER);
            CharacterBuffer sectionheader = tokener.nextToken(false, CRLF);
            boolean isCoverage = section.toString().equals(COVERAGE);
            tokener.skip();
            while (tokener.getCurrentChar() == ' ' || tokener.getCurrentChar() == '\t') {
                CharacterBuffer newLine = tokener.nextToken(true, CRLF);
                if (isCoverage) {
                    sectionheader.trim().with(newLine);
                } else {
                    sectionheader.with(newLine);
                }
                tokener.skip();
            }
            String key = section.toString();
            manifest.add(key, sectionheader.trim().toString());
        }
        manifest.empty = !manifest.containsAll(VERSION, TITLE, BUILD);
        return manifest;
    }

    public boolean isEmptyManifest() {
        return this.empty;
    }
}

