/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.bytes;

import de.uniks.networkparser.buffer.ByteBuffer;
import de.uniks.networkparser.bytes.BitEntity;
import de.uniks.networkparser.bytes.BitEntityCreator;
import de.uniks.networkparser.bytes.BitValue;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.util.ArrayList;

public class ByteParser {
    public Object decode(ByteBuffer buffer, BitEntityCreator creator) {
        SimpleKeyValueList<String, Object> values = new SimpleKeyValueList<String, Object>();
        BitEntity[] bitProperties = creator.getBitProperties();
        Object newInstance = creator.getSendableInstance(false);
        for (BitEntity entity : bitProperties) {
            Object element = this.getEntity(buffer, entity, values);
            if (element == null) continue;
            creator.setValue(newInstance, entity.getPropertyName(), element, "new");
        }
        return newInstance;
    }

    public Object getEntity(ByteBuffer buffer, BitEntity entry, SimpleKeyValueList<String, Object> values) {
        if (entry.size() < 1) {
            if (entry.isType(82)) {
                String propertyName = entry.getPropertyName();
                if (values.containsKey(propertyName)) {
                    return values.getValue(propertyName);
                }
            } else if (entry.isType(66, 78, 83)) {
                return entry.getPropertyName();
            }
        }
        ArrayList<ByteBuffer> results = new ArrayList<ByteBuffer>();
        ArrayList<Integer> resultsLength = new ArrayList<Integer>();
        for (Object bitValue : entry) {
            int orientationSource = ((BitValue)bitValue).getOrientation();
            int orientationTarget = entry.getOrientation();
            BitEntity bit = (BitEntity)new BitEntity().with(((BitValue)bitValue).getStart());
            int temp = Integer.parseInt("" + this.getEntity(buffer, bit, values));
            int posOfByte = temp / 8;
            int posOfBit = (8 - (temp + 1) % 8) % 8;
            bit = (BitEntity)new BitEntity().with(((BitValue)bitValue).size());
            bit.with(((BitValue)bitValue).getProperty(), ((BitValue)bitValue).getType());
            int length = Integer.parseInt("" + this.getEntity(buffer, bit, values));
            int noOfByte = length / 8;
            if (length % 8 > 0) {
                ++noOfByte;
            }
            resultsLength.add(length);
            ByteBuffer result = ByteBuffer.allocate(noOfByte);
            int theByte = buffer.byteAt(posOfByte);
            if (theByte < 0) {
                theByte += 256;
            }
            int resultPos = 0;
            int number = 0;
            int sourceBit = length < 8 - resultPos ? length : 8 - resultPos;
            theByte >>= posOfBit - sourceBit + 1;
            while (length > 0) {
                int z;
                sourceBit = length < 8 - resultPos ? length : 8 - resultPos;
                int sourceBits = theByte & 255 >> 8 - sourceBit;
                if (orientationTarget > 0) {
                    number <<= sourceBit;
                    if (orientationSource > 0) {
                        number += sourceBits;
                    } else {
                        for (z = sourceBit; z > 0; --z) {
                            number += sourceBits & 1 << sourceBit << sourceBit - z;
                        }
                    }
                } else if (orientationSource > 0) {
                    number += sourceBits << sourceBit;
                } else {
                    for (z = sourceBit; z > 0; --z) {
                        number += sourceBits & 1 << sourceBit << sourceBit - z;
                    }
                }
                theByte = (byte)(theByte >> sourceBit);
                length -= sourceBit;
                if ((resultPos += sourceBit) != 8) continue;
                result.put((byte)number);
                resultPos = 0;
                number = 0;
                if (length <= 0 || (theByte = (int)buffer.byteAt(posOfByte)) >= 0) continue;
                theByte += 256;
            }
            if (resultPos > 0) {
                result.put((byte)number);
            }
            result.flip(true);
            results.add(result);
        }
        int length = 0;
        for (Integer item : resultsLength) {
            length += item.intValue();
        }
        int number = length / 8 + (length % 8 > 0 ? 1 : 0);
        ByteBuffer result = new ByteBuffer();
        result.withBufferLength(number);
        int resultPos = 0;
        number = 0;
        for (int i = 0; i < results.size(); ++i) {
            int sourceBit;
            ByteBuffer source = (ByteBuffer)results.get(i);
            for (length = ((Integer)resultsLength.get(i)).intValue(); length > 0; length -= sourceBit) {
                byte theByte = source.getByte();
                sourceBit = length < 8 - resultPos ? length : 8 - resultPos;
                number = (number << sourceBit) + (theByte & 255 >> 8 - sourceBit);
                theByte = (byte)(theByte >> sourceBit);
                if ((resultPos += sourceBit) != 8) continue;
                result.put((byte)number);
                resultPos = 0;
                number = 0;
                if (length <= 0) continue;
                theByte = source.getByte();
            }
        }
        if (resultPos > 0) {
            result.put((byte)number);
        }
        result.flip(true);
        Object element = null;
        if (entry.getType() == 66) {
            byte[] array = result.array();
            if (array.length == 1) {
                element = array[0];
            } else {
                Byte[] item = new Byte[array.length];
                for (int i = 0; i < array.length; ++i) {
                    item[i] = array[i];
                }
                element = item;
            }
        } else if (entry.getType() == 78) {
            element = result.length() == 1 ? (Number)result.getByte() : (Number)(result.length() == 2 ? (Number)result.getShort() : (Number)(result.length() == 4 ? (Number)result.getInt() : (Number)(result.length() == 8 ? (Number)result.getLong() : (Number)(result.length() == 4 ? (Number)Float.valueOf(result.getFloat()) : (Number)(result.length() == 8 ? (Number)result.getDouble() : (Number)result.getInt())))));
        } else if (entry.getType() == 83) {
            result.flip(false);
            element = String.valueOf(result.array());
        }
        values.put(entry.getPropertyName(), element);
        return element;
    }
}

