/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.ByteBuffer;
import java.math.BigInteger;

public class DERBuffer
extends ByteBuffer {
    public static final byte ARRAY = 0;
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte BITSTRING = 3;
    public static final byte OCTETSTRING = 4;
    public static final byte NULL = 5;
    public static final byte OBJECTID = 6;
    public static final byte ENUMERATED = 10;
    public static final byte UTF8STRING = 12;
    public static final byte PRINTABLESTRING = 19;
    public static final byte T61STRING = 20;
    public static final byte IA5STRING = 22;
    public static final byte UTCTIME = 23;
    public static final byte GENERALIZEDTIME = 24;
    public static final byte GENERALSTRING = 27;
    public static final byte UNIVERSALSTRING = 28;
    public static final byte BMPSTRING = 30;

    public void add(BigInteger paramBigInteger) {
        byte[] arrayOfByte = paramBigInteger.toByteArray();
        this.add(arrayOfByte);
        this.addBigIntegerLength(arrayOfByte.length);
        this.add((byte)2);
    }

    public void addBitString(String string) {
        byte[] bytes = string.getBytes();
        this.add(bytes);
        this.addLength(bytes.length);
        this.add((byte)3);
    }

    public void addBigIntegerLength(int length) {
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            this.add((byte)(size | 0x80));
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                this.add((byte)(length >> i));
            }
        } else {
            this.add((byte)length);
        }
    }

    public void addLength(int value) {
        if (value < 128) {
            this.add((byte)value);
        } else if (value < 256) {
            this.add((byte)value);
            this.add(-127);
        } else if (value < 65536) {
            this.add((byte)value);
            this.add((byte)(value >> 8));
            this.add(-126);
        } else if (value < 0x1000000) {
            this.add((byte)value);
            this.add((byte)(value >> 8));
            this.add((byte)(value >> 16));
            this.add(-125);
        } else {
            this.add((byte)value);
            this.add((byte)(value >> 8));
            this.add((byte)(value >> 16));
            this.add((byte)(value >> 24));
            this.add(-124);
        }
    }

    public boolean addGroup(Object ... values) {
        if (values == null || values.length < 1) {
            return false;
        }
        for (int z = values.length - 1; z >= 0; --z) {
            int pos;
            Object item = values[z];
            if (item instanceof String) {
                this.addBitString((String)item);
                continue;
            }
            if (item instanceof Byte[]) {
                pos = this.length;
                this.add((Byte[])item);
                if ((Byte)values[--z] == 3) {
                    this.add(0);
                }
                if (pos == 0) {
                    this.addLength(this.length);
                } else {
                    this.addLength(this.length - pos);
                }
                this.add((Byte)values[z]);
                continue;
            }
            if (item instanceof Object[]) {
                pos = this.length;
                this.addGroup((Object[])item);
                if (pos == 0) {
                    this.addLength(this.length);
                } else {
                    this.addLength(this.length - pos);
                }
                this.add((Byte)values[--z]);
                continue;
            }
            if (item instanceof BigInteger) {
                this.add((BigInteger)item);
                continue;
            }
            if (!(item instanceof Byte)) continue;
            if (item.equals((byte)5)) {
                this.add((byte)0);
                this.add((byte)5);
                continue;
            }
            this.add((Byte)item);
        }
        return true;
    }

    @Override
    protected boolean addBytes(Object bytes, int len) {
        if (bytes != null) {
            this.position -= len;
            this.start = this.position;
            return super.addBytes(bytes, len);
        }
        return false;
    }
}

