/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.json;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.SimpleEvent;
import de.uniks.networkparser.UpdateCondition;
import de.uniks.networkparser.interfaces.Entity;
import de.uniks.networkparser.interfaces.Grammar;
import de.uniks.networkparser.interfaces.MapListener;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.list.SimpleIteratorSet;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class UpdateJson
implements MapListener {
    private IdMap map;
    private ArrayList<String> suspendIdList;
    private Filter updateFilter = new Filter().withStrategy("upd").withConvertable(new UpdateCondition());

    public UpdateJson(IdMap map) {
        this.map = map;
    }

    @Override
    public boolean suspendNotification() {
        this.suspendIdList = new ArrayList();
        return true;
    }

    @Override
    public boolean resumeNotification() {
        JsonArray array = this.map.getJsonByIds(this.suspendIdList);
        if (array.size() > 0) {
            JsonObject message = new JsonObject();
            message.put("upd", array);
            this.map.notify(new SimpleEvent("new", message, this.map, null, null, null));
        }
        this.suspendIdList = null;
        return true;
    }

    @Override
    public boolean resetNotification() {
        this.suspendIdList = null;
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JsonObject child;
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
            return;
        }
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        SendableEntityCreator creatorClass = this.map.getCreatorClass(source);
        if (creatorClass == null) {
            return;
        }
        boolean done = false;
        for (String attrName : creatorClass.getProperties()) {
            if (!attrName.equals(propertyName)) continue;
            done = true;
            break;
        }
        if (!done) {
            if ("REMOVE_YOU".equals(propertyName)) {
                this.removeObj(evt.getOldValue(), true);
            }
            return;
        }
        JsonObject jsonObject = new JsonObject();
        String id = this.map.getId(source, true);
        Grammar grammar = this.map.getGrammar();
        grammar.writeBasicValue(jsonObject, source.getClass().getName(), id, this.map);
        if (oldValue != null) {
            creatorClass = this.map.getCreatorClass(oldValue);
            child = new JsonObject();
            if (creatorClass != null) {
                String oldId = this.map.getId(oldValue, true);
                if (oldId != null) {
                    child.put(propertyName, new JsonObject().withValue("id", oldId));
                }
            } else {
                child.put(propertyName, oldValue);
            }
            jsonObject.put("rem", child);
        }
        if (newValue != null) {
            creatorClass = this.map.getCreatorClass(newValue);
            child = new JsonObject();
            if (creatorClass != null) {
                String key = this.map.getKey(newValue);
                if (key != null) {
                    JsonObject item = new JsonObject().withValue("class", newValue.getClass().getName()).withValue("id", key);
                    child.put(propertyName, item);
                } else {
                    JsonObject item = this.map.toJsonObject(newValue, this.updateFilter);
                    child.put(propertyName, item);
                    if (this.suspendIdList != null) {
                        this.suspendIdList.add(this.map.getId(newValue, true));
                    }
                }
            } else {
                child.put(propertyName, newValue);
            }
            jsonObject.put("upd", child);
        }
        if (this.suspendIdList == null) {
            this.map.notify(new SimpleEvent("new", jsonObject, evt, this.map));
        }
    }

    @Override
    public Object execute(Entity updateMessage, Filter filter) {
        Object refObject;
        SendableEntityCreator creator;
        String masterObjClassName;
        if (!updateMessage.has("upd") && !updateMessage.has("rem")) {
            return null;
        }
        if (this.map == null) {
            return null;
        }
        String id = updateMessage.getString("id");
        JsonObject remove = (JsonObject)updateMessage.getValue("rem");
        JsonObject update = (JsonObject)updateMessage.getValue("upd");
        Object masterObj = this.map.getObject(id);
        if (masterObj == null && (masterObjClassName = (String)updateMessage.getValue("class")) != null && (masterObj = (creator = this.map.getCreator(masterObjClassName, true, null)).getSendableInstance(false)) != null) {
            this.map.put(id, masterObj, false);
        }
        if (masterObj == null) {
            return null;
        }
        SendableEntityCreator creator2 = this.map.getCreatorClass(masterObj);
        if (remove == null && update != null) {
            refObject = creator2.getSendableInstance(true);
            SimpleIteratorSet<String, Object> i = new SimpleIteratorSet<String, Object>(update);
            while (i.hasNext()) {
                Object item = i.next();
                String key = (String)item.getKey();
                Object value = creator2.getValue(masterObj, key);
                if (value == null) {
                    return this.setValue(creator2, masterObj, key, item.getValue(), "new");
                }
                if (!value.equals(creator2.getValue(refObject, key))) continue;
                return this.setValue(creator2, masterObj, key, update.get(key), "new");
            }
            return true;
        }
        if (update == null && remove != null) {
            refObject = creator2.getSendableInstance(true);
            Iterator keys = remove.keyIterator();
            while (keys.hasNext()) {
                JsonObject removeJsonObject;
                String key = (String)keys.next();
                Object value = creator2.getValue(masterObj, key);
                if (value instanceof Collection) {
                    removeJsonObject = remove.getJsonObject(key);
                    this.setValue(creator2, masterObj, key, removeJsonObject, "rem");
                } else if (this.checkValue(value, key, remove)) {
                    this.setValue(creator2, masterObj, key, creator2.getValue(refObject, key), "rem");
                }
                if ((removeJsonObject = remove.get(key)) == null || !(removeJsonObject instanceof JsonObject)) continue;
                JsonObject json = removeJsonObject;
                this.map.notify(new SimpleEvent("rem", json, this.map, key, this.map.decode(json), null).withModelValue(masterObj));
            }
            return masterObj;
        }
        if (update != null) {
            Iterator keys = update.keyIterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object oldValue = creator2.getValue(masterObj, key);
                if (!this.checkValue(oldValue, key, remove)) continue;
                Object newValue = update.get(key);
                this.setValue(creator2, masterObj, key, newValue, "upd");
                this.map.notify(new SimpleEvent("upd", update, this.map, key, oldValue, newValue).withModelValue(masterObj));
            }
            return masterObj;
        }
        return null;
    }

    private boolean checkValue(Object value, String key, JsonObject oldJsonObject) {
        Object oldValue = oldJsonObject.get(key);
        if (value != null) {
            if (oldValue instanceof JsonObject) {
                String oldId = (String)((JsonObject)oldValue).get("id");
                return oldId.equals(this.map.getId(value, true));
            }
            return value.equals(oldValue);
        }
        return oldValue == null;
    }

    private Object setValue(SendableEntityCreator creator, Object element, String key, Object newValue, String typ) {
        if (newValue instanceof JsonObject) {
            JsonObject json = (JsonObject)newValue;
            Object value = this.map.decode(json);
            if (value != null) {
                creator.setValue(element, key, value, typ);
                if (this.map.notify(new SimpleEvent(typ, json, this.map, key, null, value).withModelValue(element))) {
                    return element;
                }
            }
        } else {
            creator.setValue(element, key, newValue, typ);
            if (this.map.notify(new SimpleEvent(typ, null, this.map, key, null, newValue).withModelValue(element))) {
                return element;
            }
        }
        return null;
    }

    @Override
    public UpdateJson withFilter(Filter filter) {
        this.updateFilter = filter;
        return this;
    }

    @Override
    public Filter getFilter() {
        return this.updateFilter;
    }

    public boolean removeObj(Object oldValue, boolean destroy) {
        if (this.map != null) {
            return this.map.removeObj(oldValue, destroy);
        }
        return false;
    }
}

