/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.buffer;

import de.uniks.networkparser.buffer.BufferedBuffer;

public class CharacterBuffer
extends BufferedBuffer
implements CharSequence {
    char[] buffer;

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            return '\u0000';
        }
        return this.buffer[index += this.start];
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            return 0;
        }
        return (byte)this.buffer[(index += this.start) + this.start];
    }

    @Override
    public CharacterBuffer subSequence(int start, int end) {
        end += this.start;
        if ((start += this.start) < 0) {
            start = this.position();
        }
        if (end > this.buffer.length) {
            end = this.buffer.length;
        }
        return new CharacterBuffer().with(this.buffer, start, end, false);
    }

    public CharacterBuffer withValue(String value) {
        if (value != null) {
            this.buffer = value.toCharArray();
            this.length = this.buffer.length;
            this.start = 0;
            this.position = 0;
        }
        return this;
    }

    public char[] toCharArray() {
        char[] result = new char[this.length];
        for (int i = this.start; i < this.length; ++i) {
            result[i] = this.buffer[i];
        }
        return result;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this.length];
        for (int i = this.start; i < this.length; ++i) {
            result[i] = (byte)this.buffer[i];
        }
        return result;
    }

    public boolean replace(int start, int end, String replace) {
        int pos = 0;
        int diff = replace.length() - (end - start);
        char[] oldChar = null;
        int oldStart = 0;
        int oldLen = 0;
        if (this.length + diff > this.buffer.length) {
            int newCapacity = (this.length + diff) * 2 + 2;
            oldChar = this.buffer;
            char[] copy = new char[newCapacity];
            System.arraycopy(this.buffer, this.start, copy, 0, start);
            oldStart = end;
            oldLen = this.length - oldStart;
            this.buffer = copy;
            this.start = 0;
        }
        start += this.start;
        end += this.start;
        if (diff < 0) {
            while (start < end + diff) {
                this.buffer[start++] = replace.charAt(pos++);
            }
            System.arraycopy(this.buffer, start, this.buffer, start + diff, this.buffer.length - start);
        } else {
            while (start < end) {
                this.buffer[start++] = replace.charAt(pos++);
            }
            if (diff > 0) {
                if (oldChar == null) {
                    oldLen = this.length + this.start - start;
                    oldChar = new char[oldLen];
                    System.arraycopy(this.buffer, start, oldChar, 0, oldLen);
                }
                for (int no = 0; no < diff; ++no) {
                    this.buffer[start++] = replace.charAt(pos++);
                }
                if (oldLen > 0) {
                    System.arraycopy(oldChar, oldStart, this.buffer, start, oldLen);
                }
            }
        }
        this.length += diff;
        this.position = 0;
        return true;
    }

    public void replace(String search, String replace) {
        int deleted = 0;
        BufferedBuffer inserts = null;
        int pos = this.position + this.start;
        int len = this.length + this.start;
        int startSet = 0;
        while (pos < len) {
            int i;
            for (i = 0; i < search.length() && this.buffer[pos + i] == search.charAt(i); ++i) {
            }
            if (i == search.length()) {
                int diff = replace.length() - search.length();
                if (diff < 0) {
                    for (i = 0; i < replace.length(); ++i) {
                        this.buffer[pos + deleted + i] = replace.charAt(i);
                    }
                    deleted += diff;
                    pos += search.length();
                    continue;
                }
                if (inserts == null) {
                    for (i = 0; i < search.length(); ++i) {
                        this.buffer[pos + i] = replace.charAt(i);
                    }
                    inserts = new CharacterBuffer();
                    deleted += replace.length() - i;
                    startSet = pos += i;
                } else {
                    i = 0;
                    deleted += replace.length() - search.length();
                    pos += search.length();
                }
                while (i < replace.length()) {
                    ((CharacterBuffer)inserts).with(replace.charAt(i));
                    ++i;
                }
                continue;
            }
            if (deleted != 0) {
                if (deleted < 0) {
                    this.buffer[pos + deleted] = this.buffer[pos];
                } else {
                    ((CharacterBuffer)inserts).with(this.buffer[pos + i]);
                }
            }
            ++pos;
        }
        pos = pos + deleted - this.start;
        if (inserts != null) {
            if (this.length < pos) {
                char[] copy = new char[pos];
                System.arraycopy(this.buffer, this.start, copy, 0, startSet -= this.start);
                this.buffer = copy;
                this.start = 0;
            }
            for (int i = 0; i < inserts.length(); ++i) {
                this.buffer[startSet + i] = ((CharacterBuffer)inserts).charAt(i);
            }
        }
        this.length = pos;
    }

    @Override
    public char getChar() {
        if (this.buffer == null) {
            return '\u0000';
        }
        if (this.position + this.start >= this.buffer.length) {
            return '\u0000';
        }
        if (this.position < this.length) {
            ++this.position;
        }
        if (this.position + this.start == this.buffer.length) {
            return '\u0000';
        }
        char c = this.buffer[this.position + this.start];
        return c;
    }

    public CharacterBuffer with(byte[] values) {
        this.buffer = new char[values.length];
        this.start = 0;
        this.length = values.length;
        this.position = 0;
        for (int i = 0; i < values.length; ++i) {
            this.buffer[i] = (char)values[i];
        }
        return this;
    }

    public CharacterBuffer withLine(CharSequence value) {
        this.with(value);
        this.with("\r\n");
        return this;
    }

    @Override
    public CharacterBuffer withLength(int len) {
        this.withBufferLength(len);
        super.withLength(len);
        return this;
    }

    public CharacterBuffer withBufferLength(int len) {
        if (this.buffer == null) {
            this.buffer = new char[len];
        } else if (len + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[len];
            System.arraycopy(oldValue, this.start, this.buffer, 0, this.length);
            this.start = 0;
            this.position = 0;
        }
        return this;
    }

    public CharacterBuffer withStartPosition(int pos) {
        int diff = pos - this.start;
        this.start = pos;
        this.length = this.length > diff ? (this.length -= diff) : 0;
        return this;
    }

    public CharacterBuffer with(char[] values, int start, int end, boolean copy) {
        if (copy) {
            this.buffer = new char[end];
            this.start = 0;
            this.position = 0;
            this.length = end;
            System.arraycopy(values, start, this.buffer, 0, end);
        } else {
            this.buffer = values;
            this.start = start;
            this.length = end - start;
        }
        return this;
    }

    public CharacterBuffer with(char[] values, int start, int length) {
        int newLen = length + this.length;
        if (this.buffer == null || newLen + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[newLen * 2 + 2];
            if (oldValue != null) {
                System.arraycopy(oldValue, start, this.buffer, 0, this.length);
            }
            this.start = 0;
            this.position = 0;
        }
        System.arraycopy(values, start, this.buffer, this.length, length);
        this.length = newLen;
        return this;
    }

    public CharacterBuffer write(byte[] values, int length) {
        int newLen = length + this.length;
        if (this.buffer == null || newLen + this.start > this.buffer.length) {
            char[] oldValue = this.buffer;
            this.buffer = new char[newLen * 2 + 2];
            if (oldValue != null) {
                System.arraycopy(oldValue, this.start, this.buffer, 0, this.length);
            }
            this.start = 0;
            this.position = 0;
        }
        for (int i = this.length; i < newLen; ++i) {
            this.buffer[i] = (char)values[i - this.length];
        }
        this.length = newLen;
        return this;
    }

    public CharacterBuffer with(CharSequence values, int start, int end) {
        if (this.buffer == null) {
            this.buffer = new char[end];
            start = 0;
            this.length = end;
            this.position = 0;
            System.arraycopy(values, start, this.buffer, 0, end);
        } else {
            if (this.length + values.length() > this.buffer.length) {
                int newCapacity = (this.length + values.length()) * 2 + 2;
                char[] copy = new char[newCapacity];
                System.arraycopy(this.buffer, this.start, copy, 0, this.length);
                this.buffer = copy;
                this.start = 0;
            }
            int len = values.length();
            for (int c = 0; c < len; ++c) {
                this.buffer[this.length + start + c] = values.charAt(c);
            }
            this.length += len;
        }
        return this;
    }

    public CharacterBuffer with(CharSequence ... items) {
        if (items == null) {
            return this;
        }
        if (this.buffer == null) {
            int newCapubility = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                newCapubility += items[i].length();
            }
            this.buffer = new char[newCapubility];
            this.start = 0;
            this.length = this.buffer.length;
            int pos = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                int len = items[i].length();
                for (int c = 0; c < len; ++c) {
                    this.buffer[pos++] = items[i].charAt(c);
                }
            }
        } else {
            for (CharSequence item : items) {
                if (item == null) continue;
                this.with(item, 0, item.length());
            }
        }
        return this;
    }

    public CharacterBuffer with(int value) {
        String bytes = "" + value;
        this.with(bytes);
        return this;
    }

    public CharacterBuffer with(long value) {
        String bytes = "" + value;
        this.with(bytes);
        return this;
    }

    public CharacterBuffer withStart(char item) {
        if (this.start > 0) {
            this.buffer[--this.start] = item;
        } else {
            char[] oldValue = this.buffer;
            this.buffer = new char[this.buffer.length + 1];
            this.buffer[0] = item;
            this.position = 0;
            System.arraycopy(oldValue, this.start, this.buffer, 1, this.length);
            ++this.length;
        }
        return this;
    }

    public CharacterBuffer set(CharSequence value) {
        this.start = 0;
        this.length = value.length();
        if (this.buffer == null || this.buffer.length < value.length()) {
            this.buffer = new char[this.length];
        }
        for (int i = 0; i < this.length; ++i) {
            this.buffer[i] = value.charAt(i);
        }
        return this;
    }

    public CharacterBuffer set(char value) {
        this.start = 0;
        this.length = 1;
        if (this.buffer.length < 1) {
            this.buffer = new char[1];
        }
        this.buffer[0] = value;
        return this;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0, false);
    }

    public boolean startsWith(CharSequence prefix, int toffset, boolean ignoreCase) {
        if (this.buffer == null) {
            return false;
        }
        char[] ta = this.buffer;
        int to = toffset + this.start;
        int pc = prefix.length();
        if (toffset < 0 || toffset > this.buffer.length - pc) {
            return false;
        }
        int po = 0;
        while (--pc >= 0) {
            char c2;
            char c1;
            if ((c1 = ta[to++]) == (c2 = prefix.charAt(po++)) || ignoreCase && Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int remaining() {
        return this.buffer.length - this.start;
    }

    public final void clear() {
        this.length = 0;
        this.start = 0;
        this.position = 0;
    }

    public char remove(int position) {
        char oldChar = this.buffer[position];
        if (position == this.start) {
            ++this.start;
            return this.buffer[position];
        }
        if (position != this.length) {
            char[] copy = new char[this.buffer.length];
            System.arraycopy(this.buffer, this.start, copy, 0, position - 1);
            System.arraycopy(this.buffer, position + 1, copy, position, this.length - position);
            this.start = 0;
        }
        --this.length;
        return oldChar;
    }

    public CharacterBuffer addStart(int pos) {
        this.start += pos;
        this.length -= pos;
        return this;
    }

    public CharacterBuffer trimStart(int pos) {
        this.start += pos;
        this.length -= pos;
        return this;
    }

    public CharacterBuffer trim() {
        while (this.length > 0 && this.buffer[this.length + this.start - 1] <= ' ') {
            --this.length;
        }
        while (this.start < this.length && this.buffer[this.start] <= ' ') {
            ++this.start;
            --this.length;
        }
        return this;
    }

    public boolean isEmptyCharacter() {
        int len;
        if (super.isEmpty()) {
            return true;
        }
        int pos = this.start;
        for (len = this.length; len > 0 && this.buffer[len + pos - 1] <= ' '; --len) {
        }
        while (pos < len && this.buffer[pos] <= ' ') {
            ++pos;
            --len;
        }
        return len == 0;
    }

    public void withRepeat(String string, int rest) {
        int newCapacity = this.length + rest * string.length();
        if (this.buffer == null) {
            this.buffer = new char[newCapacity];
            this.start = 0;
            this.length = 0;
        } else if (newCapacity > this.buffer.length) {
            char[] copy = new char[newCapacity];
            System.arraycopy(this.buffer, this.start, copy, 0, this.length);
            this.buffer = copy;
            this.start = 0;
        }
        for (int i = 0; i < rest; ++i) {
            for (int c = 0; c < string.length(); ++c) {
                this.buffer[this.length++] = string.charAt(c);
            }
        }
    }

    public CharacterBuffer withObjects(Object ... items) {
        if (items == null) {
            return this;
        }
        if (this.buffer == null) {
            int newCapubility = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                if (!(items[i] instanceof CharSequence)) {
                    items[i] = items[i].toString();
                }
                newCapubility += ((CharSequence)items[i]).length();
            }
            this.buffer = new char[newCapubility];
            this.start = 0;
            this.length = this.buffer.length;
            int pos = 0;
            for (int i = 0; i < items.length; ++i) {
                if (items[i] == null) continue;
                CharSequence value = (CharSequence)items[i];
                int len = value.length();
                for (int c = 0; c < len; ++c) {
                    this.buffer[pos++] = value.charAt(c);
                }
            }
        } else {
            for (Object item : items) {
                CharSequence value = null;
                if (item instanceof CharSequence) {
                    value = (CharSequence)item;
                } else if (item != null) {
                    value = item.toString();
                }
                if (value == null) continue;
                this.with(value, 0, value.length());
            }
        }
        return this;
    }

    public CharacterBuffer with(char src) {
        if (this.buffer == null) {
            this.buffer = new char[5];
            this.start = 0;
            this.length = 1;
            this.buffer[0] = src;
        } else {
            if (this.length + 1 > this.buffer.length) {
                int newCapacity = this.buffer.length * 2 + 2;
                char[] copy = new char[newCapacity];
                System.arraycopy(this.buffer, this.start, copy, 0, this.length);
                this.buffer = copy;
                this.start = 0;
            }
            this.buffer[this.length++] = src;
        }
        return this;
    }

    public void reset() {
        this.length = 0;
        this.position = 0;
        this.start = 0;
    }

    @Override
    public String toString() {
        if (this.length < 1) {
            return "";
        }
        return new String(this.buffer, this.start, this.length);
    }

    public boolean equals(CharSequence other) {
        if (other == null || other.length() != this.length) {
            return false;
        }
        return this.startsWith(other, 0, false);
    }

    public boolean equalsIgnoreCase(CharSequence other) {
        if (other == null || other.length() != this.length) {
            return false;
        }
        return this.startsWith(other, 0, true);
    }

    public int indexOf(int ch) {
        return this.indexOf(ch, 0);
    }

    public int indexOf(String ch) {
        int pos = 0;
        for (int i = 0; i < ch.length() && (pos = this.indexOf(ch.charAt(i), pos)) >= 0; ++i) {
        }
        return pos;
    }

    public int indexOf(int ch, int fromIndex) {
        int max = this.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.length) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            if (this.buffer[i + this.start] != ch) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char ch) {
        for (int i = this.length - 1; i >= this.start; --i) {
            if (this.buffer[i] != ch) continue;
            return i - this.start;
        }
        return -1;
    }

    public String getStringPart(Character start, Character end) {
        int count = 1;
        Character current = null;
        int pos = this.getCurrentChar() == start.charValue() ? this.position() : this.position() - 1;
        while (!this.isEnd()) {
            current = Character.valueOf(this.getChar());
            if (current.compareTo(end) == 0) {
                if (--count != 0) continue;
                this.skip();
                return this.subSequence(pos, this.position()).toString();
            }
            if (current.compareTo(start) != 0) continue;
            ++count;
        }
        return null;
    }

    public boolean endsWith(CharSequence string, boolean ignoreCase) {
        int pos = this.length() - string.length();
        if (pos < 0) {
            return false;
        }
        return this.startsWith(string, pos, ignoreCase);
    }

    public void setNextString(CharSequence property, int pos) {
        this.withLength(pos);
        this.start = 0;
        this.with(property);
    }

    public static CharacterBuffer create(CharSequence value) {
        if (value instanceof CharacterBuffer) {
            return (CharacterBuffer)value;
        }
        CharacterBuffer buffer = new CharacterBuffer();
        if (value instanceof String) {
            buffer.with(value);
        }
        return buffer;
    }

    public String toCurrentString() {
        if (this.length < 1) {
            return "";
        }
        return new String(this.buffer, this.position, this.length - this.position);
    }
}

