/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;

public class IfCondition
implements ObjectCondition,
SendableEntityCreator {
    public static final String EXPRESSION = "expression";
    public static final String TRUECONDITION = "truecondition";
    public static final String FALSECONDITION = "falsecondition";
    private ObjectCondition expression;
    private ObjectCondition trueCondition;
    private ObjectCondition falseCondition;

    public IfCondition withExpression(ObjectCondition value) {
        this.expression = value;
        return this;
    }

    public ObjectCondition getExpression() {
        return this.expression;
    }

    public IfCondition withTrue(ObjectCondition condition) {
        this.trueCondition = condition;
        return this;
    }

    public ObjectCondition getTrue() {
        return this.trueCondition;
    }

    public IfCondition withFalse(ObjectCondition condition) {
        this.falseCondition = condition;
        return this;
    }

    public ObjectCondition getFalse() {
        return this.falseCondition;
    }

    @Override
    public boolean update(Object evt) {
        if (this.expression != null && this.expression.update(evt)) {
            if (this.trueCondition != null) {
                return this.trueCondition.update(evt);
            }
            return true;
        }
        if (this.falseCondition != null) {
            this.falseCondition.update(evt);
        }
        return false;
    }

    @Override
    public String[] getProperties() {
        return new String[]{EXPRESSION, TRUECONDITION, FALSECONDITION};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new IfCondition();
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (EXPRESSION.equalsIgnoreCase(attribute)) {
            return ((IfCondition)entity).getExpression();
        }
        if (TRUECONDITION.equalsIgnoreCase(attribute)) {
            return ((IfCondition)entity).getTrue();
        }
        if (FALSECONDITION.equalsIgnoreCase(attribute)) {
            return ((IfCondition)entity).getFalse();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (EXPRESSION.equalsIgnoreCase(attribute)) {
            ((IfCondition)entity).withExpression((ObjectCondition)value);
            return true;
        }
        if (TRUECONDITION.equalsIgnoreCase(attribute)) {
            ((IfCondition)entity).withTrue((ObjectCondition)value);
            return true;
        }
        if (FALSECONDITION.equalsIgnoreCase(attribute)) {
            ((IfCondition)entity).withFalse((ObjectCondition)value);
            return true;
        }
        return false;
    }
}

