/*
 * Decompiled with CFR 0.152.
 */
package de.uniks.networkparser.logic;

import de.uniks.networkparser.buffer.BufferedBuffer;
import de.uniks.networkparser.interfaces.ObjectCondition;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.beans.PropertyChangeEvent;

public class Equals
implements ObjectCondition,
SendableEntityCreator {
    public static final String PROPERTY_KEY = "key";
    public static final String PROPERTY_VALUE = "value";
    public static final String PROPERTY_POSITION = "position";
    private String key;
    private Object value;
    private Object delta;
    private int position = -1;

    @Override
    public boolean update(Object evt) {
        SimpleKeyValueList keyValueList;
        Object value;
        if (evt == null) {
            return this.value == null;
        }
        if (this.value == null) {
            return evt == null;
        }
        if (evt instanceof SimpleKeyValueList && (value = (keyValueList = (SimpleKeyValueList)evt).get(this.key)) != null) {
            return value.equals(this.value);
        }
        if (!(evt instanceof PropertyChangeEvent)) {
            if (this.value instanceof Number && evt instanceof Number) {
                Number evtValue;
                Number expValue;
                if (this.value instanceof Byte || this.value instanceof Short || this.value instanceof Integer || this.value instanceof Long) {
                    expValue = (Long)this.value;
                    evtValue = (Long)evt;
                    if (this.delta != null) {
                        Long deltaValue = (Long)this.delta;
                        return (Long)expValue - deltaValue <= (Long)evtValue && (Long)expValue + deltaValue >= (Long)evtValue;
                    }
                    return expValue == evtValue;
                }
                expValue = (Double)this.value;
                evtValue = (Double)evt;
                if (this.delta != null) {
                    Double deltaValue = (Double)this.delta;
                    return (Double)expValue - deltaValue <= (Double)evtValue && (Double)expValue + deltaValue >= (Double)evtValue;
                }
                return expValue == evtValue;
            }
            return this.value.equals(evt);
        }
        PropertyChangeEvent event = (PropertyChangeEvent)evt;
        if (event.getSource() instanceof BufferedBuffer && this.value instanceof Byte) {
            Byte btrValue = (Byte)this.value;
            BufferedBuffer buffer = (BufferedBuffer)event.getSource();
            int pos = this.position < 0 ? buffer.position() : this.position;
            return buffer.byteAt(pos) == btrValue.byteValue();
        }
        if (event.getPropertyName() == null) {
            return false;
        }
        return event.getPropertyName().equals(this.value);
    }

    public Equals withPosition(int value) {
        this.position = value;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public Equals withValue(Object value) {
        this.value = value;
        return this;
    }

    public Equals withValue(Object value, Object delta) {
        this.withValue(value);
        this.withDelta(delta);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "==" + this.value + " ";
    }

    @Override
    public String[] getProperties() {
        return new String[]{PROPERTY_KEY, PROPERTY_VALUE, PROPERTY_POSITION};
    }

    @Override
    public Object getSendableInstance(boolean prototyp) {
        return new Equals();
    }

    public String getKey() {
        return this.key;
    }

    public Equals withKey(String key) {
        this.key = key;
        return this;
    }

    @Override
    public Object getValue(Object entity, String attribute) {
        if (PROPERTY_KEY.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getKey();
        }
        if (PROPERTY_VALUE.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getValue();
        }
        if (PROPERTY_POSITION.equalsIgnoreCase(attribute)) {
            return ((Equals)entity).getPosition();
        }
        return null;
    }

    @Override
    public boolean setValue(Object entity, String attribute, Object value, String type) {
        if (!(entity instanceof Equals)) {
            return false;
        }
        Equals element = (Equals)entity;
        if (PROPERTY_KEY.equalsIgnoreCase(attribute)) {
            element.withKey(String.valueOf(value));
            return true;
        }
        if (PROPERTY_VALUE.equalsIgnoreCase(attribute)) {
            element.withValue(value);
            return true;
        }
        if (PROPERTY_POSITION.equalsIgnoreCase(attribute)) {
            element.withPosition(Integer.parseInt("" + value));
            return true;
        }
        return false;
    }

    public Object getDelta() {
        return this.delta;
    }

    public Equals withDelta(Object delta) {
        this.delta = delta;
        return this;
    }

    public static Equals create(String key, Object value) {
        Equals condition = new Equals();
        condition.withKey(key);
        condition.withValue(value);
        return condition;
    }

    public static Equals createNullCondition() {
        return new Equals().withValue(null);
    }
}

